/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.PropertyChangeHandler;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.preferences.SyncViewerPreferencePage;
import org.eclipse.team.internal.ui.registry.SynchronizeParticipantDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public abstract class AbstractSynchronizeParticipant
extends PlatformObject
implements ISynchronizeParticipant {
    public static final String P_PINNED = "org.eclipse.team.pinned";
    public static final String P_SCHEDULED = "org.eclipse.team.schedule";
    private static final String CTX_PINNED = "root";
    private PropertyChangeHandler fChangeHandler;
    private String fName;
    private String fId;
    private String fSecondaryId;
    private boolean pinned;
    private ImageDescriptor fImageDescriptor;
    private String fHelpContextId;
    protected IConfigurationElement configElement;

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.fImageDescriptor;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getSecondaryId() {
        return this.fSecondaryId;
    }

    @Override
    public String getHelpContextId() {
        return this.fHelpContextId == null ? "org.eclipse.team.ui.sync_view_context" : this.fHelpContextId;
    }

    @Override
    public final void setPinned(boolean pinned) {
        this.pinned = pinned;
        this.pinned(pinned);
        this.firePropertyChange(this, P_PINNED, !pinned, pinned);
    }

    @Override
    public final boolean isPinned() {
        return this.pinned;
    }

    protected void pinned(boolean pinned) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ISynchronizeParticipant)) {
            return false;
        }
        ISynchronizeParticipant other = (ISynchronizeParticipant)obj;
        return this.getId().equals(other.getId()) && Utils.equalObject(this.getSecondaryId(), other.getSecondaryId());
    }

    public int hashCode() {
        return Utils.getKey(this.getId(), this.getSecondaryId()).hashCode();
    }

    public boolean doesSupportSynchronize() {
        return true;
    }

    @Override
    public synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fChangeHandler == null) {
            this.fChangeHandler = new PropertyChangeHandler();
        }
        this.fChangeHandler.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fChangeHandler != null) {
            this.fChangeHandler.removePropertyChangeListener(listener);
        }
    }

    public void firePropertyChange(Object source, String property, Object oldValue, Object newValue) {
        if (this.fChangeHandler == null) {
            return;
        }
        this.fChangeHandler.firePropertyChange(source, property, oldValue, newValue);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String strIcon;
        this.configElement = config;
        this.fId = config.getAttribute("id");
        this.fName = config.getAttribute("name");
        if (this.fName == null) {
            this.fName = "Unknown";
        }
        if ((strIcon = config.getAttribute("icon")) != null) {
            this.fImageDescriptor = TeamImages.getImageDescriptorFromExtension(this.configElement.getDeclaringExtension(), strIcon);
        }
        this.fHelpContextId = this.configElement.getAttribute("helpContextId");
    }

    protected void setInitializationData(ISynchronizeParticipantDescriptor descriptor) throws CoreException {
        if (!(descriptor instanceof SynchronizeParticipantDescriptor)) {
            throw new TeamException(TeamUIMessages.AbstractSynchronizeParticipant_4);
        }
        this.setInitializationData(((SynchronizeParticipantDescriptor)descriptor).getConfigurationElement(), null, null);
    }

    protected void setName(String name) {
        String old = this.fName;
        this.fName = name;
        this.firePropertyChange(this, "org.eclipse.jface.text", old, name);
    }

    protected void setImageDescriptor(ImageDescriptor imageDescriptor) {
        ImageDescriptor old = this.fImageDescriptor;
        this.fImageDescriptor = imageDescriptor;
        this.firePropertyChange(this, "org.eclipse.jface.image", old, imageDescriptor);
    }

    protected void setSecondaryId(String secondaryId) {
        this.fSecondaryId = secondaryId;
    }

    @Override
    public void init(String secondaryId, IMemento memento) throws PartInitException {
        this.setSecondaryId(secondaryId);
        this.pinned = Boolean.parseBoolean(memento.getString(CTX_PINNED));
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putString(CTX_PINNED, Boolean.toString(this.pinned));
    }

    @Override
    public final ISynchronizePageConfiguration createPageConfiguration() {
        SynchronizePageConfiguration configuration = new SynchronizePageConfiguration(this);
        if (this.isViewerContributionsSupported()) {
            configuration.setProperty("org.eclipse.team.ui.P_OBJECT_CONTRIBUTION_ID", this.getId());
        }
        this.initializeConfiguration(configuration);
        return configuration;
    }

    protected abstract void initializeConfiguration(ISynchronizePageConfiguration var1);

    @Override
    public void prepareCompareInput(ISynchronizeModelElement element, CompareConfiguration config, IProgressMonitor monitor) throws TeamException {
        SyncInfo sync = this.getSyncInfo(element);
        if (sync != null) {
            Utils.updateLabels(sync, config, monitor);
        }
        if (element instanceof SyncInfoModelElement) {
            SyncInfoModelElement node = (SyncInfoModelElement)element;
            node.cacheContents(monitor);
        }
    }

    private SyncInfo getSyncInfo(ISynchronizeModelElement element) {
        if (element instanceof IAdaptable) {
            return (SyncInfo)((IAdaptable)element).getAdapter(SyncInfo.class);
        }
        return null;
    }

    @Override
    public PreferencePage[] getPreferencePages() {
        return new PreferencePage[]{new SyncViewerPreferencePage()};
    }

    protected boolean isViewerContributionsSupported() {
        return false;
    }
}

