/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.contols.POJOClassTabFolderPage;
import org.eclipse.birt.data.oda.pojo.ui.util.HelpUtil;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.birt.data.oda.pojo.util.URLParser;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ClassPathsPageHelper {
    public static final String DEFAULT_MSG = Messages.getString("DataSource.PageMessage");
    private WizardPage wizardPage;
    private ResourceIdentifiers ri;
    private Properties props;
    private Composite parent;
    private TabFolder tabFolder;
    private Button synchronizeCheckbox;
    private POJOClassTabFolderPage runtimePage;
    private POJOClassTabFolderPage designtimePage;
    private boolean needsRefresh;
    private boolean synchronizeClassPath;

    public ClassPathsPageHelper(ResourceIdentifiers ri) {
        this.ri = ri;
    }

    public void setWizardPage(WizardPage page) {
        this.wizardPage = page;
    }

    public void setResourceIdentifiers(ResourceIdentifiers ri) {
        this.ri = ri;
    }

    public Properties collectCustomProperties(Properties properties) {
        if (properties == null) {
            return properties;
        }
        properties.put("pojoDataSetClassPath", this.runtimePage.getClassPathString());
        properties.put("SynchronizeClassPath", String.valueOf(this.synchronizeClassPath));
        if (this.synchronizeClassPath) {
            properties.put("pojoClassPath", this.runtimePage.getClassPathString());
        } else {
            properties.put("pojoClassPath", this.designtimePage.getClassPathString());
        }
        return properties;
    }

    public void createPageCustomControl(Composite parent) {
        this.parent = parent;
        ScrolledComposite sComposite = new ScrolledComposite(parent, 768);
        sComposite.setLayout((Layout)new GridLayout());
        sComposite.setMinWidth(560);
        sComposite.setExpandHorizontal(true);
        sComposite.setMinHeight(400);
        sComposite.setExpandVertical(true);
        Composite composite = new Composite((Composite)sComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createTabFolderArea(composite);
        this.createCheckboxArea(composite);
        Point size = composite.computeSize(-1, -1);
        composite.setSize(size.x, size.y);
        sComposite.setContent((Control)composite);
        HelpUtil.setSystemHelp((Control)parent, "org.eclipse.birt.cshelp.Wizard_POJO_Datasource_ID");
    }

    protected boolean isPageInitialized() {
        return this.tabFolder != null && !this.tabFolder.isDisposed();
    }

    private void createCheckboxArea(Composite composite) {
        Composite bottom = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 5;
        bottom.setLayout((Layout)layout);
        bottom.setLayoutData((Object)new GridData(768));
        this.synchronizeCheckbox = new Button(bottom, 32);
        this.synchronizeCheckbox.setLayoutData((Object)new GridData());
        this.synchronizeCheckbox.setText(Messages.getString("DataSource.ClassPathPage.synchronize.checkbox.message"));
        this.synchronizeCheckbox.setToolTipText(Messages.getString("DataSource.ClassPathPage.synchronize.checkbox.tooltip"));
        this.synchronizeCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClassPathsPageHelper.this.synchronizeClassPath = ClassPathsPageHelper.this.synchronizeCheckbox.getSelection();
                ClassPathsPageHelper.this.handleSynchronizeCheckboxSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(bottom, 0);
        label.setText(Messages.getString("DataSource.ClassPathPage.synchronize.PrompMessage"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 30;
        label.setLayoutData((Object)gd);
        this.synchronizeCheckbox.setSelection(this.synchronizeClassPath);
        this.handleSynchronizeCheckboxSelection();
    }

    private void updateDesigntimePageStatus(boolean enabled) {
        this.designtimePage.setEnabled(enabled);
    }

    private void createTabFolderArea(Composite composite) {
        Composite tabArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        tabArea.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tabArea.setLayoutData((Object)gd);
        this.tabFolder = new TabFolder(tabArea, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.runtimePage = new POJOClassTabFolderPage(this, this.getApplResourceDir());
        this.runtimePage.setPrompMessage(Messages.getString("DataSource.POJOClassTabFolderPage.promptLabel.runtime"));
        TabItem runtimeTab = this.runtimePage.createContents(this.tabFolder);
        runtimeTab.setText(Messages.getString("DataSource.POJOClasses.tab.runtime"));
        this.designtimePage = new POJOClassTabFolderPage(this, this.getApplResourceDir());
        this.designtimePage.setPrompMessage(Messages.getString("DataSource.POJOClassTabFolderPage.promptLabel.designtime"));
        TabItem designTimeTab = this.designtimePage.createContents(this.tabFolder);
        designTimeTab.setText(Messages.getString("DataSource.POJOClasses.tab.designTime"));
        this.runtimePage.setFriendPage(this.designtimePage);
        this.designtimePage.setFriendPage(this.runtimePage);
        this.initControlValues();
    }

    protected void setInitialProperties(Properties dataSourceProps) {
        if (dataSourceProps != null) {
            this.props = dataSourceProps;
            this.needsRefresh = true;
        } else {
            this.props = new Properties();
        }
    }

    public void refresh() {
        if (this.needsRefresh && this.runtimePage != null && this.designtimePage != null) {
            String dataSetClassPath = this.props.getProperty("pojoDataSetClassPath");
            String pojoClassPath = this.props.getProperty("pojoClassPath");
            this.runtimePage.setClassPath(dataSetClassPath);
            this.designtimePage.setClassPath(pojoClassPath);
            this.runtimePage.refresh();
            this.designtimePage.refresh();
        }
        this.needsRefresh = false;
    }

    private void initControlValues() {
        if (this.runtimePage != null && this.props != null) {
            String dataSetClassPath = this.props.getProperty("pojoDataSetClassPath");
            String pojoClassPath = this.props.getProperty("pojoClassPath");
            String value = this.props.getProperty("SynchronizeClassPath");
            this.synchronizeClassPath = value != null ? Boolean.parseBoolean(value) : false;
            this.runtimePage.setClassPath(dataSetClassPath);
            this.designtimePage.setClassPath(pojoClassPath);
        }
        this.runtimePage.initClassPathElements();
        this.designtimePage.initClassPathElements();
    }

    private File getApplResourceDir() {
        if (this.ri != null && this.ri.getApplResourceBaseURI() != null) {
            return new File(this.ri.getApplResourceBaseURI());
        }
        return null;
    }

    public void updatePageStatus() {
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(this.runtimePage.canFinish() && this.designtimePage.canFinish());
        }
    }

    protected Runnable createTestConnectionRunnable(final IConnectionProfile profile) {
        return new Runnable(){

            @Override
            public void run() {
                IConnection conn = PingJob.createTestConnection((IConnectionProfile)profile);
                Throwable exception = PingJob.getTestConnectionException((IConnection)conn);
                if (exception == null) {
                    exception = this.testConnection();
                }
                PingJob.PingUIJob.showTestConnectionMessage((Shell)ClassPathsPageHelper.this.parent.getShell(), (Throwable)exception);
                if (conn != null) {
                    conn.close();
                }
            }

            private Throwable testConnection() {
                Throwable exception = null;
                exception = ClassPathsPageHelper.this.runtimePage.getClassPathString().length() == 0 ? new OdaException(Messages.getString("DataSource.MissDataSetPojoClassPath.runtime")) : (ClassPathsPageHelper.this.designtimePage.getClassPathString().length() == 0 ? new OdaException(Messages.getString("DataSource.MissDataSetPojoClassPath.designtime")) : this.validateAllJars(exception));
                return exception;
            }

            private Throwable validateAllJars(Throwable exception) {
                URL url;
                int n;
                int n2;
                URL[] uRLArray;
                URL[] urls;
                URLParser up = Utils.createURLParser(ClassPathsPageHelper.this.ri);
                try {
                    uRLArray = urls = up.parse(ClassPathsPageHelper.this.runtimePage.getClassPathString());
                    n2 = urls.length;
                    n = 0;
                    while (n < n2) {
                        url = uRLArray[n];
                        try {
                            url.openStream().close();
                        }
                        catch (IOException e) {
                            throw new OdaException(Messages.getFormattedString("DataSource.ClassPathPage.testConnection.failed.runtime", new Object[]{url.getFile()}));
                        }
                        ++n;
                    }
                }
                catch (OdaException e1) {
                    exception = e1;
                }
                if (exception != null) {
                    return exception;
                }
                try {
                    uRLArray = urls = up.parse(ClassPathsPageHelper.this.designtimePage.getClassPathString());
                    n2 = urls.length;
                    n = 0;
                    while (n < n2) {
                        url = uRLArray[n];
                        try {
                            url.openStream().close();
                        }
                        catch (IOException e) {
                            throw new OdaException(Messages.getFormattedString("DataSource.ClassPathPage.testConnection.failed.designtime", new Object[]{url.getFile()}));
                        }
                        ++n;
                    }
                }
                catch (OdaException e1) {
                    exception = e1;
                }
                return exception;
            }
        };
    }

    private void handleSynchronizeCheckboxSelection() {
        this.updateDesigntimePageStatus(!this.synchronizeClassPath);
        if (this.synchronizeClassPath) {
            this.designtimePage.resetJarElements(this.runtimePage.getJarElements());
        }
        this.updatePageStatus();
    }
}

