/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import org.eclipse.birt.report.debug.internal.core.launcher.IReportLaunchConstants;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ReportOSGiLaunchDelegate;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ReportStandardAppLaunchDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public class ReportApplicationLaunchDelegate
extends LaunchConfigurationDelegate
implements IReportLaunchConstants {
    private LaunchConfigurationDelegate delegate;

    private synchronized void ensureDelegate(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefaultEngineHome = configuration.getAttribute("use.default.engine.home", true);
        if (this.delegate == null || !this.match(useDefaultEngineHome)) {
            this.delegate = useDefaultEngineHome ? new ReportOSGiLaunchDelegate() : new ReportStandardAppLaunchDelegate();
        }
    }

    private boolean match(boolean useDefaultEngineHome) {
        if (useDefaultEngineHome) {
            return this.delegate instanceof ReportOSGiLaunchDelegate;
        }
        return this.delegate instanceof ReportStandardAppLaunchDelegate;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.ensureDelegate(configuration);
        this.delegate.launch(configuration, mode, launch, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.ensureDelegate(configuration);
        return this.delegate.preLaunchCheck(configuration, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.ensureDelegate(configuration);
        return this.delegate.finalLaunchCheck(configuration, mode, monitor);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        this.ensureDelegate(configuration);
        if (this.delegate instanceof ReportOSGiLaunchDelegate) {
            return ((ReportOSGiLaunchDelegate)this.delegate).getBuildOrder(configuration, mode);
        }
        return ((ReportStandardAppLaunchDelegate)this.delegate).getBuildOrder(configuration, mode);
    }
}

