/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.util;

import org.eclipse.birt.doc.util.HTMLParser;

public abstract class HtmlDocReader {
    protected HTMLParser parser = new HTMLParser();
    int pushToken = -2;

    protected int getToken() {
        if (this.pushToken == -2) {
            return this.parser.getToken();
        }
        int token = this.pushToken;
        this.pushToken = -2;
        return token;
    }

    protected void pushToken(int token) {
        this.pushToken = token;
    }

    protected void skipTo(String tag) {
        int token;
        while ((token = this.getToken()) != -1 && !this.isElement(token, tag)) {
        }
    }

    protected String getTextTo(String endTag) {
        return this.getTextTo(endTag, false);
    }

    protected boolean isBlockEnd(int token) {
        if (token != 3) {
            return false;
        }
        String tag = this.parser.getTokenText().toLowerCase();
        return tag.equals("h1") || tag.equals("h2") || tag.equals("h3") || tag.equals("/body") || tag.equals("/html");
    }

    protected String getTextTo(String endTag, boolean textOnly) {
        String startTag = null;
        if (endTag.startsWith("/")) {
            startTag = endTag.substring(1);
        }
        StringBuilder text = new StringBuilder();
        boolean inCode = false;
        while (true) {
            int token;
            if ((token = this.getToken()) == 1) {
                text.append(this.parser.getTokenText());
                continue;
            }
            if (token != 3) continue;
            String tag = this.parser.getTokenText().toLowerCase();
            if (tag.equals(endTag)) break;
            if (this.isBlockEnd(token) || startTag != null && tag.equalsIgnoreCase(startTag)) {
                this.pushToken(token);
                break;
            }
            if (textOnly && this.parser.isFormatTag()) continue;
            if (tag.equals("span")) {
                String classValue = this.parser.getAttrib("class");
                if (classValue == null || !classValue.equals("CodeText")) continue;
                inCode = true;
                text.append("<code>");
                continue;
            }
            if (tag.equals("/span") && inCode) {
                inCode = false;
                text.append("</code>");
                continue;
            }
            text.append(this.parser.getFullElement());
        }
        if (textOnly) {
            int posn = text.indexOf("\n");
            while (posn != -1) {
                text.setCharAt(posn, ' ');
                posn = text.indexOf("\n");
            }
            posn = text.indexOf("  ");
            while (posn != -1) {
                text.deleteCharAt(posn);
                posn = text.indexOf("  ");
            }
        }
        return text.toString().trim();
    }

    protected boolean isPara(int token, String className) {
        if (token != 3 || !this.parser.getTokenText().equalsIgnoreCase("p")) {
            return false;
        }
        if (className == null) {
            return true;
        }
        String pClass = this.parser.getAttrib("class");
        if (pClass == null) {
            return false;
        }
        return pClass.equalsIgnoreCase(className);
    }

    protected boolean isElement(int token, String tag) {
        if (token != 3) {
            return false;
        }
        return this.parser.getTokenText().equals(tag);
    }

    protected boolean startsWith(String line, String prefix) {
        if (line.length() < prefix.length()) {
            return false;
        }
        String test = line.substring(0, prefix.length());
        return test.equalsIgnoreCase(prefix);
    }

    protected String getTail(String line, String prefix) {
        String tail = line.substring(prefix.length());
        return tail.trim();
    }

    protected String strip(String text, String tag) {
        if (text.startsWith("<" + tag + ">")) {
            text = text.substring(tag.length() + 2);
        }
        if (text.endsWith("</" + tag + ">")) {
            text = text.substring(0, text.length() - tag.length() - 3);
        }
        return text;
    }

    protected String append(String value, String toAdd) {
        if (value == null) {
            return toAdd;
        }
        return String.valueOf(value) + toAdd;
    }

    public boolean isBlockEnd(String tag) {
        return tag.equals("h1") || tag.equals("h2") || tag.equals("h3") || tag.equals("h4") || tag.equals("h5") || tag.equals("/body") || tag.equals("/html");
    }

    public boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected String stripPara(String orig) {
        int len;
        if (orig == null) {
            return null;
        }
        StringBuilder text = new StringBuilder(orig);
        while ((len = text.length()) != 0) {
            if (Character.isWhitespace(text.charAt(0))) {
                text.deleteCharAt(0);
                continue;
            }
            if (Character.isWhitespace(text.charAt(len - 1))) {
                text.deleteCharAt(len - 1);
                continue;
            }
            if (len >= 3 && text.substring(0, 3).equalsIgnoreCase("<p>")) {
                text.delete(0, 3);
                continue;
            }
            if (len >= 6 && text.substring(0, 6).equalsIgnoreCase("&nbsp;")) {
                text.delete(0, 6);
                continue;
            }
            if (len >= 3 && text.substring(len - 3, len).equalsIgnoreCase("<p>")) {
                text.delete(len - 3, len);
                continue;
            }
            if (len >= 4 && text.substring(len - 4, len).equalsIgnoreCase("</p>")) {
                text.delete(len - 4, len);
                continue;
            }
            if (len < 6 || !text.substring(len - 6, len).equalsIgnoreCase("&nbsp;")) break;
            text.delete(len - 6, len);
        }
        return text.toString();
    }

    protected String copySection() {
        int token;
        this.parser.ignoreWhitespace(false);
        StringBuilder text = new StringBuilder();
        while ((token = this.getToken()) != -1) {
            if (token == 1) {
                text.append(this.parser.getTokenText());
                continue;
            }
            if (token != 3) continue;
            if (this.isBlockEnd(token)) {
                this.pushToken(token);
                break;
            }
            text.append(this.parser.getFullElement());
        }
        this.parser.ignoreWhitespace(true);
        return text.toString().trim();
    }
}

