/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverInfo;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JarFile;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class Utility {
    private static boolean updatedOfJarInfo = false;
    private static boolean updatedOfDriverInfo = false;

    private Utility() {
    }

    public static String toModeType(int type) {
        switch (type) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Input";
            }
            case 2: {
                return "Input/Output";
            }
            case 4: {
                return "Output";
            }
            case 5: {
                return "Return Value";
            }
        }
        return "Unknown";
    }

    public static Map getPreferenceStoredMap(String mapKey) {
        String driverMap64 = JdbcPlugin.getDefault().getPreferenceStore().getString(mapKey);
        try {
            byte[] bytes;
            ByteArrayInputStream bis;
            Object obj;
            if (driverMap64 != null && (obj = new ObjectInputStream(bis = new ByteArrayInputStream(bytes = Base64.decodeBase64((byte[])driverMap64.getBytes()))).readObject()) instanceof Map) {
                return Utility.updatePreferenceMap((Map)obj, mapKey);
            }
        }
        catch (IOException bytes) {
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        return new HashMap();
    }

    private static Map updatePreferenceMap(Map map, String mapKey) {
        if ("JDBC Driver Map".equals(mapKey)) {
            if (updatedOfDriverInfo) {
                return map;
            }
            updatedOfDriverInfo = true;
        } else if ("JDBC Jar List".equals(mapKey)) {
            if (updatedOfJarInfo) {
                return map;
            }
            updatedOfJarInfo = true;
        } else {
            return map;
        }
        Set entrySet = map.entrySet();
        Iterator it = entrySet.iterator();
        if (!it.hasNext()) {
            return map;
        }
        Map.Entry entry = it.next();
        if (entry.getValue() instanceof DriverInfo || entry.getValue() instanceof JarFile) {
            return map;
        }
        it = entrySet.iterator();
        HashMap rMap = new HashMap();
        if ("JDBC Driver Map".equals(mapKey)) {
            while (it.hasNext()) {
                entry = it.next();
                String[] entryValue = (String[])entry.getValue();
                DriverInfo driverInfo = new DriverInfo(entry.getKey().toString(), entryValue[0], entryValue[1]);
                rMap.put(entry.getKey(), driverInfo);
            }
        } else if ("JDBC Jar List".equals(mapKey)) {
            while (it.hasNext()) {
                entry = it.next();
                String[] entryValue = (String[])entry.getValue();
                JarFile jarFile = new JarFile(Utility.getFileNameFromFilePath(entryValue[0]), entryValue[0], "", false);
                rMap.put(entry.getKey(), jarFile);
            }
        }
        Utility.setPreferenceStoredMap("JDBC Driver Map", rMap);
        return rMap;
    }

    private static String getFileNameFromFilePath(String filePath) {
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + File.separator.length());
        return fileName;
    }

    public static void putPreferenceStoredMapValue(String keyOfPreference, String keyInMap, Object value) {
        Map map = Utility.getPreferenceStoredMap(keyOfPreference);
        map.put(keyInMap, value);
        Utility.setPreferenceStoredMap(keyOfPreference, map);
    }

    public static void removeMapEntryFromPreferenceStoredMap(String keyOfPreference, String keyInMap) {
        Map map = Utility.getPreferenceStoredMap(keyOfPreference);
        if (map.containsKey(keyInMap)) {
            map.remove(keyInMap);
        }
        Utility.setPreferenceStoredMap(keyOfPreference, map);
    }

    public static void setPreferenceStoredMap(String keyOfPreference, Map map) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            new ObjectOutputStream(bos).writeObject(map);
            byte[] bytes = bos.toByteArray();
            bytes = Base64.encodeBase64((byte[])bytes);
            JdbcPlugin.getDefault().getPreferenceStore().setValue(keyOfPreference, new String(bytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setSystemHelp(Control control, String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, contextId);
    }

    public static String quoteString(String quoted, String quoteFlag) {
        assert (quoteFlag != null);
        if (quoted == null) {
            return "";
        }
        return String.valueOf(quoteFlag) + quoted + quoteFlag;
    }
}

