/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.dialog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NewLibraryDialog
extends ResourceFileFolderSelectionDialog {
    private final File defaultLibrary;
    private Text text;
    private String ext = Messages.getString((String)"NewLibraryWizard.displayName.NewReportFileExtension").toLowerCase();
    private Status OKStatus = new Status(0, "org.eclipse.birt.report.designer.ui", 0, "", null);
    private Status ErrorStatus = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"NewResourceFileDialog.ErrorMessage"), null);
    private Status ErrorStatusNoSelection = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)""), null);
    private Status ErrorStatusInvalid = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"NewResourceFileDialog.ErrorMessageInvalid"), null);
    private String filename;

    public NewLibraryDialog() {
        this(null);
    }

    public String getFileName() {
        return this.filename;
    }

    public NewLibraryDialog(File defaultLibrary) {
        super(false, false, null);
        this.defaultLibrary = defaultLibrary;
        this.setTitle(Messages.getString((String)"NewLibraryDialog.Title"));
        this.setMessage(Messages.getString((String)"NewLibraryDialog.Message"));
        this.setDoubleClickSelects(true);
        this.setAllowMultiple(false);
        this.setValidator(new Validator());
        this.setEmptyFolderShowStatus(1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rt = (Composite)super.createDialogArea(parent);
        Composite pane = new Composite(rt, 0);
        Label lb = new Label(pane, 0);
        this.text = new Text(pane, 2048);
        lb.setText(Messages.getString((String)"NewLibraryDialog.label.NewLibrary"));
        rt.setLayoutData((Object)new GridData(1808));
        pane.setLayoutData((Object)new GridData(768));
        pane.setLayout((Layout)new GridLayout(2, false));
        pane.setLayoutData((Object)new GridData(768));
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLibraryDialog.this.filename = NewLibraryDialog.this.text.getText().trim().toLowerCase();
                NewLibraryDialog.this.updateOKStatus();
            }
        });
        if (this.defaultLibrary != null) {
            this.selectPath(this.defaultLibrary.getParent());
            this.text.setText(this.defaultLibrary.getName());
        }
        this.text.selectAll();
        this.text.setFocus();
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.NewLibraryWizard_ID");
        return rt;
    }

    private void selectPath(String path) {
        String parent = new File(path).getParent();
        ArrayList<String> folders = new ArrayList<String>();
        while (parent != null) {
            folders.add(parent);
            parent = new File(parent).getParent();
        }
        int i = folders.size() - 1;
        while (i >= 0) {
            this.getTreeViewer().expandToLevel(folders.get(i), 1);
            --i;
        }
        this.setInitialSelection(path);
    }

    public String getPath() {
        Object[] selected = this.getResult();
        if (selected != null && selected.length > 0 && selected[0] instanceof ResourceEntry) {
            ResourceEntry entry = (ResourceEntry)selected[0];
            if (entry == null) {
                return null;
            }
            try {
                File path = ResourceAction.convertToFile(entry.getURL());
                String filename = this.getFileName();
                File file = new Path(path.getAbsolutePath()).append(filename).toFile();
                return file.getAbsolutePath();
            }
            catch (IOException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        return null;
    }

    protected void okPressed() {
        File file;
        String path = this.getPath();
        if (path != null && (file = new File(path)).exists() && !MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)"Question", (String)Messages.getFormattedString((String)"NewResourceFileDialog.FileExists", (Object[])new String[]{file.getName()}))) {
            return;
        }
        super.okPressed();
    }

    private class Validator
    implements ISelectionStatusValidator {
        private Validator() {
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            if (nSelected != 1) {
                return NewLibraryDialog.this.ErrorStatusNoSelection;
            }
            String filename = NewLibraryDialog.this.getFileName();
            if (filename == null || filename.equals(NewLibraryDialog.this.ext)) {
                return NewLibraryDialog.this.ErrorStatusInvalid;
            }
            if (!filename.endsWith(NewLibraryDialog.this.ext)) {
                return NewLibraryDialog.this.ErrorStatus;
            }
            return NewLibraryDialog.this.OKStatus;
        }
    }
}

