/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.property.AbstractTitlePropertyDialog;
import org.eclipse.birt.report.designer.data.ui.property.PropertyNode;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.DatasetSelectionPage;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.GroupsPage;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.ICubePageNodeGenerator;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.LinkGroupsPage;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CubeBuilder
extends AbstractTitlePropertyDialog
implements IPreferencePageContainer {
    public static final String GROUPPAGE = "org.eclipse.birt.datasource.editor.cubebuilder.grouppage";
    public static final String DATASETSELECTIONPAGE = "org.eclipse.birt.datasource.editor.cubebuilder.datasetselectionpage";
    public static final String LINKGROUPSPAGE = "org.eclipse.birt.datasource.editor.cubebuilder.linkgroupspage";
    private TabularCubeHandle input;
    private String showNodeId;
    private boolean okEnable = true;
    private PropertyNode datasetNode;
    private PropertyNode groupsNode;
    private PropertyNode linkGroupNode;

    public CubeBuilder(Shell parentShell, TabularCubeHandle input) {
        super(parentShell, (Object)input);
        this.addCommonPage(input);
        this.input = input;
    }

    protected boolean needRememberLastSize() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }

    private void addCommonPage(TabularCubeHandle model) {
        this.datasetNode = new PropertyNode(DATASETSELECTIONPAGE, Messages.getString("DatasetPage.Title"), null, (IPropertyPage)new DatasetSelectionPage(this, (CubeHandle)model));
        this.groupsNode = new PropertyNode(GROUPPAGE, Messages.getString("GroupsPage.Title"), null, (IPropertyPage)new GroupsPage(this, model));
        this.linkGroupNode = new PropertyNode(LINKGROUPSPAGE, Messages.getString("LinkGroupsPage.Title"), null, (IPropertyPage)new LinkGroupsPage(this, (CubeHandle)model));
        this.addNodeTo("/", this.datasetNode);
        this.addNodeTo("/", this.groupsNode);
        this.addNodeTo("/", this.linkGroupNode);
        Object[] adapters = ElementAdapterManager.getAdapters((Object)model, ICubePageNodeGenerator.class);
        if (adapters != null) {
            int i = 0;
            while (i < adapters.length) {
                if (adapters[i] instanceof ICubePageNodeGenerator) {
                    ((ICubePageNodeGenerator)adapters[i]).createPropertyNode(this, model);
                }
                ++i;
            }
        }
    }

    public void showPage(String nodeId) {
        this.showNodeId = nodeId;
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performOk() {
        if (this.checkCubeLink()) {
            this.clearInvalidGroup();
            this.clearInvalidJoin();
            return true;
        }
        return false;
    }

    private void clearInvalidJoin() {
        Iterator iter = this.input.joinConditionsIterator();
        ArrayList<DimensionConditionHandle> invaildConditionList = new ArrayList<DimensionConditionHandle>();
        while (iter.hasNext()) {
            DimensionConditionHandle condition = (DimensionConditionHandle)iter.next();
            TabularHierarchyHandle conditionHierarchy = (TabularHierarchyHandle)condition.getHierarchy();
            if (conditionHierarchy == null) {
                invaildConditionList.add(condition);
                continue;
            }
            if (condition.getJoinConditions() != null) {
                Iterator iter1 = condition.getJoinConditions().iterator();
                ArrayList<DimensionJoinConditionHandle> invaildJoinList = new ArrayList<DimensionJoinConditionHandle>();
                while (iter1.hasNext()) {
                    DimensionJoinConditionHandle join = (DimensionJoinConditionHandle)iter1.next();
                    String primaryKey = join.getCubeKey();
                    String hierarchyKey = join.getHierarchyKey();
                    if (OlapUtil.getDataField(this.input.getDataSet(), primaryKey) == null) {
                        invaildJoinList.add(join);
                        continue;
                    }
                    if (OlapUtil.getDataField(conditionHierarchy.getDataSet(), hierarchyKey) != null) continue;
                    invaildJoinList.add(join);
                }
                if (!invaildJoinList.isEmpty()) {
                    int i = 0;
                    while (i < invaildJoinList.size()) {
                        try {
                            ((DimensionJoinConditionHandle)invaildJoinList.get(i)).drop();
                        }
                        catch (PropertyValueException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                        ++i;
                    }
                }
            }
            if (condition.getJoinConditions() != null && condition.getJoinConditions().iterator().hasNext()) continue;
            invaildConditionList.add(condition);
        }
        if (!invaildConditionList.isEmpty()) {
            int i = 0;
            while (i < invaildConditionList.size()) {
                try {
                    ((DimensionConditionHandle)invaildConditionList.get(i)).drop();
                }
                catch (PropertyValueException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                ++i;
            }
        }
    }

    private void clearInvalidGroup() {
        if (this.input != null) {
            DimensionHandle[] dimensions = this.input.getContents("dimensions").toArray(new DimensionHandle[0]);
            int i = 0;
            while (i < dimensions.length) {
                TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)dimensions[i].getDefaultHierarchy();
                if (hierarchy == null || hierarchy.getLevelCount() == 0) {
                    try {
                        dimensions[i].drop();
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    private boolean checkCubeLink() {
        ArrayList<TabularHierarchyHandle> childList = new ArrayList<TabularHierarchyHandle>();
        if (this.input != null) {
            DimensionHandle[] dimensions = this.input.getContents("dimensions").toArray(new DimensionHandle[0]);
            int i = 0;
            while (i < dimensions.length) {
                TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)dimensions[i].getDefaultHierarchy();
                if (hierarchy != null && hierarchy.getDataSet() != null && hierarchy.getDataSet() != this.input.getDataSet()) {
                    childList.add(hierarchy);
                }
                ++i;
            }
        }
        if (childList.size() == 0) {
            return true;
        }
        boolean flag = true;
        HashMap<HierarchyHandle, Integer> conditionMap = new HashMap<HierarchyHandle, Integer>();
        int i = 0;
        while (i < childList.size()) {
            flag = true;
            HierarchyHandle hierarchy = (HierarchyHandle)childList.get(i);
            Iterator iter = this.input.joinConditionsIterator();
            while (iter.hasNext()) {
                DimensionConditionHandle condition = (DimensionConditionHandle)iter.next();
                HierarchyHandle conditionHierarchy = condition.getHierarchy();
                if (!ModuleUtil.isEqualHierarchiesForJointCondition((HierarchyHandle)conditionHierarchy, (HierarchyHandle)hierarchy) || condition.getJoinConditions() == null) continue;
                Iterator iter1 = condition.getJoinConditions().iterator();
                while (iter1.hasNext()) {
                    iter1.next();
                    int number = conditionMap.containsKey(conditionHierarchy) ? (Integer)conditionMap.get(conditionHierarchy) : 0;
                    conditionMap.put(conditionHierarchy, ++number);
                    flag = false;
                }
            }
            if (flag) break;
            ++i;
        }
        if (flag) {
            conditionMap.clear();
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            MessageDialog d = new MessageDialog(this.getShell(), Messages.getString("MissLinkDialog.Title"), null, Messages.getString("MissLinkDialog.Question"), 4, buttons, 0);
            int result = d.open();
            if (result == 1) {
                return true;
            }
            this.showSelectionPage(this.getLinkGroupNode());
            return false;
        }
        conditionMap.clear();
        return true;
    }

    protected Control createContents(Composite parent) {
        String title = Messages.getString("CubeBuilder.Title");
        this.getShell().setText(title);
        if (this.showNodeId != null) {
            this.setDefaultNode(this.showNodeId);
        }
        Control control = super.createContents(parent);
        return control;
    }

    public void setOKEnable(boolean okEnable) {
        this.okEnable = okEnable;
        if (this.getOkButton() != null) {
            this.getOkButton().setEnabled(this.okEnable);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(this.okEnable);
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.getOkButton() != null) {
            if (((CubeHandle)this.getModel()).getName() != null && !((CubeHandle)this.getModel()).getName().trim().equals("")) {
                this.getOkButton().setEnabled(true);
            } else {
                this.getOkButton().setEnabled(false);
            }
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    protected Point getDefaultSize() {
        return new Point(820, 600);
    }

    public PropertyNode getLinkGroupNode() {
        return this.linkGroupNode;
    }

    public PropertyNode getDatasetNode() {
        return this.datasetNode;
    }

    public PropertyNode getGroupsNode() {
        return this.groupsNode;
    }
}

