/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class PublishTemplateWizard
extends Wizard {
    private static final String windowTitle = Messages.getString((String)"PublishTemplateAction.wizard.title");
    private static final String PAGE_TITLE = Messages.getString((String)"PublishTemplateAction.wizard.page.title");
    private static final String PAGE_DESC = Messages.getString((String)"PublishTemplateAction.wizard.page.desc");
    private WizardReportSettingPage page;
    private ReportDesignHandle handle;
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};

    public PublishTemplateWizard(ReportDesignHandle handle) {
        this.setWindowTitle(windowTitle);
        this.handle = handle;
    }

    public void addPages() {
        this.page = new WizardReportSettingPage(this.handle);
        this.page.setTitle(PAGE_TITLE);
        this.page.setPageDesc(PAGE_DESC);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        int overwrite;
        block12: {
            File targetFile;
            String templateFolderPath = ReportPlugin.getDefault().getTemplatePreference();
            String filePath = this.handle.getFileName();
            if (!new File(filePath).exists()) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), Messages.getString((String)"PublishTemplateAction.wizard.message.SourceFileNotExist"));
                return true;
            }
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            File targetFolder = new File(templateFolderPath);
            boolean folderExists = targetFolder.exists();
            if (!folderExists) {
                folderExists = targetFolder.mkdirs();
            }
            if (!folderExists) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), Messages.getString((String)"PublishTemplateAction.wizard.msgDirErr"));
                return true;
            }
            String targetFileName = fileName;
            if (ReportPlugin.getDefault().isReportDesignFile(fileName)) {
                int index = fileName.lastIndexOf(".");
                targetFileName = String.valueOf(fileName.substring(0, index)) + ".rpttemplate";
            }
            if (new File(filePath).compareTo(targetFile = new File(targetFolder, targetFileName)) == 0) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), Messages.getString((String)"PublishTemplateAction.wizard.message"));
                return true;
            }
            overwrite = 0;
            if (targetFile.exists()) {
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String question = Messages.getFormattedString((String)"SaveAsDialog.overwriteQuestion", (Object[])new Object[]{targetFile.getAbsolutePath()});
                MessageDialog d = new MessageDialog(this.getShell(), Messages.getString((String)"SaveAsDialog.Question"), null, question, 3, buttons, 0);
                overwrite = d.open();
            }
            if (overwrite != 0 || !targetFile.exists() && (targetFile.exists() || !targetFile.createNewFile())) break block12;
            this.copyFile(filePath, targetFile);
            try {
                this.setDesignFile(targetFile.getAbsolutePath());
            }
            catch (IOException | DesignFileException | SemanticException e) {
                ExceptionHandler.handle(e);
                return false;
            }
            try {
                IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
                if (synchronizer != null) {
                    synchronizer.notifyResourceChanged(new ReportResourceChangeEvent((Object)this, Path.fromOSString((String)targetFile.getAbsolutePath()), 1));
                }
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
        }
        return overwrite != 1;
    }

    private void setDesignFile(String fileName) throws DesignFileException, SemanticException, IOException {
        ReportDesignHandle newHandle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(fileName);
        if (!this.page.getDisplayName().equals("")) {
            newHandle.setDisplayName(this.page.getDisplayName());
        }
        newHandle.setProperty("description", (Object)this.page.getDescription());
        if (!this.page.getPreviewImagePath().equals("")) {
            newHandle.setIconFile(this.page.getPreviewImagePath());
            newHandle.deleteThumbnail();
        }
        newHandle.save();
        newHandle.close();
    }

    private void copyFile(String in, File targetFile) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(targetFile);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }
}

