/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.taglib.component.ViewerField;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtTagUtil {
    public static String convertBooleanValue(String bool) {
        boolean b = Boolean.parseBoolean(bool);
        return String.valueOf(b);
    }

    public static boolean convertToBoolean(String bool) {
        if (bool == null) {
            return false;
        }
        return Boolean.parseBoolean(bool);
    }

    public static String getFormat(String format) {
        if (format == null || format.length() <= 0 || format.equalsIgnoreCase("htm")) {
            return "html";
        }
        return format;
    }

    public static Locale getLocale(HttpServletRequest request, String sLocale) {
        Locale locale = ParameterAccessor.getLocaleFromString(sLocale);
        if (locale == null) {
            locale = request.getLocale();
        }
        if (locale == null) {
            locale = ParameterAccessor.getWebAppLocale();
        }
        return locale;
    }

    public static TimeZone getTimeZone(HttpServletRequest request, String sTimeZone) {
        TimeZone timeZone = ParameterAccessor.getTimeZoneFromString(sTimeZone);
        if (timeZone == null) {
            timeZone = ParameterAccessor.getWebAppTimeZone();
        }
        return timeZone;
    }

    public static String createAbsolutePath(String filePath) {
        if (filePath != null && filePath.trim().length() > 0 && ParameterAccessor.isRelativePath(filePath)) {
            return String.valueOf(ParameterAccessor.workingFolder) + File.separator + filePath;
        }
        return filePath;
    }

    public static IViewerReportDesignHandle getDesignHandle(HttpServletRequest request, ViewerField viewer) throws Exception {
        if (viewer == null) {
            return null;
        }
        BirtViewerReportDesignHandle design = null;
        IReportRunnable reportRunnable = null;
        String designFile = ParameterAccessor.getReport(request, viewer.getReportDesign());
        String documentFile = ParameterAccessor.getReportDocument(request, viewer.getReportDocument(), false);
        boolean isValidDocument = ParameterAccessor.isValidFilePath(request, viewer.getReportDocument());
        if (documentFile != null && isValidDocument) {
            try {
                IReportDocument reportDocumentInstance = ReportEngineService.getInstance().openReportDocument(designFile, documentFile, BirtTagUtil.getModuleOptions(viewer));
                if (reportDocumentInstance != null) {
                    viewer.setDocumentInUrl(true);
                    reportRunnable = reportDocumentInstance.getReportRunnable();
                    reportDocumentInstance.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (reportRunnable == null) {
            if (documentFile != null && designFile == null) {
                if (isValidDocument) {
                    throw new ViewerException("birt.viewer.generalException.DOCUMENT_FILE_ERROR", new String[]{documentFile});
                }
                throw new ViewerException("birt.viewer.generalException.DOCUMENT_ACCESS_ERROR", new String[]{documentFile});
            }
            if (!ParameterAccessor.isValidFilePath(request, viewer.getReportDesign())) {
                throw new ViewerException("birt.viewer.generalException.REPORT_ACCESS_ERROR", new String[]{designFile});
            }
            reportRunnable = BirtUtility.getRunnableFromDesignFile(request, designFile, BirtTagUtil.getModuleOptions(viewer));
            if (reportRunnable == null) {
                throw new ViewerException("birt.viewer.generalException.REPORT_FILE_ERROR", new String[]{new File(designFile).getName()});
            }
        }
        if (reportRunnable != null) {
            design = new BirtViewerReportDesignHandle("rptRunnableObject", reportRunnable);
        }
        return design;
    }

    public static Map getModuleOptions(ViewerField viewer) {
        if (viewer == null) {
            return null;
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        String resourceFolder = viewer.getResourceFolder();
        if (resourceFolder == null || resourceFolder.trim().length() <= 0) {
            resourceFolder = ParameterAccessor.birtResourceFolder;
        }
        options.put("resourceFolder", resourceFolder);
        options.put("semanticCheck", Boolean.FALSE);
        return options;
    }

    public static void writeScript(JspWriter writer, String content) throws IOException {
        writer.write("\n<script language=\"JavaScript\">\n");
        writer.write(content);
        writer.write("</script>\n");
    }

    public static void writeExtScript(JspWriter writer, String fileName) throws IOException {
        writer.write("<script src=\"" + fileName + "\" type=\"text/javascript\"></script>\n");
    }

    public static void writeExtScripts(JspWriter writer, String baseUrl, String[] files) throws IOException {
        int i = 0;
        while (i < files.length) {
            BirtTagUtil.writeExtScript(writer, String.valueOf(baseUrl) + files[i]);
            ++i;
        }
    }

    public static void writeOption(JspWriter writer, String label, String value, boolean selected) throws IOException {
        writer.write("<option ");
        writer.write(" value=\"" + ParameterAccessor.htmlEncode(value) + "\" ");
        if (selected) {
            writer.write(" selected ");
        }
        writer.write(">");
        writer.write(String.valueOf(ParameterAccessor.htmlEncode(label)) + "</option>\n");
    }
}

