/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.debug.internal.core.launcher.IReportLaunchConstants;
import org.eclipse.birt.report.debug.internal.core.launcher.ReportLauncher;
import org.eclipse.birt.report.debug.internal.ui.script.launcher.ScriptSWTFactory;
import org.eclipse.birt.report.debug.internal.ui.script.util.ScriptDebugUtil;
import org.eclipse.birt.report.debug.ui.DebugUI;
import org.eclipse.birt.report.debug.ui.i18n.Messages;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class ScriptMainTab
extends AbstractLaunchConfigurationTab
implements IReportLaunchConstants {
    private static final String DOCUMENT_FILE_EXT = "rptdocument";
    private static final String LIB_FOLDER = "lib";
    private static final String[] FILETYPE = new String[]{"jar", "zip"};
    private static final String DEV_PROJECTNAME = "org.eclipse.birt.report.debug.core";
    private Text fMainText;
    private Text fTempFolder;
    private Text fEngineHome;
    private Button bOpenTarget;
    private Button bRun;
    private Button bRender;
    private Button bRunAndRender;
    private Button bRunPlusRender;
    private Button bDebugJava;
    private Button bDebugScript;
    private Button bDebugAll;
    private Button engineHomeSearchButton;
    private Button engineHomeVariableButton;
    private Combo cmbOutputFormat;
    private Button bUseDefaultEngineHome;
    private String lastUsedPath;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ScriptMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    private SelectionListener taskTypeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!((Button)e.widget).getSelection()) {
                return;
            }
            if (e.widget == ScriptMainTab.this.bRun) {
                ScriptMainTab.this.bRender.setSelection(false);
                ScriptMainTab.this.bRunAndRender.setSelection(false);
                ScriptMainTab.this.bRunPlusRender.setSelection(false);
            } else if (e.widget == ScriptMainTab.this.bRender) {
                ScriptMainTab.this.bRun.setSelection(false);
                ScriptMainTab.this.bRunAndRender.setSelection(false);
                ScriptMainTab.this.bRunPlusRender.setSelection(false);
            } else if (e.widget == ScriptMainTab.this.bRunAndRender) {
                ScriptMainTab.this.bRun.setSelection(false);
                ScriptMainTab.this.bRender.setSelection(false);
                ScriptMainTab.this.bRunPlusRender.setSelection(false);
            } else if (e.widget == ScriptMainTab.this.bRunPlusRender) {
                ScriptMainTab.this.bRun.setSelection(false);
                ScriptMainTab.this.bRender.setSelection(false);
                ScriptMainTab.this.bRunAndRender.setSelection(false);
            }
            ScriptMainTab.this.bOpenTarget.setEnabled(e.widget != ScriptMainTab.this.bRun);
            ScriptMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    private SelectionListener debugTypeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!((Button)e.widget).getSelection()) {
                return;
            }
            if (e.widget == ScriptMainTab.this.bDebugJava) {
                ScriptMainTab.this.bDebugScript.setSelection(false);
                ScriptMainTab.this.bDebugAll.setSelection(false);
            } else if (e.widget == ScriptMainTab.this.bDebugScript) {
                ScriptMainTab.this.bDebugJava.setSelection(false);
                ScriptMainTab.this.bDebugAll.setSelection(false);
            } else if (e.widget == ScriptMainTab.this.bDebugAll) {
                ScriptMainTab.this.bDebugJava.setSelection(false);
                ScriptMainTab.this.bDebugScript.setSelection(false);
            }
            ScriptMainTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Composite parentG = ScriptSWTFactory.createComposite(parent, parent.getFont(), 1, 1, 1808);
        this.buildFileName(parentG);
        this.buildEngineHome(parentG);
        this.buildTempFolder(parentG);
        this.buildTypeArea(parentG);
        this.setControl((Control)parentG);
    }

    private void buildTypeArea(Composite parentG) {
        Font font = parentG.getFont();
        Composite pane = ScriptSWTFactory.createComposite(parentG, font, 3, 1, 768);
        this.buildTaskType(pane);
        this.buildDebugType(pane);
        this.buildOutputArea(pane);
    }

    private void buildOutputArea(Composite parentG) {
        Font font = parentG.getFont();
        Group outputGroup = ScriptSWTFactory.createGroup(parentG, Messages.getString("ScriptMainTab.msg.output"), 2, 1, 1808);
        ScriptSWTFactory.createLabel((Composite)outputGroup, Messages.getString("ScriptMainTab.msg.format"), font, 1);
        this.cmbOutputFormat = ScriptSWTFactory.createCombo((Composite)outputGroup, font, 1);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.widthHint = 100;
        this.cmbOutputFormat.setLayoutData((Object)gd);
        this.cmbOutputFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.bOpenTarget = ScriptSWTFactory.createCheckBox((Composite)outputGroup, Messages.getString("ScriptMainTab.msg.open.target.file"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 15;
        this.bOpenTarget.setLayoutData((Object)gd);
        this.bOpenTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void buildDebugType(Composite parentG) {
        Group debugTypeGroup = ScriptSWTFactory.createGroup(parentG, Messages.getString("ScriptMainTab.msg.debug.type"), 1, 1, 1808);
        this.bDebugAll = ScriptSWTFactory.createRadioButton((Composite)debugTypeGroup, Messages.getString("ScriptMainTab.msg.debug.type.all"));
        this.bDebugJava = ScriptSWTFactory.createRadioButton((Composite)debugTypeGroup, Messages.getString("ScriptMainTab.msg.debug.type.java"));
        this.bDebugScript = ScriptSWTFactory.createRadioButton((Composite)debugTypeGroup, Messages.getString("ScriptMainTab.msg.debug.type.script"));
        this.bDebugJava.addSelectionListener(this.debugTypeListener);
        this.bDebugScript.addSelectionListener(this.debugTypeListener);
        this.bDebugAll.addSelectionListener(this.debugTypeListener);
    }

    private void buildTaskType(Composite parentG) {
        Group taskTypeGroup = ScriptSWTFactory.createGroup(parentG, Messages.getString("ScriptMainTab.msg.task.type"), 1, 1, 1808);
        this.bRunAndRender = ScriptSWTFactory.createRadioButton((Composite)taskTypeGroup, Messages.getString("ScriptMainTab.msg.task.type.run.and.render"));
        this.bRun = ScriptSWTFactory.createRadioButton((Composite)taskTypeGroup, Messages.getString("ScriptMainTab.msg.task.type.run"));
        this.bRender = ScriptSWTFactory.createRadioButton((Composite)taskTypeGroup, Messages.getString("ScriptMainTab.msg.task.type.render"));
        this.bRunPlusRender = ScriptSWTFactory.createRadioButton((Composite)taskTypeGroup, Messages.getString("ScriptMainTab.msg.task.type.run.plus.render"));
        this.bRunAndRender.addSelectionListener(this.taskTypeListener);
        this.bRun.addSelectionListener(this.taskTypeListener);
        this.bRender.addSelectionListener(this.taskTypeListener);
        this.bRunPlusRender.addSelectionListener(this.taskTypeListener);
    }

    private void buildTempFolder(Composite parentG) {
        Font font = parentG.getFont();
        Group tempFolderGroup = ScriptSWTFactory.createGroup(parentG, Messages.getString("ScriptMainTab.msg.temp.folder"), 2, 1, 768);
        Composite folder = ScriptSWTFactory.createComposite((Composite)tempFolderGroup, font, 3, 2, 1808, 0, 0);
        this.fTempFolder = ScriptSWTFactory.createSingleText(folder, 1);
        this.fTempFolder.addModifyListener(this.modifyListener);
        Button forderSearchButton = this.createPushButton(folder, Messages.getString("ScriptMainTab.button.text.search"), null);
        forderSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = ScriptMainTab.this.chooseDropLocation(Messages.getString("ScriptMainTab.title.temp.folder"), Messages.getString("ScriptMainTab.msg.select.temp.folder"), ScriptMainTab.this.fTempFolder.getText());
                if (chosen != null) {
                    ScriptMainTab.this.fTempFolder.setText(chosen.toOSString());
                }
            }
        });
        this.createVariableButton(folder, Messages.getString("ScriptMainTab.button.text.variables"), this.fTempFolder);
    }

    private void buildEngineHome(Composite parentG) {
        Font font = parentG.getFont();
        Group engineHomeGroup = ScriptSWTFactory.createGroup(parentG, Messages.getString("ScriptMainTab.msg.engine.home"), 2, 1, 768);
        this.bUseDefaultEngineHome = ScriptSWTFactory.createCheckBox((Composite)engineHomeGroup, Messages.getString("ScriptMainTab.msg.use.default.engine.home"));
        GridData gd = new GridData(800);
        gd.horizontalSpan = 2;
        this.bUseDefaultEngineHome.setLayoutData((Object)gd);
        this.bUseDefaultEngineHome.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptMainTab.this.updateLaunchConfigurationDialog();
                ScriptMainTab.this.fEngineHome.setEnabled(!ScriptMainTab.this.bUseDefaultEngineHome.getSelection());
                ScriptMainTab.this.engineHomeSearchButton.setEnabled(!ScriptMainTab.this.bUseDefaultEngineHome.getSelection());
                ScriptMainTab.this.engineHomeVariableButton.setEnabled(!ScriptMainTab.this.bUseDefaultEngineHome.getSelection());
            }
        });
        Composite enginrHomeFolder = ScriptSWTFactory.createComposite((Composite)engineHomeGroup, font, 3, 2, 1808, 0, 0);
        this.fEngineHome = ScriptSWTFactory.createSingleText(enginrHomeFolder, 1);
        this.fEngineHome.addModifyListener(this.modifyListener);
        this.engineHomeSearchButton = this.createPushButton(enginrHomeFolder, Messages.getString("ScriptMainTab.button.text.search"), null);
        this.engineHomeSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = ScriptMainTab.this.chooseDropLocation(Messages.getString("ScriptMainTab.title.engine.home"), Messages.getString("ScriptMainTab.msg.select.engine.home"), ScriptMainTab.this.fEngineHome.getText());
                if (chosen != null) {
                    ScriptMainTab.this.fEngineHome.setText(chosen.toOSString());
                }
            }
        });
        this.engineHomeVariableButton = this.createVariableButton(enginrHomeFolder, Messages.getString("ScriptMainTab.button.text.variables"), this.fEngineHome);
    }

    private void buildFileName(Composite parentG) {
        Font font = parentG.getFont();
        Group mainGroup = ScriptSWTFactory.createGroup(parentG, Messages.getString("ScriptMainTab.msg.report.file.name"), 2, 1, 768);
        Composite comp = ScriptSWTFactory.createComposite((Composite)mainGroup, font, 3, 2, 1808, 0, 0);
        this.fMainText = ScriptSWTFactory.createSingleText(comp, 1);
        this.fMainText.addModifyListener(this.modifyListener);
        Button fSearchButton = this.createPushButton(comp, Messages.getString("ScriptMainTab.button.text.search"), null);
        fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                File chosen = ScriptMainTab.this.chooseReportDesign();
                if (chosen != null) {
                    ScriptMainTab.this.fMainText.setText(chosen.getAbsolutePath());
                }
            }
        });
        this.createVariableButton(comp, Messages.getString("ScriptMainTab.button.text.variables"), this.fMainText);
    }

    private IPath chooseDropLocation(String title, String message, String filterPath) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(filterPath);
        dialog.setText(title);
        dialog.setMessage(message);
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private File chooseReportDesign() {
        if (this.lastUsedPath == null) {
            this.lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setText(Messages.getString("ScriptMainTab.msg.select.report.file"));
        if (this.bRender.getSelection()) {
            dialog.setFilterExtensions(new String[]{"*.rptdocument"});
        } else {
            dialog.setFilterExtensions(new String[]{"*.rptdesign"});
        }
        dialog.setFilterPath(this.lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        Path filterPath = new Path(dialog.getFilterPath());
        this.lastUsedPath = dialog.getFilterPath();
        IPath path = null;
        int i = 0;
        if (i < 1) {
            path = filterPath.append(fileNames[i]).makeAbsolute();
            return path.toFile();
        }
        return null;
    }

    public String getName() {
        return Messages.getString("ScriptMainTab.title.report");
    }

    public Image getImage() {
        return DebugUI.getDefault().getImageRegistry().get("icons/full/ctool16/birtdebugger.gif");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String[] supportedFormats;
            this.fMainText.setText(configuration.getAttribute("report.file.name", this.getDefaultFileName()));
            this.fEngineHome.setText(configuration.getAttribute("engine.home", ""));
            this.fTempFolder.setText(configuration.getAttribute("temp.folder", this.getDefaultTempFolder()));
            this.bUseDefaultEngineHome.setSelection(configuration.getAttribute("use.default.engine.home", true));
            this.fEngineHome.setEnabled(!this.bUseDefaultEngineHome.getSelection());
            this.engineHomeSearchButton.setEnabled(!this.bUseDefaultEngineHome.getSelection());
            this.engineHomeVariableButton.setEnabled(!this.bUseDefaultEngineHome.getSelection());
            ReportEngine engine = new ReportEngine(new EngineConfig());
            EmitterInfo[] emitters = engine.getEmitterInfo();
            if (emitters == null || emitters.length == 0) {
                supportedFormats = new String[]{};
            } else {
                ArrayList<String> temp = new ArrayList<String>();
                int i = 0;
                while (i < emitters.length) {
                    EmitterInfo info = emitters[i];
                    if (!info.isHidden().booleanValue()) {
                        temp.add(info.getFormat());
                    }
                    ++i;
                }
                Collections.sort(temp, new AlphabeticallyComparator());
                supportedFormats = temp.toArray(new String[temp.size()]);
            }
            this.cmbOutputFormat.setItems(supportedFormats);
            String targetFormat = configuration.getAttribute("engine.target.format", "html");
            int idx = Arrays.asList(supportedFormats).indexOf(targetFormat);
            if (idx != -1) {
                this.cmbOutputFormat.select(idx);
            } else if (supportedFormats.length > 0) {
                this.cmbOutputFormat.select(0);
            }
            this.bOpenTarget.setSelection(configuration.getAttribute("open.target.file", false));
            int debugType = configuration.getAttribute("engine.debug.type", 2);
            int taskType = configuration.getAttribute("engine.task.type", 4);
            this.bDebugAll.setSelection(false);
            this.bDebugJava.setSelection(false);
            this.bDebugScript.setSelection(false);
            this.bRunAndRender.setSelection(false);
            this.bRun.setSelection(false);
            this.bRender.setSelection(false);
            this.bRunPlusRender.setSelection(false);
            if ((debugType & 3) == 3) {
                this.bDebugAll.setSelection(true);
            } else if ((debugType & 1) == 1) {
                this.bDebugJava.setSelection(true);
            } else {
                this.bDebugScript.setSelection(true);
            }
            if ((taskType & 3) == 3) {
                this.bRunPlusRender.setSelection(true);
            } else if ((taskType & 1) == 1) {
                this.bRun.setSelection(true);
            } else if ((taskType & 2) == 2) {
                this.bRender.setSelection(true);
            } else {
                this.bRunAndRender.setSelection(true);
            }
            this.bOpenTarget.setEnabled(!this.bRun.getSelection());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private String getDefaultFileName() {
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (handle != null) {
            return handle.getFileName();
        }
        return "";
    }

    private String getDefaultTempFolder() {
        return System.getProperty("java.io.tmpdir", "");
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("report.file.name", this.fMainText.getText());
        configuration.setAttribute("engine.home", this.fEngineHome.getText());
        configuration.setAttribute("temp.folder", this.fTempFolder.getText());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, ReportLauncher.class.getName());
        if (this.cmbOutputFormat.getItemCount() > 0 && this.cmbOutputFormat.getSelectionIndex() != -1) {
            configuration.setAttribute("engine.target.format", this.cmbOutputFormat.getItem(this.cmbOutputFormat.getSelectionIndex()));
        }
        configuration.setAttribute("open.target.file", this.bOpenTarget.getSelection());
        configuration.setAttribute("use.default.engine.home", this.bUseDefaultEngineHome.getSelection());
        int debugType = 2;
        if (this.bDebugJava.getSelection()) {
            debugType = 1;
        } else if (this.bDebugScript.getSelection()) {
            debugType = 2;
        } else if (this.bDebugAll.getSelection()) {
            debugType = 3;
        }
        int taskType = 4;
        if (this.bRunAndRender.getSelection()) {
            taskType = 4;
        } else if (this.bRunPlusRender.getSelection()) {
            taskType = 3;
        } else if (this.bRun.getSelection()) {
            taskType = 1;
        } else if (this.bRender.getSelection()) {
            taskType = 2;
        }
        configuration.setAttribute("engine.debug.type", debugType);
        configuration.setAttribute("engine.task.type", taskType);
        if (this.bUseDefaultEngineHome.getSelection()) {
            configuration.setAttribute("org.eclipse.birt.report.debug.core.launcher.CLASSPATH", null);
        } else {
            ArrayList list = new ArrayList();
            String libDirectory = this.getJarFolder();
            try {
                libDirectory = ScriptDebugUtil.getSubstitutedString(libDirectory);
            }
            catch (CoreException e) {
                libDirectory = this.getJarFolder();
            }
            this.addEngineLibHomeClassPath(libDirectory, list);
            this.addProjectClassPath(list);
            configuration.setAttribute("org.eclipse.birt.report.debug.core.launcher.CLASSPATH", list);
        }
    }

    private void addEngineLibHomeClassPath(String fileDirectory, List list) {
        File file = new File(fileDirectory);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        Path path = new Path(fileDirectory);
        String[] files = file.list();
        if (files == null) {
            return;
        }
        int len = files.length;
        int i = 0;
        while (i < len) {
            IPath temp = path.append(files[i]).makeAbsolute();
            if (temp.toFile().exists() && this.isJarFile(temp)) {
                try {
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)temp);
                    String mometo = entry.getMemento();
                    if (!list.contains(mometo)) {
                        list.add(mometo);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private void addProjectClassPath(List list) {
        String coreBin;
        IRuntimeClasspathEntry entry;
        String mometo;
        try {
            String path = ScriptDebugUtil.getPlugInFile(DEV_PROJECTNAME);
            if (path != null && !list.contains(mometo = (entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(path))).getMemento())) {
                list.add(mometo);
            }
        }
        catch (CoreException path) {
            // empty catch block
        }
        if ((coreBin = System.getProperty("CoreOutput")) != null) {
            try {
                entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(coreBin));
                mometo = entry.getMemento();
                if (!list.contains(mometo)) {
                    list.add(mometo);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private boolean isJarFile(IPath path) {
        String str = path.getFileExtension();
        int i = 0;
        while (i < FILETYPE.length) {
            if (FILETYPE[i].equals(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getJarFolder() {
        String str = this.fEngineHome.getText();
        File file = new File(str);
        return String.valueOf(file.getAbsolutePath()) + File.separator + LIB_FOLDER;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("report.file.name", this.getDefaultFileName());
        configuration.setAttribute("engine.home", "");
        configuration.setAttribute("temp.folder", this.getDefaultTempFolder());
        configuration.setAttribute("open.target.file", false);
        configuration.setAttribute("engine.target.format", "html");
        configuration.setAttribute("use.default.engine.home", true);
        configuration.setAttribute("engine.debug.type", 2);
        configuration.setAttribute("engine.task.type", 4);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.validateReportDesignFile(launchConfig) && this.validateEngineHome(launchConfig) && this.validateTempFloder(launchConfig);
    }

    private boolean validateTempFloder(ILaunchConfiguration launchConfig) {
        String str = this.fTempFolder.getText();
        try {
            str = ScriptDebugUtil.getSubstitutedString(str);
        }
        catch (CoreException e) {
            str = this.fEngineHome.getText();
        }
        if (str == null || str.length() == 0) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.no.temp.folder"));
            return false;
        }
        File file = new File(str);
        if (!file.exists()) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.nonexist.temp.folder"));
            return false;
        }
        if (!file.isDirectory()) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.invalid.temp.folder"));
            return false;
        }
        return true;
    }

    private boolean validateEngineHome(ILaunchConfiguration launchConfig) {
        if (this.bUseDefaultEngineHome.getSelection()) {
            return true;
        }
        String str = this.fEngineHome.getText();
        try {
            str = ScriptDebugUtil.getSubstitutedString(str);
        }
        catch (CoreException e) {
            str = this.fEngineHome.getText();
        }
        if (str == null || str.length() == 0) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.no.engine.home"));
            return false;
        }
        File file = new File(str);
        if (!file.exists()) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.nonexist.engine.home"));
            return false;
        }
        if (!file.isDirectory()) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.invalid.engine.home"));
            return false;
        }
        return true;
    }

    private boolean validateReportDesignFile(ILaunchConfiguration launchConfig) {
        String str = this.fMainText.getText();
        try {
            str = ScriptDebugUtil.getSubstitutedString(str);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (str == null || str.length() == 0) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.no.report.file"));
            return false;
        }
        File file = new File(str);
        if (!file.exists() || !file.isFile()) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.nonexist.report.file"));
            return false;
        }
        if (this.bRender.getSelection()) {
            if (!DOCUMENT_FILE_EXT.equalsIgnoreCase(new Path(str).getFileExtension())) {
                this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.invalid.document.file"));
                return false;
            }
        } else if (!"rptdesign".equalsIgnoreCase(new Path(str).getFileExtension())) {
            this.setErrorMessage(Messages.getString("ScriptMainTab.error.msg.invalid.report.file"));
            return false;
        }
        return true;
    }

    private Button createVariableButton(Composite parent, String text, final Text source) {
        Button button = this.createPushButton(parent, text, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(source.getShell());
                if (dialog.open() == 0) {
                    source.insert(dialog.getVariableExpression());
                }
            }
        });
        return button;
    }
}

