/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.script.model;

import java.util.logging.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.LineBreakpoint;

public class ScriptLineBreakpoint
extends LineBreakpoint {
    private static final Logger logger = Logger.getLogger(ScriptLineBreakpoint.class.getName());
    public static final String LINEBREAKPOINT = "line break point";
    public static final String RUNTOLINE = "run to line";
    public static final String SUBNAME = "sub name";
    private static final String FILENAME = "file name";
    private static final String DISPLAYNAME = "display name";
    private String type = "line break point";

    public ScriptLineBreakpoint() {
    }

    public ScriptLineBreakpoint(final IResource resource, final String name, final String subName, final int lineNumber, final String displayName) throws CoreException {
        assert (resource != null);
        assert (subName != null);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("org.eclipse.birt.report.debug.ui.script.scriptLineBreakpointMarker");
                ScriptLineBreakpoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)ScriptLineBreakpoint.this.getModelIdentifier());
                marker.setAttribute("message", (Object)("Line Breakpoint: " + resource.getName() + " [line: " + lineNumber + "]"));
                marker.setAttribute(ScriptLineBreakpoint.SUBNAME, (Object)subName);
                marker.setAttribute(ScriptLineBreakpoint.FILENAME, (Object)name);
                ScriptLineBreakpoint.this.setDisplayName(displayName);
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    public String getModelIdentifier() {
        return "org.eclipse.birt.report.debug.script.model";
    }

    public void setDisplayName(String name) {
        try {
            this.getMarker().setAttribute(DISPLAYNAME, (Object)name);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        String retValue = "";
        try {
            retValue = (String)this.getMarker().getAttribute(DISPLAYNAME);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (retValue == null || retValue.length() == 0) {
            retValue = this.getSubName();
        }
        return retValue;
    }

    public String getSubName() {
        try {
            return (String)this.getMarker().getAttribute(SUBNAME);
        }
        catch (CoreException e) {
            logger.warning(e.getMessage());
            throw new Error("Don't set the sub name");
        }
    }

    public String getFileName() {
        try {
            return (String)this.getMarker().getAttribute(FILENAME);
        }
        catch (CoreException e) {
            return "";
        }
    }

    public int getScriptLineNumber() {
        try {
            return this.getLineNumber();
        }
        catch (CoreException coreException) {
            return 1;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean shouldSkipBreakpoint() throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        return plugin != null && this.isRegistered() && !plugin.getBreakpointManager().isEnabled();
    }
}

