/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.io;

import java.io.IOException;
import java.io.OutputStream;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;

public class ChunkOutputStream<T>
extends OutputStream {
    private byte[] chunk;
    private long chunkPos = 0L;
    private String cf;
    private T key;
    private long pos = 0L;
    private Mutator<T> mutator;

    public ChunkOutputStream(Keyspace keyspace, String cf, T key, Serializer<T> keySerializer, int chunkSize) {
        this.cf = cf;
        this.key = key;
        this.chunk = new byte[chunkSize];
        this.mutator = HFactory.createMutator(keyspace, keySerializer);
        this.mutator.delete(key, cf, null, null);
    }

    @Override
    public void write(int b) throws IOException {
        if ((long)(this.chunk.length - 1) == this.pos) {
            this.flush();
        }
        this.chunk[(int)this.pos++] = (byte)b;
    }

    @Override
    public void close() throws IOException {
        this.writeData(true);
    }

    @Override
    public void flush() throws IOException {
        this.writeData(false);
    }

    private void writeData(boolean close) throws IOException {
        if (this.pos != 0L && (close || this.pos == (long)(this.chunk.length - 1))) {
            byte[] data;
            if (this.pos != (long)(this.chunk.length - 1)) {
                data = new byte[(int)this.pos + 1];
                System.arraycopy(this.chunk, 0, data, 0, data.length);
            } else {
                data = this.chunk;
            }
            try {
                this.mutator.insert(this.key, this.cf, HFactory.createColumn(this.chunkPos, data, LongSerializer.get(), BytesArraySerializer.get()));
            }
            catch (HectorException e) {
                throw new IOException("Unable to write data", e);
            }
            ++this.chunkPos;
            this.pos = 0L;
        }
    }
}

