/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.text.XMLProblemAnnotation;
import org.eclipse.ant.internal.ui.model.IProblem;
import org.eclipse.ant.internal.ui.model.IProblemRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationMap;
import org.eclipse.jface.text.source.IAnnotationModel;

public class AntExternalAnnotationModel
extends AnnotationModel
implements IProblemRequestor {
    private List<XMLProblemAnnotation> fGeneratedAnnotations = new ArrayList<XMLProblemAnnotation>();
    private List<IProblem> fCollectedProblems = new ArrayList<IProblem>();

    @Override
    public void acceptProblem(IProblem problem) {
        this.fCollectedProblems.add(problem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endReporting() {
        boolean temporaryProblemsChanged = false;
        IAnnotationMap iAnnotationMap = this.getAnnotationMap();
        synchronized (iAnnotationMap) {
            if (this.fGeneratedAnnotations.size() > 0) {
                temporaryProblemsChanged = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                for (IProblem problem : this.fCollectedProblems) {
                    Position position = this.createPositionFromProblem(problem);
                    if (position == null) continue;
                    XMLProblemAnnotation annotation = new XMLProblemAnnotation(problem);
                    this.fGeneratedAnnotations.add(annotation);
                    try {
                        this.addAnnotation(annotation, position, false);
                    }
                    catch (BadLocationException ex) {
                        AntUIPlugin.log(ex);
                    }
                    temporaryProblemsChanged = true;
                }
                this.fCollectedProblems.clear();
            }
        }
        if (temporaryProblemsChanged) {
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this));
        }
    }

    protected Position createPositionFromProblem(IProblem problem) {
        int length;
        int start = problem.getOffset();
        if (start >= 0 && (length = problem.getLength()) >= 0) {
            return new Position(start, length);
        }
        return null;
    }

    @Override
    public void beginReporting() {
    }
}

