/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ResultSetIndex {
    private Map<String, QueryResultSets> queries = new HashMap<String, QueryResultSets>();

    public void addResultSet(String query, String parent, String rawId, String rset) {
        QueryResultSets rsets = this.queries.get(query);
        if (rsets == null) {
            rsets = new QueryResultSets();
            this.queries.put(query, rsets);
        }
        rsets.addResultSet(parent, rawId, rset);
    }

    public String getResultSet(String query, String parent, String rawId) {
        QueryResultSets rsets = this.queries.get(query);
        if (rsets != null) {
            int charAt;
            String rset = rsets.getResultSet(parent, rawId);
            if (rset == null && parent != null && (charAt = parent.indexOf("_")) != -1) {
                String root = parent.substring(0, charAt);
                return rsets.getResultSet(root, rawId);
            }
            return rset;
        }
        return null;
    }

    public String[] getResultSetWithRawId(String query, String parent, String raw) {
        QueryResultSets rsets = this.queries.get(query);
        if (rsets != null) {
            int charAt;
            String[] rset = rsets.getResultSetWithRawId(parent, raw);
            if (rset == null && parent != null && (charAt = parent.indexOf("_")) != -1) {
                String root = parent.substring(0, charAt);
                return rsets.getResultSetWithRawId(root, raw);
            }
            return rset;
        }
        return null;
    }

    private static class QueryResultSets {
        Map<String, ResultSets> results = new HashMap<String, ResultSets>();

        private QueryResultSets() {
        }

        void addResultSet(String parent, String rawId, String rset) {
            ResultSets rsets = this.results.get(parent);
            if (rsets == null) {
                rsets = new ResultSets();
                this.results.put(parent, rsets);
            }
            rsets.addResultSet(rawId, rset);
        }

        String getResultSet(String parent, String row) {
            ResultSets rsets = this.getResultSets(parent);
            return rsets == null ? null : rsets.getResultSet(row);
        }

        String[] getResultSetWithRawId(String parent, String row) {
            ResultSets rsets = this.getResultSets(parent);
            return rsets == null ? null : rsets.getResultSetWithRawId(row);
        }

        ResultSets getResultSets(String parent) {
            ResultSets rsets = this.results.get(parent);
            return rsets;
        }
    }

    private static class ResultSetEntry {
        int row;
        String rset;

        ResultSetEntry(int row, String rset) {
            this.row = row;
            this.rset = rset;
        }
    }

    private static class ResultSets {
        static Comparator<ResultSetEntry> comparator = new Comparator<ResultSetEntry>(){

            @Override
            public int compare(ResultSetEntry e1, ResultSetEntry e2) {
                if (e1.row == e2.row) {
                    return 0;
                }
                if (e1.row < e2.row) {
                    return -1;
                }
                return 1;
            }
        };
        ResultSetEntry[] entries;
        Collection<ResultSetEntry> rsets = new ArrayList<ResultSetEntry>();
        Map<String, String> stringIdResets = new HashMap<String, String>();

        private ResultSets() {
        }

        void addResultSet(String rawId, String rset) {
            try {
                int intRawId = Integer.parseInt(rawId);
                this.addWithIntId(intRawId, rset);
            }
            catch (NumberFormatException ex) {
                this.addWithStringId(rawId, rset);
            }
        }

        String getResultSet(String rawId) {
            try {
                int intRawId = Integer.parseInt(rawId);
                return this.getIntRowId(intRawId);
            }
            catch (NumberFormatException ex) {
                return this.getResultSetWithStringRowId(rawId);
            }
        }

        String[] getResultSetWithRawId(String rawId) {
            try {
                int intRawId = Integer.parseInt(rawId);
                return this.getResultSetWithRawId(intRawId);
            }
            catch (NumberFormatException ex) {
                String[] stringArray = new String[2];
                stringArray[0] = this.getResultSetWithStringRowId(rawId);
                return stringArray;
            }
        }

        private void addWithIntId(int rowId, String rset) {
            if (this.entries != null) {
                throw new IllegalStateException();
            }
            this.rsets.add(new ResultSetEntry(rowId, rset));
        }

        private void addWithStringId(String rowId, String rset) {
            this.stringIdResets.put(rowId, rset);
        }

        private String getResultSetWithStringRowId(String rowId) {
            return this.stringIdResets.get(rowId);
        }

        private String getIntRowId(int rowId) {
            ResultSetEntry entry = this.getResultSetEntry(rowId);
            return entry == null ? null : entry.rset;
        }

        private String[] getResultSetWithRawId(int rawId) {
            String[] stringArray;
            ResultSetEntry entry = this.getResultSetEntry(rawId);
            if (entry == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = entry.rset;
                stringArray = stringArray2;
                stringArray2[1] = String.valueOf(entry.row);
            }
            return stringArray;
        }

        private ResultSetEntry getResultSetEntry(int rawId) {
            if (this.entries == null) {
                this.entries = this.rsets.toArray(new ResultSetEntry[this.rsets.size()]);
                Arrays.sort(this.entries, comparator);
            }
            ResultSetEntry entry = null;
            int index = Arrays.binarySearch(this.entries, new ResultSetEntry(rawId, ""), comparator);
            if (index < 0) {
                index = -(index + 1) - 1;
            }
            if (index < 0) {
                index = 0;
            }
            if (index >= 0 && index < this.entries.length) {
                entry = this.entries[index];
            }
            return entry;
        }
    }
}

