/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.Collator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.browsers.BrowserAccessor;
import org.eclipse.birt.report.viewer.utilities.IWebAppInfo;
import org.eclipse.birt.report.viewer.utilities.LogUtil;
import org.eclipse.birt.report.viewer.utilities.ReloadableClassLoader;
import org.eclipse.birt.report.viewer.utilities.ViewerClassPathHelper;
import org.eclipse.birt.report.viewer.utilities.WebappAccessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.browser.Browser;

public class WebViewer {
    private static final String UTF_8 = "utf-8";
    public static final String HTML = "html";
    public static final String HTM = "htm";
    public static final String PDF = "pdf";
    public static final String DOC = "doc";
    public static final String DOCX = "docx";
    public static final String PPT = "ppt";
    public static final String PPTX = "pptx";
    public static final String ODP = "odp";
    public static final String ODS = "ods";
    public static final String ODT = "odt";
    public static final String POSTSCRIPT = "postscript";
    public static final String REPORT_DOCUMENT_FILE = ".rptdocument";
    public static final String WebAppPlugin = "org.eclipse.birt.report.viewer";
    public static final String USER_LOCALE = "user_locale";
    public static final String USER_TIME_ZONE = "user_time_zone";
    public static final String SVG_FLAG = "svg_flag";
    public static final String BIDI_ORIENTATION = "bidi_orientation";
    public static final String BIDI_ORIENTATION_AUTO = "auto";
    public static final String BIDI_ORIENTATION_LTR = "ltr";
    public static final String BIDI_ORIENTATION_RTL = "rtl";
    public static final String MASTER_PAGE_CONTENT = "master_page_content";
    public static final String PREVIEW_MAXROW = "preview_maxrow";
    public static final String PREVIEW_MAXINMEMORYCUBESIZE = "preview_maxinmemorycubesize";
    public static final String VIEWER_PREVIEW = "preview";
    public static final String VIEWER_FRAMESET = "frameset";
    public static final String VIEWER_RUN = "run";
    public static final String VIEWER_DOCUMENT = "document";
    public static final String VIEWER_OUTPUT = "output";
    public static final String FORMAT_KEY = "FORMAT_KEY";
    public static final String EMITTER_ID_KEY = "EMITTER_ID_KEY";
    public static final String EMITTER_OPTIONS_KEY = "EMITTER_OPTIONS_KEY";
    public static final String ALLOW_PAGE_KEY = "ALLOW_PAGE_KEY";
    public static final String OUTPUT_DOCUMENT_KEY = "OUTPUT_DOCUMENT_KEY";
    public static final String SERVLET_NAME_KEY = "SERVLET_NAME_KEY";
    public static final String DOCUMENT_NAME_KEY = "DOCUMENT_NAME_KEY";
    public static final String RESOURCE_FOLDER_KEY = "RESOURCE_FOLDER_KEY";
    public static final String CLOSE_WINDOW_KEY = "CLOSE_WINDOW_KEY";
    public static final String SHOW_PARAMETER_PAGE_KEY = "SHOW_PARAMETER_PAGE";
    public static final String APPCONTEXT_EXTENSION_KEY = "APPCONTEXT_EXTENSION_KEY";
    public static final String MAX_ROWS_KEY = "MAX_ROWS_KEY";
    public static final String REPORT_DEBUT_MODE = "report_debug_mode";
    private static ReloadableClassLoader reloadableClassLoader = null;
    public static TreeMap<String, String> LOCALE_TABLE = null;
    private static Random random = new Random();
    private static Map<String, IWebAppInfo> apps;
    private static IWebAppInfo DEFAULT_WEBAPP;
    private static boolean adapterChecked;

    static {
        LOCALE_TABLE = new TreeMap(Collator.getInstance());
        Locale[] locales = Locale.getAvailableLocales();
        if (locales != null) {
            int i = 0;
            while (i < locales.length) {
                Locale locale = locales[i];
                if (locale != null && locale.getCountry().length() != 0) {
                    if (LOCALE_TABLE.containsValue(String.valueOf(locale.getLanguage()) + "_" + locale.getCountry())) {
                        String existKey = WebViewer.getKeyByValue(String.valueOf(locale.getLanguage()) + "_" + locale.getCountry());
                        if (locale.getDisplayName().length() < existKey.length()) {
                            LOCALE_TABLE.remove(existKey);
                            LOCALE_TABLE.put(locale.getDisplayName(), String.valueOf(locale.getLanguage()) + "_" + locale.getCountry());
                        }
                    } else {
                        LOCALE_TABLE.put(locale.getDisplayName(), String.valueOf(locale.getLanguage()) + "_" + locale.getCountry());
                    }
                }
                ++i;
            }
        }
        apps = new LinkedHashMap<String, IWebAppInfo>();
        apps.put("viewer", new IWebAppInfo(){

            @Override
            public String getID() {
                return WebViewer.WebAppPlugin;
            }

            @Override
            public String getName() {
                return "viewer";
            }

            @Override
            public String getWebAppContextPath() {
                return "/viewer";
            }

            @Override
            public String getWebAppPath() {
                return "/birt";
            }

            @Override
            public boolean useCustomParamHandling() {
                return false;
            }

            @Override
            public String getURIEncoding() {
                return null;
            }
        });
        DEFAULT_WEBAPP = apps.get("viewer");
        adapterChecked = false;
    }

    private static String getKeyByValue(String value) {
        Set<Map.Entry<String, String>> entrySet = LOCALE_TABLE.entrySet();
        for (Map.Entry<String, String> mapentry : entrySet) {
            if (!mapentry.getValue().toString().equals(value)) continue;
            return mapentry.getKey().toString();
        }
        return "";
    }

    private static void checkAdapter() {
        if (adapterChecked) {
            return;
        }
        Object webInfo = Platform.getAdapterManager().loadAdapter((Object)ViewerPlugin.getDefault(), IWebAppInfo.class.getName());
        if (webInfo instanceof IWebAppInfo) {
            apps.put(((IWebAppInfo)webInfo).getName(), (IWebAppInfo)webInfo);
            DEFAULT_WEBAPP = (IWebAppInfo)webInfo;
        }
        adapterChecked = true;
    }

    public static IWebAppInfo getCurrentWebApp() {
        WebViewer.checkAdapter();
        return DEFAULT_WEBAPP;
    }

    private static String getBaseURL(String webappName) {
        WebViewer.checkAdapter();
        IWebAppInfo app = apps.get(webappName);
        if (app == null) {
            app = DEFAULT_WEBAPP;
        }
        return "http://" + WebappAccessor.getHost() + ":" + WebappAccessor.getPort(app.getName()) + "/" + app.getName() + "/";
    }

    private static String createURL(String webappName, String report, Map params) {
        String appContextName;
        if (params == null || params.isEmpty()) {
            return WebViewer.createURL(webappName, null, report, null, null, null, null, null);
        }
        String servletName = (String)params.get(SERVLET_NAME_KEY);
        String format = (String)params.get(FORMAT_KEY);
        String emitterid = (String)params.get(EMITTER_ID_KEY);
        String resourceFolder = (String)params.get(RESOURCE_FOLDER_KEY);
        Boolean allowPage = (Boolean)params.get(ALLOW_PAGE_KEY);
        Map emitterOptions = (Map)params.get(EMITTER_OPTIONS_KEY);
        String outputDocName = (String)params.get(OUTPUT_DOCUMENT_KEY);
        String showParameter = (String)params.get(SHOW_PARAMETER_PAGE_KEY);
        if (HTM.equalsIgnoreCase(format)) {
            format = HTML;
        }
        if (StringUtil.isBlank((String)format)) {
            String string = format = StringUtil.isBlank((String)emitterid) ? HTML : null;
        }
        if (StringUtil.isBlank((String)servletName)) {
            servletName = !HTML.equalsIgnoreCase(format) ? VIEWER_PREVIEW : (allowPage == null ? VIEWER_FRAMESET : (allowPage != false ? VIEWER_FRAMESET : VIEWER_PREVIEW));
        }
        String maxrows = (String)params.get(MAX_ROWS_KEY);
        Map<String, String> urlParams = WebViewer.prepareCommonURLParams(format, resourceFolder, maxrows, null, null);
        String documentName = (String)params.get(DOCUMENT_NAME_KEY);
        if (documentName != null && VIEWER_DOCUMENT.equals(servletName) && !WebViewer.isReportDocument(report)) {
            try {
                String encodedDocumentName = URLEncoder.encode(documentName, UTF_8);
                urlParams.put("__document", encodedDocumentName);
                String isCloseWin = (String)params.get(CLOSE_WINDOW_KEY);
                if (isCloseWin != null) {
                    urlParams.put("__closewin", isCloseWin);
                }
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.logWarning(e.getLocalizedMessage(), e);
            }
        }
        if (!StringUtil.isBlank((String)(appContextName = ViewerPlugin.getDefault().getPluginPreferences().getString(APPCONTEXT_EXTENSION_KEY)))) {
            try {
                String encodedAppContextName = URLEncoder.encode(appContextName.trim(), UTF_8);
                urlParams.put("__appcontextname", encodedAppContextName);
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.logWarning(e.getLocalizedMessage(), e);
            }
        }
        if (!StringUtil.isBlank((String)emitterid)) {
            urlParams.put("__emitterid", emitterid.trim());
        }
        if (!StringUtil.isBlank((String)outputDocName)) {
            try {
                String encodedOutputDocumentName = URLEncoder.encode(outputDocName, UTF_8);
                urlParams.put("__outputDocName", encodedOutputDocumentName);
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.logWarning(e.getLocalizedMessage(), e);
            }
        }
        if (showParameter != null) {
            urlParams.put("__parameterpage", showParameter);
        }
        if (emitterOptions != null) {
            urlParams.putAll(emitterOptions);
        }
        return WebViewer.createURL(webappName, servletName, report, urlParams);
    }

    private static String createURL(String webappName, String servletName, String report, String format, String resourceFolder, String maxrows, String maxrowlevels, String maxcolumnlevels) {
        return WebViewer.createURL(webappName, servletName, report, WebViewer.prepareCommonURLParams(format, resourceFolder, maxrows, maxrowlevels, maxcolumnlevels));
    }

    private static String createURL(String webappName, String servletName, String report, Map<String, String> urlParams) {
        String encodedReportName = null;
        try {
            encodedReportName = URLEncoder.encode(report, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.logWarning(e.getLocalizedMessage(), e);
        }
        String reportParam = "__report";
        if (WebViewer.isReportDocument(encodedReportName)) {
            reportParam = "__document";
        }
        reportParam = String.valueOf(reportParam) + "=" + encodedReportName;
        return String.valueOf(WebViewer.getBaseURL(webappName)) + servletName + "?" + reportParam + WebViewer.convertParams(urlParams);
    }

    private static String convertParams(Map<String, String> params) {
        if (params != null && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                sb.append("&").append(entry.getKey());
                if (entry.getValue() == null) continue;
                sb.append("=").append(entry.getValue());
            }
            return sb.toString();
        }
        return "";
    }

    private static Map<String, String> prepareCommonURLParams(String format, String resourceFolder, String maxrows, String maxrowlevels, String maxcolumnlevels) {
        String locale;
        String timeZone = ViewerPlugin.getDefault().getPluginPreferences().getString(USER_TIME_ZONE);
        if ("".equals(timeZone)) {
            timeZone = null;
        }
        if (LOCALE_TABLE.containsKey(locale = ViewerPlugin.getDefault().getPluginPreferences().getString(USER_LOCALE))) {
            locale = LOCALE_TABLE.get(locale);
        } else if ("".equals(locale)) {
            locale = null;
        } else {
            try {
                locale = URLEncoder.encode(locale, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                locale = null;
                LogUtil.logWarning(e.getLocalizedMessage(), e);
            }
        }
        boolean bSVGFlag = Platform.getPreferencesService().getBoolean(WebAppPlugin, SVG_FLAG, true, null);
        String cubeMemorySize = ViewerPlugin.getDefault().getPluginPreferences().getString(PREVIEW_MAXINMEMORYCUBESIZE);
        boolean rtl = false;
        String bidiOrientation = ViewerPlugin.getDefault().getPluginPreferences().getString(BIDI_ORIENTATION);
        if (bidiOrientation == null) {
            bidiOrientation = BIDI_ORIENTATION_AUTO;
        }
        rtl = BIDI_ORIENTATION_LTR.equals(bidiOrientation) ? false : (BIDI_ORIENTATION_RTL.equals(bidiOrientation) ? true : Window.getDefaultOrientation() == 0x4000000);
        String masterPageContent = ViewerPlugin.getDefault().getPluginPreferences().getString(MASTER_PAGE_CONTENT);
        boolean bMasterPageContent = true;
        if ("false".equalsIgnoreCase(masterPageContent)) {
            bMasterPageContent = false;
        }
        String encodedResourceFolder = null;
        if (resourceFolder != null) {
            try {
                encodedResourceFolder = URLEncoder.encode(resourceFolder, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.logWarning(e.getLocalizedMessage(), e);
            }
        }
        if (encodedResourceFolder == null) {
            encodedResourceFolder = "";
        }
        String asattachment = null;
        if (POSTSCRIPT.equalsIgnoreCase(format) || DOC.equalsIgnoreCase(format) || DOCX.equalsIgnoreCase(format) || PPT.equalsIgnoreCase(format) || PPTX.equalsIgnoreCase(format) || ODP.equalsIgnoreCase(format) || ODS.equalsIgnoreCase(format) || ODT.equalsIgnoreCase(format)) {
            asattachment = "&__asattachment=true";
        }
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (format != null) {
            params.put("__format", format);
        }
        params.put("__svg", String.valueOf(bSVGFlag));
        if (locale != null) {
            params.put("__locale", locale);
        }
        if (timeZone != null) {
            try {
                params.put("__timezone", URLEncoder.encode(timeZone, UTF_8));
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.logWarning(e.getLocalizedMessage(), e);
            }
        }
        params.put("__masterpage", String.valueOf(bMasterPageContent));
        params.put("__rtl", String.valueOf(rtl));
        if (!StringUtil.isBlank((String)maxrows)) {
            params.put("__maxrows", maxrows.trim());
        }
        if (!StringUtil.isBlank((String)cubeMemorySize)) {
            params.put("__cubememsize", cubeMemorySize.trim());
        }
        params.put("__resourceFolder", encodedResourceFolder);
        if (asattachment != null) {
            params.put("__asattachment", "true");
        }
        if (!HTML.equalsIgnoreCase(format)) {
            params.put("__dpi", String.valueOf(dpi));
        }
        return params;
    }

    private static synchronized void startWebApp(String webappName, String reportFileName) {
        WebViewer.checkAdapter();
        try {
            IWebAppInfo app;
            String debugMode = System.getProperty(REPORT_DEBUT_MODE);
            if (debugMode == null) {
                URL[] urls = ViewerClassPathHelper.getWorkspaceClassPath(reportFileName);
                if (reloadableClassLoader == null) {
                    reloadableClassLoader = new ReloadableClassLoader(urls, WebViewer.class.getClassLoader());
                } else {
                    reloadableClassLoader.setUrls(urls);
                    reloadableClassLoader.reload();
                }
            }
            if ((app = apps.get(webappName)) != null) {
                WebappAccessor.start(app.getName(), app.getID());
            }
        }
        catch (CoreException e) {
            LogUtil.logError(e.getLocalizedMessage(), e);
        }
    }

    private static void stopWebApp(String webappName) {
        try {
            WebappAccessor.stop(webappName);
        }
        catch (CoreException e) {
            LogUtil.logError(e.getLocalizedMessage(), e);
        }
    }

    public static void startup() {
        WebViewer.checkAdapter();
        WebViewer.startup(DEFAULT_WEBAPP.getName());
    }

    public static void startup(String webappName) {
        WebViewer.startWebApp(webappName, null);
    }

    @Deprecated
    public static void startup(Browser browser) {
        WebViewer.checkAdapter();
        WebViewer.startup(DEFAULT_WEBAPP.getName());
    }

    public static void stop() {
        WebViewer.stop(DEFAULT_WEBAPP.getName());
    }

    public static void stopAll() {
        try {
            WebappAccessor.stopAll();
        }
        catch (CoreException e) {
            LogUtil.logError(e.getLocalizedMessage(), e);
        }
    }

    public static void stop(String webappName) {
        WebViewer.stopWebApp(webappName);
    }

    public static void display(String report, String format) {
        WebViewer.checkAdapter();
        WebViewer.display(DEFAULT_WEBAPP.getName(), report, format);
    }

    public static void display(String webappName, String report, String format) {
        WebViewer.display(webappName, report, format, true);
    }

    public static void display(String report, String format, boolean allowPage) {
        WebViewer.checkAdapter();
        WebViewer.display(DEFAULT_WEBAPP.getName(), report, format, allowPage);
    }

    public static void display(String webappName, String report, String format, boolean allowPage) {
        if (format == null || format.trim().length() <= 0 || HTM.equalsIgnoreCase(format)) {
            format = HTML;
        }
        String root = null;
        root = !HTML.equalsIgnoreCase(format) ? WebViewer.createURL(webappName, VIEWER_PREVIEW, report, format, null, null, null, null) : String.valueOf(WebViewer.createURL(webappName, allowPage ? VIEWER_FRAMESET : VIEWER_PREVIEW, report, format, null, null, null, null)) + "&" + random.nextInt();
        WebViewer.startWebApp(webappName, report);
        try {
            boolean useExternal = ViewerPlugin.getDefault().getPluginPreferences().getBoolean("always_external_browser");
            BrowserAccessor.getPreviewBrowser(useExternal).displayURL(root);
        }
        catch (Exception e) {
            LogUtil.logError(e.getLocalizedMessage(), e);
        }
    }

    @Deprecated
    public static void display(String report, String format, Browser browser) {
        WebViewer.checkAdapter();
        WebViewer.startWebApp(DEFAULT_WEBAPP.getName(), report);
        browser.setUrl(String.valueOf(WebViewer.createURL(DEFAULT_WEBAPP.getName(), VIEWER_RUN, report, format, null, null, null, null)) + "&" + random.nextInt());
    }

    @Deprecated
    public static void display(String report, String format, Browser browser, String servletName) {
        WebViewer.checkAdapter();
        WebViewer.startWebApp(DEFAULT_WEBAPP.getName(), report);
        browser.setUrl(String.valueOf(WebViewer.createURL(DEFAULT_WEBAPP.getName(), servletName, report, format, null, null, null, null)) + "&" + random.nextInt());
    }

    public static void display(String report, Browser browser, Map params) {
        WebViewer.checkAdapter();
        WebViewer.display(DEFAULT_WEBAPP.getName(), report, browser, params);
    }

    public static void display(String webappName, String report, Browser browser, Map params) {
        WebViewer.startWebApp(webappName, report);
        browser.setUrl(String.valueOf(WebViewer.createURL(webappName, report, params)) + "&" + random.nextInt());
    }

    public static void display(String report, Map params) {
        WebViewer.checkAdapter();
        WebViewer.display(DEFAULT_WEBAPP.getName(), report, params);
    }

    public static void display(String webappName, String report, Map params) {
        WebViewer.startWebApp(webappName, report);
        try {
            boolean useExternal = ViewerPlugin.getDefault().getPluginPreferences().getBoolean("always_external_browser");
            BrowserAccessor.getPreviewBrowser(useExternal).displayURL(String.valueOf(WebViewer.createURL(webappName, report, params)) + "&" + random.nextInt());
        }
        catch (Exception e) {
            LogUtil.logError(e.getLocalizedMessage(), e);
        }
    }

    private static boolean isReportDocument(String reportName) {
        if (reportName == null) {
            return false;
        }
        return reportName.toLowerCase().endsWith(REPORT_DOCUMENT_FILE);
    }

    public static void cancel(Browser browser) {
        if (browser == null || browser.isDisposed()) {
            return;
        }
        try {
            browser.execute("try { if( birtProgressBar ){ birtProgressBar.cancel(); } } catch(e){}");
        }
        catch (Exception e) {
            LogUtil.logError(e.getLocalizedMessage(), e);
        }
    }

    public static String getAppContextName() {
        String appContextName = ViewerPlugin.getDefault().getPluginPreferences().getString(APPCONTEXT_EXTENSION_KEY);
        if (appContextName != null && appContextName.trim().length() > 0) {
            return appContextName.trim();
        }
        return null;
    }

    public static ClassLoader getAppClassLoader() {
        return reloadableClassLoader;
    }

    public static ClassLoader getAppClassLoader(ClassLoader parent) {
        if (reloadableClassLoader != null) {
            reloadableClassLoader.setParent(parent);
            reloadableClassLoader.reload();
        }
        return reloadableClassLoader;
    }
}

