/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalRange
extends AggrFunction {
    public String getName() {
        return "RANGE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 3;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    public String getDescription() {
        return Messages.getString("TotalRange.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalRange.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private Object max = null;
        private Object min = null;
        private boolean isRowAvailable = false;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() {
            super.start();
            this.max = null;
            this.min = null;
            this.isRowAvailable = false;
        }

        public void onRow(Object[] args) {
            assert (args.length > 0);
            if (args[0] != null) {
                if (!this.isRowAvailable) {
                    this.isRowAvailable = true;
                    this.min = this.max = args[0];
                    return;
                }
                if (this.isGreaterThan(args[0], this.max)) {
                    this.max = args[0];
                } else if (this.isLessThan(args[0], this.min)) {
                    this.min = args[0];
                }
            }
        }

        @Override
        public Object getSummaryValue() throws DataException {
            if (this.max == null || this.min == null) {
                return null;
            }
            if (this.max instanceof Number && this.min instanceof Number) {
                return this.calculator.subtract(this.calculator.getTypedObject(this.max), this.calculator.getTypedObject(this.min));
            }
            return 0.0;
        }

        private boolean isGreaterThan(Object origin, Object target) {
            if (origin instanceof Comparable && target instanceof Comparable) {
                return ((Comparable)origin).compareTo(target) > 0;
            }
            throw new RuntimeException(Messages.getString("TotalMax.exception.cannot_get_max_value"));
        }

        private boolean isLessThan(Object origin, Object target) {
            if (origin instanceof Comparable && target instanceof Comparable) {
                return ((Comparable)origin).compareTo(target) < 0;
            }
            throw new RuntimeException(Messages.getString("TotalMin.exception.cannot_get_min_value"));
        }
    }
}

