/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.spy.core;

import java.text.MessageFormat;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.pde.spy.core.Messages;

public class SpyHandler {
    private static final String E4_SPIES_WINDOW = "org.eclipse.pde.spy.core.window";
    private static final String E4_SPIES_PART_STACK = "org.eclipse.pde.spy.core.partStack";

    @Execute
    public void run(EPartService ps, @Optional @Named(value="org.eclipse.pde.spy.core.command.partID") @Named(value="org.eclipse.pde.spy.core.command.partID") String viewID, MApplication appli, EModelService modelService) {
        MWindow spyWindow = this.prepareSpyWindow(appli, modelService);
        MPartStack partStack = (MPartStack)modelService.find(E4_SPIES_PART_STACK, (MUIElement)spyWindow);
        MPart p = ps.findPart(viewID);
        if (p == null) {
            p = ps.createPart(viewID);
            partStack.getChildren().add(p);
            partStack.setSelectedElement((MUIElement)p);
        }
        p.setVisible(true);
        ps.activate(p, true);
    }

    private MWindow prepareSpyWindow(MApplication appli, EModelService modelService) {
        List existingWindow = modelService.findElements((MUIElement)appli, E4_SPIES_WINDOW, MWindow.class, null);
        if (existingWindow.size() >= 1) {
            return (MWindow)existingWindow.get(0);
        }
        MTrimmedWindow tws = (MTrimmedWindow)modelService.findSnippet((MSnippetContainer)appli, E4_SPIES_WINDOW);
        EObject eObj = (EObject)tws;
        MTrimmedWindow tw = (MTrimmedWindow)EcoreUtil.copy((EObject)eObj);
        MTrimBar trimBar = tw.getTrimBars().stream().filter(t -> t.getSide() == SideValue.TOP).findFirst().get();
        MToolBar toolbar = (MToolBar)trimBar.getChildren().get(0);
        MCommand spyCmd = null;
        for (MCommand cmd : appli.getCommands()) {
            if (!"org.eclipse.pde.spy.core.command".equals(cmd.getElementId())) continue;
            spyCmd = cmd;
            break;
        }
        for (MPartDescriptor mp : appli.getDescriptors()) {
            if (!mp.getTags().contains("Spy")) continue;
            MHandledToolItem toolItem = (MHandledToolItem)modelService.createModelElement(MHandledToolItem.class);
            toolItem.setContributorURI(mp.getContributorURI());
            toolItem.setCommand(spyCmd);
            toolItem.setIconURI(mp.getIconURI());
            toolItem.setLabel(mp.getLabel());
            toolItem.setTooltip(MessageFormat.format(Messages.SpyHandler_Open, mp.getLocalizedLabel()));
            toolbar.getChildren().add(toolItem);
            MParameter p = (MParameter)modelService.createModelElement(MParameter.class);
            p.setName("org.eclipse.pde.spy.core.command.partID");
            p.setValue(mp.getElementId());
            toolItem.getParameters().add(p);
        }
        this.centerSpyWindow(appli, tw);
        ((MWindow)appli.getChildren().get(0)).getWindows().add(tw);
        return tw;
    }

    private void centerSpyWindow(MApplication appli, MTrimmedWindow tw) {
        MWindow mainWindow = (MWindow)appli.getChildren().get(0);
        float ratio = 0.75f;
        int spyW = (int)((float)mainWindow.getWidth() * ratio);
        int spyH = (int)((float)mainWindow.getHeight() * ratio);
        tw.setX(mainWindow.getX() + (mainWindow.getWidth() - spyW) / 2);
        tw.setY(mainWindow.getY() + (mainWindow.getHeight() - spyH) / 2);
        tw.setWidth(spyW);
        tw.setHeight(spyH);
    }
}

