/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.Parameter;
import org.eclipse.birt.report.model.elements.ParameterGroup;
import org.eclipse.birt.report.model.parser.CascadingParameterGroupState;
import org.eclipse.birt.report.model.parser.DynamicFilterParameterState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParameterGroupState;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.ScalarParameterState;
import org.eclipse.birt.report.model.parser.SlotState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.SAXException;

public class ParametersState
extends SlotState {
    public ParametersState(ModuleParserHandler handler, DesignElement container, int slotID) {
        super(handler, container, slotID);
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.PARAMETER_GROUP_TAG == tagValue) {
            return new ParameterGroupState(this.handler, this.slotID);
        }
        if (ParserSchemaConstants.CASCADING_PARAMETER_GROUP_TAG == tagValue) {
            return new CascadingParameterGroupState(this.handler, this.slotID);
        }
        if (ParserSchemaConstants.SCALAR_PARAMETER_TAG == tagValue) {
            return new ScalarParameterState(this.handler, this.container, this.slotID);
        }
        if (ParserSchemaConstants.DYNAMIC_FILTER_PARAMETER_TAG == tagValue) {
            return new DynamicFilterParameterState(this.handler, this.container, this.slotID);
        }
        if (ParserSchemaConstants.FILTER_PARAMETER_TAG == tagValue || ParserSchemaConstants.LIST_PARAMETER_TAG == tagValue || ParserSchemaConstants.TABLE_PARAMETER_TAG == tagValue) {
            return new AnyElementState(this.handler);
        }
        return super.startElement(tagName);
    }

    @Override
    public XMLParserHandler getHandler() {
        return this.handler;
    }

    @Override
    public void end() throws SAXException {
        super.end();
        if (this.handler.versionNumber < 3022100 && this.container instanceof Module) {
            this.checkParameterNames();
        }
    }

    private void checkParameterNames() {
        Module module = (Module)this.container;
        ContentIterator iter = new ContentIterator(module, new ContainerContext((DesignElement)module, 1));
        ArrayList<DesignElement> params = new ArrayList<DesignElement>();
        while (iter.hasNext()) {
            DesignElement content = (DesignElement)iter.next();
            if (!(content instanceof Parameter) && !(content instanceof ParameterGroup)) continue;
            params.add(content);
        }
        if (!params.isEmpty()) {
            Map<String, DesignElement> parameterMap = this.buildNameMap(params);
            int i = 0;
            while (i < params.size()) {
                DesignElement param = (DesignElement)params.get(i);
                String oldName = param.getName();
                NameExecutor executor = new NameExecutor((Module)this.container, param);
                INameHelper nameHelper = executor.getNameHelper();
                if (nameHelper != null) {
                    NameSpace ns = executor.getNameSpace();
                    String paramName = param.getName();
                    String lowerCaseName = paramName.toLowerCase();
                    if (parameterMap.containsKey(lowerCaseName) && parameterMap.get(lowerCaseName) != param) {
                        HashMap<String, String> nameMaps;
                        String baseName = paramName;
                        String name = paramName;
                        int index = 0;
                        while (parameterMap.containsKey(lowerCaseName) && parameterMap.get(lowerCaseName) != param) {
                            name = String.valueOf(baseName) + ++index;
                            lowerCaseName = name.toLowerCase();
                        }
                        param.setName(name);
                        if (!ns.contains(name.toLowerCase())) {
                            ns.insert(param);
                        }
                        if (!parameterMap.containsKey(name.toLowerCase())) {
                            parameterMap.put(name.toLowerCase(), param);
                        }
                        if (parameterMap.get(paramName.toLowerCase()) == param) {
                            parameterMap.remove(paramName.toLowerCase());
                        }
                        if ((nameMaps = (HashMap<String, String>)this.handler.tempValue.get("parameter_name_cache")) == null) {
                            nameMaps = new HashMap<String, String>();
                            this.handler.tempValue.put("parameter_name_cache", nameMaps);
                        }
                        nameMaps.put(oldName, name);
                    } else if (!ns.contains(lowerCaseName)) {
                        ns.insert(param);
                    }
                }
                ++i;
            }
        }
    }

    private Map<String, DesignElement> buildNameMap(List<DesignElement> params) {
        HashMap<String, DesignElement> paramMap = new HashMap<String, DesignElement>();
        int i = 0;
        while (i < params.size()) {
            DesignElement param = params.get(i);
            String styleName = param.getName();
            String lowerName = styleName.toLowerCase();
            if (!paramMap.containsKey(lowerName)) {
                paramMap.put(lowerName, param);
            }
            ++i;
        }
        return paramMap;
    }
}

