/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;

public class ElementReferenceValidator
extends AbstractPropertyValidator {
    public static final String NAME = "ElementReferenceValidator";
    private static final ElementReferenceValidator instance = new ElementReferenceValidator();

    public static ElementReferenceValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element, String propName) {
        boolean flag = ElementReferenceValidator.isInTemplateParameterDefinitionSlot(element);
        if (flag) {
            return Collections.emptyList();
        }
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        ElementPropertyDefn prop = element.getPropertyDefn(propName);
        if (prop.getTypeCode() == 15) {
            if (!this.checkElementReference(module, element, prop)) {
                Object value = element.getLocalProperty(module, propName);
                list.add(new SemanticError(element, new String[]{propName, ((ElementRefValue)value).getName()}, "Error.SemanticError.INVALID_ELEMENT_REF"));
            }
        } else if (prop.getTypeCode() == 20 && prop.getSubTypeCode() == 15) {
            List<ElementRefValue> valueList = element.resolveElementReferenceList(module, prop);
            if (valueList != null) {
                int i = 0;
                while (i < valueList.size()) {
                    ElementRefValue item = valueList.get(i);
                    if (!item.isResolved() || item.getElement() == element) {
                        list.add(new SemanticError(element, new String[]{propName, item.getName()}, "Error.SemanticError.INVALID_ELEMENT_REF"));
                    }
                    ++i;
                }
            }
        } else assert (false);
        return list;
    }

    private boolean checkElementReference(Module module, DesignElement element, ElementPropertyDefn prop) {
        assert (15 == prop.getTypeCode());
        ElementRefValue ref = element.resolveElementReference(module, prop);
        if (ref == null) {
            return true;
        }
        return ref.isResolved() && element != ref.getElement();
    }
}

