/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.emf.visualizations;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.app4mc.emf.visualizations.EObjectRefsConfig;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EObjectRefsGenerator {
    private EObjectRefsGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static void updateDiagram(PlantUmlDiagram diagram, EObject eObject, EObjectRefsConfig config) {
        diagram.resetDiagramData();
        diagram.append("@startuml\n\n");
        diagram.append("' Created by EObjectRefsBuilder (" + EObjectRefsGenerator.timestamp() + ")\n\n");
        diagram.append("hide empty members\n\n");
        if (config.isHorizontalLayout()) {
            diagram.append("left to right direction\n\n");
        } else {
            diagram.append("top to bottom direction\n\n");
        }
        EObjectRefsGenerator.buildContent(diagram, eObject, config);
        diagram.append("\n@enduml");
    }

    private static void buildContent(PlantUmlDiagram diagram, EObject selectedEObj, EObjectRefsConfig config) {
        HashSet<Object> nodes = new HashSet<Object>();
        HashSet<String> connections = new HashSet<String>();
        Collection<EStructuralFeature.Setting> references = EObjectRefsGenerator.filterReferences(EObjectRefsGenerator.getAllReferencesTo(selectedEObj), config);
        diagram.append("\n' ===== Main object =====\n\n");
        EObjectRefsGenerator.createClass(selectedEObj, nodes, diagram);
        diagram.append("\n' ===== Referring objects (and their containers) =====\n\n");
        for (EStructuralFeature.Setting setting : references) {
            EObject eObject = setting.getEObject();
            boolean created = EObjectRefsGenerator.createClass(eObject, nodes, diagram);
            if (!created || EObjectRefsGenerator.isNamePresent(eObject)) continue;
            EObjectRefsGenerator.createContainer(eObject, config.isShowReferenceLabels(), nodes, connections, diagram);
        }
        diagram.append("\n' ===== References =====\n\n");
        for (EStructuralFeature.Setting setting : references) {
            EObjectRefsGenerator.createConnection(setting.getEObject(), selectedEObj, setting.getEStructuralFeature(), config.isShowReferenceLabels(), connections, diagram);
        }
    }

    private static Collection<EStructuralFeature.Setting> getAllReferencesTo(EObject selectedEObj) {
        Resource eResource = selectedEObj.eResource();
        if (eResource == null) {
            return EcoreUtil.UsageCrossReferencer.find((EObject)selectedEObj, (EObject)EcoreUtil.getRootContainer((EObject)selectedEObj));
        }
        if (eResource.getResourceSet() == null) {
            return EcoreUtil.UsageCrossReferencer.find((EObject)selectedEObj, (Resource)eResource);
        }
        return EcoreUtil.UsageCrossReferencer.find((EObject)selectedEObj, (ResourceSet)eResource.getResourceSet());
    }

    private static Collection<EStructuralFeature.Setting> filterReferences(Collection<EStructuralFeature.Setting> settings, EObjectRefsConfig config) {
        return settings.stream().filter(s -> EObjectRefsGenerator.isVisibleReference(s.getEStructuralFeature(), config)).toList();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isVisibleReference(EStructuralFeature feature, EObjectRefsConfig config) {
        EStructuralFeature eStructuralFeature = feature;
        if (eStructuralFeature instanceof EReference) {
            void ref;
            EReference eReference = (EReference)eStructuralFeature;
            EReference cfr_ignored_0 = (EReference)eStructuralFeature;
            return !ref.isContainment() && (!ref.isDerived() || config.isShowDerivedReferences());
        }
        return false;
    }

    private static boolean createClass(EObject selectedEObj, Set<Object> nodes, PlantUmlDiagram diagram) {
        boolean success = nodes.add(selectedEObj);
        if (success) {
            String name = EObjectRefsGenerator.getName(selectedEObj);
            String className = selectedEObj.eClass().getName();
            String id = diagram.getOrCreateId((Object)selectedEObj);
            diagram.append("class \"" + name + "\" as " + id + " << (O,#B4A7E5) " + className + " >>" + " [[#" + id + "]]");
            diagram.append("\n");
        }
        return success;
    }

    private static void createContainer(EObject eObject, boolean showLabel, Set<Object> nodes, Set<String> connections, PlantUmlDiagram diagram) {
        EObject eContainerObj = eObject.eContainer();
        if (eContainerObj == null) {
            return;
        }
        EObjectRefsGenerator.createClass(eContainerObj, nodes, diagram);
        EObjectRefsGenerator.createConnection(eContainerObj, eObject, (EStructuralFeature)eObject.eContainmentFeature(), showLabel, connections, diagram);
        if (!EObjectRefsGenerator.isNamePresent(eContainerObj)) {
            EObjectRefsGenerator.createContainer(eContainerObj, showLabel, nodes, connections, diagram);
        }
    }

    private static void createConnection(EObject from, EObject to, EStructuralFeature eStructuralFeature, boolean showLabel, Set<String> connections, PlantUmlDiagram diagram) {
        if (!(eStructuralFeature instanceof EReference)) {
            return;
        }
        EReference reference = (EReference)eStructuralFeature;
        String id1 = diagram.getOrCreateId((Object)from);
        String id2 = diagram.getOrCreateId((Object)to);
        String arrowStyle = reference.isDerived() ? "[#gray,dashed]" : "";
        String arrow = reference.isContainment() ? " *-- " : " -" + arrowStyle + "-> ";
        String labelSeparator = eStructuralFeature.isDerived() ? " #text:gray : " : " : ";
        String label = showLabel ? String.valueOf(labelSeparator) + eStructuralFeature.getName() : "";
        String conn = String.valueOf(id1) + arrow + id2 + label;
        if (connections.add(conn)) {
            diagram.append(conn);
            diagram.append("\n");
        }
    }

    private static boolean isNamePresent(EObject eObject) {
        EStructuralFeature nameFeature = eObject.eClass().getEStructuralFeature("name");
        return nameFeature != null;
    }

    private static String getName(EObject eObject) {
        Object originalName;
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature("name");
        if (eStructuralFeature != null && (originalName = eObject.eGet(eStructuralFeature)) != null && originalName.toString().length() > 0) {
            return (String)originalName;
        }
        return String.valueOf(eObject.eClass().getName()) + "__" + eObject.hashCode();
    }

    static String timestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return dateFormat.format(new Date());
    }
}

