/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.hw;

import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class DiagramLocation {
    private IFolder diagramFolder = null;
    private String plantUmlFileName = null;
    private String plantUmlFilePath = null;
    private String diagramFileName = null;
    private String diagramFilePath = null;

    public DiagramLocation(EObject eObject) {
        IFile file = this.getResourceFile(eObject);
        if (file == null) {
            return;
        }
        IFolder folder = this.getOrCreateDiagramFolder(file, "hwModelVisualization");
        if (folder == null) {
            return;
        }
        this.initialize(folder, this.buildFilename(file, eObject));
    }

    public DiagramLocation(IFolder folder, String baseFilename) {
        if (folder == null || !folder.exists()) {
            return;
        }
        if (baseFilename == null || baseFilename.isEmpty()) {
            return;
        }
        this.initialize(folder, baseFilename);
    }

    private void initialize(IFolder folder, String baseFilename) {
        this.diagramFolder = folder;
        this.plantUmlFileName = String.valueOf(baseFilename) + ".plantuml";
        this.plantUmlFilePath = folder.getFile(this.plantUmlFileName).getLocation().toString();
        this.diagramFileName = String.valueOf(baseFilename) + ".svg";
        this.diagramFilePath = folder.getFile(this.diagramFileName).getLocation().toString();
    }

    private IFile getResourceFile(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource eResource = eObject.eResource();
        if (eResource == null) {
            return null;
        }
        URI uri = eResource.getURI();
        Path path = new Path(uri.toPlatformString(true));
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
    }

    private IFolder getOrCreateDiagramFolder(IFile file, String folderName) {
        if (file == null) {
            return null;
        }
        IContainer parentFolder = file.getParent();
        if (parentFolder == null) {
            return null;
        }
        IFolder folder = parentFolder.getFolder((IPath)new Path(folderName));
        if (!folder.exists()) {
            try {
                folder.create(0, true, null);
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return folder;
    }

    private String buildFilename(IFile file, EObject eObject) {
        String modelName = "model";
        if (file != null && file.getName() != null) {
            modelName = file.getName().replaceFirst("[.][^.]+$", "");
        }
        String extendedName = "";
        if (eObject instanceof HWModel) {
            extendedName = "_hw";
        } else if (eObject instanceof HwStructure) {
            extendedName = "_structure";
        }
        return String.valueOf(modelName) + extendedName;
    }

    public IFolder getDiagramFolder() {
        return this.diagramFolder;
    }

    public String getPlantUmlFileName() {
        return this.plantUmlFileName;
    }

    public String getPlantUmlFilePath() {
        return this.plantUmlFilePath;
    }

    public String getDiagramFileName() {
        return this.diagramFileName;
    }

    public String getDiagramFilePath() {
        return this.diagramFilePath;
    }

    public boolean isValid() {
        return this.diagramFolder != null;
    }
}

