/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.sim.os;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Sim-OS-SchedulerAllocation", checks={"Scheduler must be referred to by exactly one scheduler allocation"})
public class SimOsSchedulerAllocation
extends AmaltheaValidation {
    public static final String MESSAGE_MANY_INTERRUPT_CONTROLLER_ALLOCATIONS = "ISR is referred to by more than one scheduler allocation";
    public static final String MESSAGE_NO_INTERRUPT_CONTROLLER_ALLOCATION = "ISR is not referred to by any scheduler allocation";
    public static final String MESSAGE_MANY_SCHEDULER_ALLOCATIONS = "Scheduler is referred to by more than one scheduler allocation";
    public static final String MESSAGE_NO_SCHEDULER_ALLOCATION = "Scheduler is not referred to by any scheduler allocation";

    public EClassifier getEClassifier() {
        return ePackage.getScheduler();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof InterruptController) {
            InterruptController isrController = (InterruptController)eObject;
            Set allocations = AmaltheaIndex.getReferringObjects((EObject)isrController).stream().filter(SchedulerAllocation.class::isInstance).collect(Collectors.toSet());
            if (allocations.isEmpty()) {
                this.addIssue(results, (EObject)isrController, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), MESSAGE_NO_INTERRUPT_CONTROLLER_ALLOCATION);
            } else if (allocations.size() > 1) {
                this.addIssue(results, (EObject)isrController, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), MESSAGE_MANY_INTERRUPT_CONTROLLER_ALLOCATIONS);
            }
        } else if (eObject instanceof Scheduler) {
            Scheduler scheduler = (Scheduler)eObject;
            Set allocations = AmaltheaIndex.getReferringObjects((EObject)scheduler).stream().filter(SchedulerAllocation.class::isInstance).collect(Collectors.toSet());
            if (allocations.isEmpty()) {
                this.addIssue(results, (EObject)scheduler, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), MESSAGE_NO_SCHEDULER_ALLOCATION);
            } else if (allocations.size() > 1) {
                this.addIssue(results, (EObject)scheduler, (EStructuralFeature)ePackage.getScheduler_SchedulerAllocations(), MESSAGE_MANY_SCHEDULER_ALLOCATIONS);
            }
        }
    }
}

