/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.ui.editor.autoedit.AbstractTerminalsEditStrategy;

public class SingleLineTerminalsStrategy
extends AbstractTerminalsEditStrategy {
    public static StrategyPredicate DEFAULT = new StrategyPredicate(){

        public boolean isInsertClosingBracket(IDocument doc, int offset) throws BadLocationException {
            if (doc.getLength() <= offset) {
                return true;
            }
            boolean result = !Character.isJavaIdentifierStart(doc.getChar(offset));
            return result;
        }
    };
    private StrategyPredicate strategy;

    public SingleLineTerminalsStrategy(String left, String right, StrategyPredicate strategy) {
        super(left, right);
        this.strategy = strategy;
    }

    protected void internalCustomizeDocumentCommand(IDocument document, DocumentCommand command) throws BadLocationException {
        this.handleInsertLeftTerminal(document, command);
        this.handleInsertRightTerminal(document, command);
        this.handleDeletion(document, command);
    }

    protected void handleInsertLeftTerminal(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.text.length() > 0 && this.appliedText(document, command).endsWith(this.getLeftTerminal()) && this.isInsertClosingTerminal(document, command.offset + command.length)) {
            int closing;
            String documentContent = this.getDocumentContent(document, command);
            int opening = this.count(this.getLeftTerminal(), documentContent);
            int occurences = opening + (closing = this.count(this.getRightTerminal(), documentContent));
            if (occurences % 2 == 0 && command.text.length() - command.length + documentContent.length() >= this.getLeftTerminal().length()) {
                command.caretOffset = command.offset + command.text.length();
                command.text = String.valueOf(command.text) + this.getRightTerminal();
                command.shiftsCaret = false;
            }
        }
    }

    protected boolean isInsertClosingTerminal(IDocument document, int i) {
        try {
            return this.strategy.isInsertClosingBracket(document, i);
        }
        catch (BadLocationException e) {
            if (this.debug) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    protected String appliedText(IDocument document, DocumentCommand command) throws BadLocationException {
        String string = document.get(0, command.offset);
        return String.valueOf(string) + command.text;
    }

    protected void handleDeletion(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.text.equals("") && command.length == 1) {
            if (command.offset + this.getRightTerminal().length() + this.getLeftTerminal().length() > document.getLength()) {
                return;
            }
            if (command.offset + command.length - this.getLeftTerminal().length() < 0) {
                return;
            }
            if (command.length != this.getLeftTerminal().length()) {
                return;
            }
            String string = document.get(command.offset, this.getLeftTerminal().length() + this.getRightTerminal().length());
            if (string.equals(String.valueOf(this.getLeftTerminal()) + this.getRightTerminal())) {
                command.length = this.getLeftTerminal().length() + this.getRightTerminal().length();
            }
        }
    }

    protected void handleInsertRightTerminal(IDocument document, DocumentCommand command) throws BadLocationException {
        if (command.text.equals(this.getRightTerminal())) {
            int closing;
            if (command.offset + command.length + this.getRightTerminal().length() > document.getLength()) {
                return;
            }
            String documentContent = this.getDocumentContent(document, command);
            int opening = this.count(this.getLeftTerminal(), documentContent);
            if (opening <= (closing = this.count(this.getRightTerminal(), documentContent)) && this.getRightTerminal().equals(document.get(command.offset + command.length, command.text.length()))) {
                command.length += this.getRightTerminal().length();
            }
        }
    }

    public static class Factory {
        @Inject
        private MembersInjector<SingleLineTerminalsStrategy> injector;

        public SingleLineTerminalsStrategy newInstance(String left, String right) {
            return this.newInstance(left, right, DEFAULT);
        }

        public SingleLineTerminalsStrategy newInstance(String left, String right, StrategyPredicate predicate) {
            SingleLineTerminalsStrategy strategy = new SingleLineTerminalsStrategy(left, right, predicate);
            this.injector.injectMembers((Object)strategy);
            return strategy;
        }
    }

    public static interface StrategyPredicate {
        public boolean isInsertClosingBracket(IDocument var1, int var2) throws BadLocationException;
    }
}

