/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class AddSingletonToSymbolicName
extends AbstractManifestMarkerResolution {
    private boolean fisDirective;

    public AddSingletonToSymbolicName(int type, boolean directive) {
        super(type);
        this.fisDirective = directive;
    }

    public String getDescription() {
        if (this.fisDirective) {
            return PDEUIMessages.AddSingleon_dir_desc;
        }
        return PDEUIMessages.AddSingleon_att_desc;
    }

    public String getLabel() {
        if (this.fisDirective) {
            return PDEUIMessages.AddSingleon_dir_label;
        }
        return PDEUIMessages.AddSingleon_att_label;
    }

    protected void createChange(BundleModel model) {
        Bundle bun;
        IManifestHeader header;
        IBundle bundle = model.getBundle();
        if (bundle instanceof Bundle && (header = (bun = (Bundle)bundle).getManifestHeader("Bundle-SymbolicName")) instanceof BundleSymbolicNameHeader) {
            if (this.fisDirective && TargetPlatformHelper.getTargetVersion() >= 3.1) {
                bundle.setHeader("Bundle-ManifestVersion", "2");
            } else if (!this.fisDirective && TargetPlatformHelper.getTargetVersion() < 3.1) {
                bundle.setHeader("Bundle-ManifestVersion", null);
            }
            ((BundleSymbolicNameHeader)header).setSingleton(true);
        }
    }
}

