/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis;

import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractScaleSheet;

public class AxisScaleSheet
extends AbstractScaleSheet {
    private Axis axis;
    private int axisAngleType;

    public AxisScaleSheet(String title, ChartWizardContext context, Axis axis, int axisAngleType) {
        super(title, context);
        this.axis = axis;
        this.axisAngleType = axisAngleType;
    }

    private Axis getAxisForProcessing() {
        return this.axis;
    }

    protected Scale getScale() {
        return this.getAxisForProcessing().getScale();
    }

    protected int getValueType() {
        if (this.getAxisForProcessing().getType() == AxisType.TEXT_LITERAL) {
            return 0;
        }
        if (this.getAxisForProcessing().getType() == AxisType.DATE_TIME_LITERAL) {
            return 2;
        }
        return 1;
    }

    protected void setState() {
        boolean bEnabled = !this.getAxisForProcessing().isCategoryAxis() && this.getAxisForProcessing().getType() != AxisType.TEXT_LITERAL;
        this.setState(bEnabled);
        if (this.axisAngleType != 2) {
            this.btnShowOutside.setEnabled(false);
            this.btnShowOutside.setSelection(false);
            this.getScale().setShowOutside(false);
        } else {
            this.btnAutoExpand.setSelection(true);
            this.getScale().setAutoExpand(true);
        }
        boolean bAxisX = this.axisAngleType == 1;
        boolean bEnableAutoExpand = this.btnStepAuto.getSelection() && bAxisX && this.getAxisForProcessing().getType() != AxisType.TEXT_LITERAL && !this.getAxisForProcessing().isCategoryAxis();
        this.btnAutoExpand.setEnabled(bEnableAutoExpand);
        if (this.getAxisForProcessing().getType() == AxisType.LINEAR_LITERAL && !this.getAxisForProcessing().isCategoryAxis()) {
            if (!this.getAxisForProcessing().getScale().isSetStepNumber()) {
                this.btnFactor.setEnabled(true);
                if (this.btnFactor.getSelection()) {
                    this.txtFactor.setEnabled(true);
                } else {
                    this.txtFactor.setEnabled(false);
                }
            }
            if (this.btnFactor.getSelection()) {
                this.btnStepNumber.setEnabled(false);
                this.spnStepNumber.setEnabled(false);
                this.lblMax.setEnabled(false);
                this.txtScaleMax.setEnabled(false);
            }
        }
    }
}

