/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Matrix3f;
import org.eclipse.draw3d.geometry.Matrix3fImpl;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class GraphicsState {
    private Boolean m_advanced;
    private Integer m_alpha;
    private Integer m_antialias;
    private Color m_backgroundColor;
    private Pattern m_backgroundPattern;
    private PrecisionRectangle m_clip;
    private Integer m_fillRule;
    private Font m_font;
    private Color m_foregroundColor;
    private Pattern m_foregroundPattern;
    private Integer m_interpolation;
    private Integer m_lineCap;
    private int[] m_lineDash;
    private int m_lineDashLength;
    private Integer m_lineJoin;
    private FontMetrics m_fontMetrics;
    private Float m_lineMiterLimit;
    private Integer m_lineStyle;
    private Float m_lineWidth;
    private final GraphicsState m_parentState;
    private Integer m_textAntialias;
    private Matrix3fImpl m_transformation;
    private Boolean m_xorMode;
    private Font m_metricsFont;

    public static GraphicsState createDefaultState() {
        Display display = Display.getDefault();
        Color foregroundColor = display.getSystemColor(2);
        Color backgroundColor = display.getSystemColor(1);
        GraphicsState state = new GraphicsState();
        state.setClip(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        state.setAdvanced(true);
        state.setForegroundColor(foregroundColor);
        state.setBackgroundColor(backgroundColor);
        state.setAlpha(255);
        state.setLineWidth(1.0f);
        state.setLineStyle(1);
        state.setLineCap(1);
        state.setLineJoin(1);
        state.setLineMiterLimit(11.0f);
        state.setFont(display.getSystemFont());
        state.setTransformation(Matrix3f.IDENTITY);
        state.setXORMode(false);
        state.setAntialias(1);
        state.setInterpolation(0);
        state.setTextAntialias(1);
        state.setFillRule(2);
        return state;
    }

    public FontMetrics getFontMetrics() {
        Font font = this.getFont();
        if (font == null) {
            return null;
        }
        if (font.equals((Object)this.m_metricsFont) && this.m_fontMetrics != null) {
            return this.m_fontMetrics;
        }
        this.m_metricsFont = font;
        Device device = this.m_metricsFont.getDevice();
        Image image = null;
        GC gc = null;
        try {
            image = new Image(device, 1, 1);
            gc = new GC((Drawable)image);
            gc.setFont(this.m_metricsFont);
            FontMetrics fontMetrics = this.m_fontMetrics = gc.getFontMetrics();
            return fontMetrics;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    private GraphicsState() {
        this.m_parentState = null;
    }

    public GraphicsState(GraphicsState i_parentState) {
        if (i_parentState == null) {
            throw new NullPointerException("i_parentState must not be null");
        }
        this.m_parentState = i_parentState;
    }

    public void clipRect(Rectangle i_clip) {
        if (i_clip == null) {
            return;
        }
        PrecisionRectangle currentClip = this.getClip();
        if (currentClip != null && !currentClip.equals((Object)i_clip)) {
            if (this.m_clip == null) {
                this.m_clip = new PrecisionRectangle((Rectangle)currentClip);
            }
            double l = Math.max(this.m_clip.preciseX(), i_clip.preciseX());
            double r = Math.min(this.m_clip.preciseX() + this.m_clip.preciseWidth(), i_clip.preciseX() + i_clip.preciseWidth());
            double t = Math.max(this.m_clip.preciseY(), i_clip.preciseY());
            double b = Math.min(this.m_clip.preciseY() + this.m_clip.preciseHeight(), i_clip.preciseY() + i_clip.preciseHeight());
            if (r < l || b < t) {
                r = l - 1.0;
                b = t - 1.0;
            }
            this.m_clip.setX(l);
            this.m_clip.setY(t);
            this.m_clip.setWidth(r - l);
            this.m_clip.setHeight(b - t);
        } else {
            this.m_clip = new PrecisionRectangle(i_clip);
        }
    }

    public boolean getAdvanced() {
        if (this.m_advanced != null) {
            return this.m_advanced;
        }
        return this.m_parentState.getAdvanced();
    }

    public int getAlpha() {
        if (this.m_alpha != null) {
            return this.m_alpha;
        }
        return this.m_parentState.getAlpha();
    }

    public int getAntialias() {
        if (this.m_antialias != null) {
            return this.m_antialias;
        }
        return this.m_parentState.getAntialias();
    }

    public Color getBackgroundColor() {
        if (this.m_backgroundColor != null) {
            return this.m_backgroundColor;
        }
        return this.m_parentState.getBackgroundColor();
    }

    public Pattern getBackgroundPattern() {
        if (this.m_backgroundPattern != null) {
            return this.m_backgroundPattern;
        }
        if (this.m_parentState != null) {
            return this.m_parentState.getBackgroundPattern();
        }
        return null;
    }

    public PrecisionRectangle getClip() {
        if (this.m_clip != null) {
            return this.m_clip;
        }
        if (this.m_parentState != null) {
            return this.m_parentState.getClip();
        }
        return null;
    }

    public int getFillRule() {
        if (this.m_fillRule != null) {
            return this.m_fillRule;
        }
        return this.m_parentState.getFillRule();
    }

    public Font getFont() {
        if (this.m_font != null) {
            return this.m_font;
        }
        return this.m_parentState.getFont();
    }

    public Color getForegroundColor() {
        if (this.m_foregroundColor != null) {
            return this.m_foregroundColor;
        }
        return this.m_parentState.getForegroundColor();
    }

    public Pattern getForegroundPattern() {
        if (this.m_foregroundPattern != null) {
            return this.m_foregroundPattern;
        }
        if (this.m_parentState != null) {
            return this.m_parentState.getForegroundPattern();
        }
        return null;
    }

    public int getInterpolation() {
        if (this.m_interpolation != null) {
            return this.m_interpolation;
        }
        return this.m_parentState.getInterpolation();
    }

    public int getLineCap() {
        if (this.m_lineCap != null) {
            return this.m_lineCap;
        }
        return this.m_parentState.getLineCap();
    }

    public int[] getLineDash() {
        if (this.m_lineDash != null) {
            return this.m_lineDash;
        }
        if (this.m_parentState != null) {
            return this.m_parentState.getLineDash();
        }
        return null;
    }

    public int getLineDashLength() {
        if (this.m_lineDash != null) {
            return this.m_lineDashLength;
        }
        return this.m_parentState.getLineDashLength();
    }

    public int getLineJoin() {
        if (this.m_lineJoin != null) {
            return this.m_lineJoin;
        }
        return this.m_parentState.getLineJoin();
    }

    public float getLineMiterLimit() {
        if (this.m_lineMiterLimit != null) {
            return this.m_lineMiterLimit.floatValue();
        }
        return this.m_parentState.getLineMiterLimit();
    }

    public int getLineStyle() {
        if (this.m_lineStyle != null) {
            return this.m_lineStyle;
        }
        return this.m_parentState.getLineStyle();
    }

    public float getLineWidth() {
        if (this.m_lineWidth != null) {
            return this.m_lineWidth.floatValue();
        }
        return this.m_parentState.getLineWidth();
    }

    public GraphicsState getParent() {
        return this.m_parentState;
    }

    public int getTextAntialias() {
        if (this.m_textAntialias != null) {
            return this.m_textAntialias;
        }
        return this.m_parentState.getTextAntialias();
    }

    public Matrix3f getTransformation() {
        if (this.m_transformation != null) {
            return this.m_transformation;
        }
        return this.m_parentState.getTransformation();
    }

    public boolean getXORMode() {
        if (this.m_xorMode != null) {
            return this.m_xorMode;
        }
        return this.m_parentState.getXORMode();
    }

    public void rotate(float i_degrees) {
        if (this.m_transformation == null) {
            this.m_transformation = new Matrix3fImpl();
        }
        Matrix3f rot = Draw3DCache.getMatrix3f();
        try {
            double radians = Math.toRadians(i_degrees);
            float sin = (float)Math.sin(radians);
            float cos = (float)Math.cos(radians);
            rot.setIdentity();
            rot.set(0, 0, cos);
            rot.set(1, 0, sin);
            rot.set(1, 1, cos);
            rot.set(0, 1, -sin);
            Math3D.mul((IMatrix3f)rot, (IMatrix3f)this.m_transformation, (Matrix3f)this.m_transformation);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnMatrix3f((Matrix3f[])new Matrix3f[]{rot});
            throw throwable;
        }
        Draw3DCache.returnMatrix3f((Matrix3f[])new Matrix3f[]{rot});
    }

    public void scale(float i_horizontal, float i_vertical) {
        if (this.m_transformation == null) {
            this.m_transformation = new Matrix3fImpl();
        }
        Vector2f scale = Draw3DCache.getVector2f();
        try {
            scale.set(i_horizontal, i_vertical);
            Math3D.scale((IVector2f)scale, (IMatrix3f)this.m_transformation, (Matrix3f)this.m_transformation);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector2f((Vector2f[])new Vector2f[]{scale});
            throw throwable;
        }
        Draw3DCache.returnVector2f((Vector2f[])new Vector2f[]{scale});
    }

    public void setAdvanced(boolean i_advanced) {
        this.m_advanced = i_advanced;
    }

    public void setAlpha(int i_alpha) {
        this.m_alpha = i_alpha;
    }

    public void setAntialias(int i_antialias) {
        this.m_antialias = i_antialias;
    }

    public void setBackgroundColor(Color i_backgroundColor) {
        this.m_backgroundColor = i_backgroundColor;
    }

    public void setBackgroundPattern(Pattern i_backgroundPattern) {
        this.m_backgroundPattern = i_backgroundPattern;
    }

    public void setClip(Rectangle i_clip) {
        if (i_clip == null) {
            this.m_clip = null;
            return;
        }
        if (this.m_clip == null) {
            this.m_clip = new PrecisionRectangle(i_clip);
            return;
        }
        this.m_clip.setX(i_clip.preciseX());
        this.m_clip.setY(i_clip.preciseY());
        this.m_clip.setWidth(i_clip.preciseWidth());
        this.m_clip.setHeight(i_clip.preciseHeight());
    }

    public void setFillRule(int i_fillRule) {
        this.m_fillRule = i_fillRule;
    }

    public void setFont(Font i_font) {
        this.m_font = i_font;
        this.m_fontMetrics = null;
        this.m_metricsFont = null;
    }

    public void setForegroundColor(Color i_foregroundColor) {
        this.m_foregroundColor = i_foregroundColor;
    }

    public void setForegroundPattern(Pattern i_foregroundPattern) {
        this.m_foregroundPattern = i_foregroundPattern;
    }

    public void setInterpolation(int i_interpolation) {
        this.m_interpolation = i_interpolation;
    }

    public void setLineCap(int i_lineCap) {
        this.m_lineCap = i_lineCap;
    }

    public void setLineDash(int[] i_lineDash) {
        this.m_lineDash = i_lineDash;
        this.m_lineDashLength = 0;
        if (this.m_lineDash != null) {
            int i = 0;
            while (i < this.m_lineDash.length) {
                this.m_lineDashLength += this.m_lineDash[i];
                ++i;
            }
        }
    }

    public void setLineJoin(int i_lineJoin) {
        this.m_lineJoin = i_lineJoin;
    }

    public void setLineMiterLimit(float i_lineMiterLimit) {
        this.m_lineMiterLimit = Float.valueOf(i_lineMiterLimit);
    }

    public void setLineStyle(int i_lineStyle) {
        this.m_lineStyle = i_lineStyle;
    }

    public void setLineWidth(float i_lineWidth) {
        this.m_lineWidth = Float.valueOf(i_lineWidth);
    }

    public void setTextAntialias(int i_textAntialias) {
        this.m_textAntialias = i_textAntialias;
    }

    public void setTransformation(IMatrix3f i_transformation) {
        if (this.m_transformation == null) {
            this.m_transformation = new Matrix3fImpl(i_transformation);
        } else {
            this.m_transformation.set(i_transformation);
        }
    }

    public void setXORMode(boolean i_xorMode) {
        this.m_xorMode = i_xorMode;
    }

    public void shear(float i_horz, float i_vert) {
        if (this.m_transformation == null) {
            this.m_transformation = new Matrix3fImpl();
        }
        Matrix3f shear = Draw3DCache.getMatrix3f();
        try {
            shear.setIdentity();
            shear.set(1, 0, i_horz);
            shear.set(0, 1, i_vert);
            Math3D.mul((IMatrix3f)shear, (IMatrix3f)this.m_transformation, (Matrix3f)this.m_transformation);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnMatrix3f((Matrix3f[])new Matrix3f[]{shear});
            throw throwable;
        }
        Draw3DCache.returnMatrix3f((Matrix3f[])new Matrix3f[]{shear});
    }

    public void translate(float i_dX, float i_dY) {
        if (this.m_transformation == null) {
            this.m_transformation = new Matrix3fImpl();
        }
        Vector2f trans = Draw3DCache.getVector2f();
        try {
            trans.set(i_dX, i_dY);
            Math3D.translate((IMatrix3f)this.m_transformation, (IVector2f)trans, (Matrix3f)this.m_transformation);
            if (this.m_clip == null) {
                this.m_clip = new PrecisionRectangle((Rectangle)this.m_parentState.getClip());
            }
            this.m_clip.translate((Point)new PrecisionPoint((double)(-i_dX), (double)(-i_dY)));
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector2f((Vector2f[])new Vector2f[]{trans});
            throw throwable;
        }
        Draw3DCache.returnVector2f((Vector2f[])new Vector2f[]{trans});
    }
}

