/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.preferences;

import java.util.logging.Logger;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.camera.FirstPersonCamera;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.ui.preferences.Draw3DPreferenceDistributor;
import org.eclipse.draw3d.ui.preferences.PrefNames;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ScenePreferenceDistributor
extends Draw3DPreferenceDistributor
implements PrefNames {
    public static final String DEFAULT_CAMERA_TYPE = FirstPersonCamera.class.getName();
    private static final Logger log = Logger.getLogger(ScenePreferenceDistributor.class.getName());
    private IScene m_scene;

    public ScenePreferenceDistributor(IScene i_scene) {
        this.m_scene = i_scene;
    }

    private ICamera getCamera(String type) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        try {
            Class<?> clazz = Class.forName(type);
            return (ICamera)clazz.newInstance();
        }
        catch (Exception ex) {
            if (DEFAULT_CAMERA_TYPE.equals(type)) {
                throw new IllegalArgumentException("Default camera type " + DEFAULT_CAMERA_TYPE + " is unavailable", ex);
            }
            log.severe("Unable to load camera type " + type);
            return this.getCamera(DEFAULT_CAMERA_TYPE);
        }
    }

    public void init(IPreferenceStore i_store) {
        this.m_scene.setDrawAxes(i_store.getBoolean("lwsDrawCoordinateAxes"));
        this.m_scene.setDebug(i_store.getBoolean("lwsDebug"));
        this.setSceneBackgroundColor(i_store.getString("lwsBackgroundColor"));
        this.setSceneCamera(i_store.getString("lwsCameraType"));
        this.setSceneFontAntialias(i_store.getString("lwsFontAntialias"));
    }

    public void propertyChange(PropertyChangeEvent i_event) {
        String name = i_event.getProperty();
        String newValue = i_event.getNewValue().toString();
        if (name == null || newValue == null) {
            return;
        }
        if (newValue.equals(i_event.getOldValue())) {
            return;
        }
        if (name.equals("lwsDrawCoordinateAxes")) {
            this.m_scene.setDrawAxes(StringConverter.asBoolean((String)newValue));
        } else if (name.equals("lwsDebug")) {
            this.m_scene.setDebug(StringConverter.asBoolean((String)newValue));
        } else if (name.equals("lwsBackgroundColor")) {
            this.setSceneBackgroundColor(newValue);
        } else if (name.equals("lwsCameraType")) {
            this.setSceneCamera(newValue);
        } else if (name.equals("lwsFontAntialias")) {
            this.setSceneFontAntialias(newValue);
        }
        this.m_scene.render(name.equals("lwsFontAntialias"));
    }

    private void setSceneFontAntialias(String i_value) {
        if (i_value.equals("on")) {
            this.m_scene.setFontAntialias(IScene.FontAntialias.ON);
        } else if (i_value.equals("off")) {
            this.m_scene.setFontAntialias(IScene.FontAntialias.OFF);
        } else {
            this.m_scene.setFontAntialias(IScene.FontAntialias.EDITOR);
        }
    }

    private void setSceneBackgroundColor(String i_value) {
        RGB rgb = StringConverter.asRGB((String)i_value);
        Color color = new Color((Device)Display.getCurrent(), rgb);
        this.m_scene.setBackgroundColor(color);
    }

    private void setSceneCamera(String i_value) {
        ICamera newCamera = this.getCamera(i_value);
        ICamera currentCamera = this.m_scene.getCamera();
        if (currentCamera != null && !currentCamera.getClass().equals(newCamera.getClass())) {
            this.m_scene.setCamera(newCamera);
        }
    }
}

