/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.tests;

import java.io.IOException;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.metaabm.MetaABMFactory;
import org.metaabm.SContext;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.tests.Transformer;
import org.metaabm.xsd.MetaABMPersist;

public abstract class BasePersistTest
extends TestCase {
    protected static MetaABMFactory f = MetaABMFactory.eINSTANCE;
    protected static MetaABMActFactory fa = MetaABMActFactory.eINSTANCE;
    protected SContext referenceContext;
    protected Command referenceCommand;
    protected SContext testContext;
    protected Command testCommand;
    protected SContext persistContext;
    protected String persistName;
    protected MetaABMPersist referencePersist;
    protected MetaABMPersist doPersist;
    protected MetaABMPersist undoPersist;
    protected MetaABMPersist redoPersist;
    protected MetaABMPersist testPersist;
    protected String path = "test/results/";

    public BasePersistTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.referenceContext = f.createSContext();
        this.testContext = f.createSContext();
        this.persistName = String.valueOf(this.path) + this.getName() + "Test.metaabm";
        this.referencePersist = MetaABMPersist.create((SContext)this.referenceContext, (String)this.persistName);
        this.referencePersist.save();
        this.doPersist = MetaABMPersist.create((SContext)this.testContext, (String)(String.valueOf(this.path) + this.getName() + "TestDo.metaabm"));
        this.testPersist = MetaABMPersist.create((SContext)this.testContext, (String)(String.valueOf(this.path) + this.getName() + "TestComp.metaabm"));
        this.undoPersist = MetaABMPersist.create((SContext)this.testContext, (String)(String.valueOf(this.path) + this.getName() + "TestUndo.metaabm"));
        this.redoPersist = MetaABMPersist.create((SContext)this.testContext, (String)(String.valueOf(this.path) + this.getName() + "TestRedo.metaabm"));
    }

    protected void execTransform(Transformer transformer) {
        this.execTransform(transformer, 0);
    }

    protected void execTransform(Transformer transformer, int commandIndex) {
        try {
            BasePersistTest.assertTrue((boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            transformer.prepare(this.referenceContext);
            try {
                transformer.exec();
            }
            catch (UnsupportedOperationException e) {
                throw new RuntimeException("Unexecutable Command: " + transformer, e);
            }
            this.referencePersist.save();
            if (transformer.modifies()) {
                BasePersistTest.assertFalse((String)("No change resulting from command " + commandIndex), (boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            }
            transformer.prepare(this.testContext);
            transformer.exec();
            BasePersistTest.assertNotSame((Object)this.referencePersist, (Object)this.testPersist);
            BasePersistTest.assertNotSame((Object)this.referenceContext, (Object)this.testContext);
            this.referencePersist.save();
            this.testPersist.save();
            this.doPersist.save();
            BasePersistTest.assertTrue((String)"Model cannot be saved properly.", (boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            this.checkPersist();
            boolean equals = EcoreUtil.equals((EObject)this.referenceContext, (EObject)this.persistContext);
            if (!equals) {
                System.out.println(new StringBuffer(" : " + this.referenceContext).insert(0, "[BasePersistTest.checkTransform] referenceContext.eAllContents())"));
                System.out.println(new StringBuffer(" : " + this.persistContext).insert(0, "[BasePersistTest.checkTransform] referenceContext.eAllContents())"));
            }
            BasePersistTest.assertTrue((String)"Persistence failure", (boolean)equals);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while executing " + commandIndex + ": " + transformer, e);
        }
    }

    protected void undoTransform(Transformer transformer, int commandIndex) {
        try {
            BasePersistTest.assertTrue((boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            transformer.prepare(this.referenceContext);
            transformer.undo();
            this.referencePersist.save();
            if (transformer.modifies()) {
                BasePersistTest.assertFalse((boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            }
            transformer.prepare(this.testContext);
            transformer.undo();
            this.referencePersist.save();
            this.testPersist.save();
            this.undoPersist.save();
            BasePersistTest.assertTrue((boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            this.checkPersist();
            boolean equals = EcoreUtil.equals((EObject)this.referenceContext, (EObject)this.persistContext);
            if (!equals) {
                System.out.println("***not equal***");
                System.out.println("Reference: " + this.referenceContext);
                System.out.println("Persist:" + this.persistContext);
            }
            BasePersistTest.assertTrue((boolean)equals);
        }
        catch (Exception e) {
            e.printStackTrace();
            BasePersistTest.fail((String)("Exception while undoing " + commandIndex + ": " + transformer + "\r\n" + e));
        }
    }

    protected void redoTransform(Transformer transformer, int commandIndex) {
        try {
            BasePersistTest.assertTrue((boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            transformer.prepare(this.referenceContext);
            transformer.redo();
            this.referencePersist.save();
            if (transformer.modifies()) {
                BasePersistTest.assertFalse((boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            }
            transformer.prepare(this.testContext);
            transformer.redo();
            this.referencePersist.save();
            this.testPersist.save();
            this.redoPersist.save();
            BasePersistTest.assertTrue((boolean)EcoreUtil.equals((EObject)this.testContext, (EObject)this.referenceContext));
            this.checkPersist();
            boolean equals = EcoreUtil.equals((EObject)this.referenceContext, (EObject)this.persistContext);
            if (!equals) {
                System.out.println(new StringBuffer(" : " + this.referenceContext).insert(0, "[BasePersistTest.checkTransform] referenceContext.eAllContents())"));
                System.out.println(new StringBuffer(" : " + this.persistContext).insert(0, "[BasePersistTest.checkTransform] referenceContext.eAllContents())"));
            }
            BasePersistTest.assertTrue((boolean)equals);
        }
        catch (Exception e) {
            BasePersistTest.fail((String)("Exception while redoing " + commandIndex + ": " + transformer + "\r\n" + e));
        }
    }

    protected void checkPersist() throws IOException {
        this.referencePersist = MetaABMPersist.create((SContext)this.referenceContext, (String)this.persistName);
        this.referencePersist.save();
        this.referencePersist.setResource(null);
        this.persistContext = this.referencePersist.load();
        BasePersistTest.assertTrue((this.persistContext != this.referenceContext ? 1 : 0) != 0);
        this.referencePersist.save();
    }

    protected void tearDown() throws Exception {
        TestResult res = this.createResult();
        res.failureCount();
        res.errorCount();
    }
}

