/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.acore.edit.commands.test;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amp.amf.acore.edit.commands.test.AddRootCommand;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTransformer;
import org.eclipse.amp.amf.acore.edit.commands.test.CreateAgents;
import org.eclipse.amp.amf.acore.edit.commands.test.CreateSpace;
import org.eclipse.amp.amf.acore.edit.commands.test.CreateSubcontext;
import org.eclipse.amp.amf.acore.edit.commands.test.NewAgentGenCondition;
import org.eclipse.amp.amf.acore.edit.commands.test.NewSubcontextGenCondition;
import org.eclipse.amp.amf.acore.edit.commands.test.PrePostCondition;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAttribute;
import org.metaabm.act.AGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelConstructionCommandTest
extends CommandTest {
    public ModelConstructionCommandTest(String name) {
        super(name);
    }

    public static void buildRoot(List<CommandTransformer> cmds) {
        cmds.add(new AddRootCommand());
    }

    public static void buildSpace(List<CommandTransformer> cmds) {
        cmds.add(new CreateSpace());
    }

    public static void buildAgents(List<CommandTransformer> cmds) {
        cmds.add(new CreateAgents(){

            @Override
            public void addPrePost(List<PrePostCondition> list) {
                super.addPrePost(list);
                list.add(new NewAgentGenCondition());
            }
        });
        cmds.add(new CreateSubcontext(){

            @Override
            public void addPrePost(List<PrePostCondition> list) {
                super.addPrePost(list);
                list.add(new NewSubcontextGenCondition());
            }
        });
    }

    public static void buildBasic(List<CommandTransformer> cmds) {
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
    }

    public void testRoot() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        this.executeTests(cmds);
    }

    public void testAddAgents() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        this.executeTests(cmds);
    }

    public void testCreateSpace() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildSpace(cmds);
        this.executeTests(cmds);
    }

    public void testCreateSpaceAgentsFirst() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        ModelConstructionCommandTest.buildSpace(cmds);
        this.executeTests(cmds);
    }

    public void testRemoveAgents() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        cmds.add(new CommandTransformer(){

            public Command getCommand() {
                return RemoveCommand.create((EditingDomain)this.getDomain(), (Object)this.model, (Object)MetaABMPackage.Literals.SCONTEXT__AGENTS, (Object)this.model.getAgents().get(0));
            }

            public void doPreCondition() {
                super.doPreCondition();
                ModelConstructionCommandTest.assertEquals((int)this.model.getAgents().size(), (int)2);
                ModelConstructionCommandTest.assertNotNull((Object)this.model.findAgent("rootContextAgent"));
                ModelConstructionCommandTest.assertNotNull((Object)this.model.findAgent("rootContextContext"));
                ModelConstructionCommandTest.assertEquals((int)((AGroup)this.model.getRootActivity()).getMembers().size(), (int)3);
                ModelConstructionCommandTest.assertEquals((int)this.model.getAttributes().size(), (int)2);
                SAttribute agentCreatorAttr = (SAttribute)this.model.getAttributes().get(0);
                ModelConstructionCommandTest.assertEquals((int)agentCreatorAttr.getAccessors().size(), (int)1);
            }

            public void doPostCondition() {
                super.doPostCondition();
                ModelConstructionCommandTest.assertEquals((int)this.model.getAgents().size(), (int)1);
                ModelConstructionCommandTest.assertNull((Object)this.model.findAgent("rootContextAgent"));
                ModelConstructionCommandTest.assertNotNull((Object)this.model.findAgent("rootContextContext"));
                ModelConstructionCommandTest.assertEquals((int)((AGroup)this.model.getRootActivity()).getMembers().size(), (int)2);
                ModelConstructionCommandTest.assertEquals((int)this.model.getAttributes().size(), (int)1);
            }
        });
        this.executeTests(cmds);
    }
}

