/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.io.Serializable;

public class Geometry
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean periodic;
    private boolean fixedSize;
    private boolean discrete;
    private int dimensionCount;
    public static final int MOORE = -1;
    public static final int VON_NEUMANN = -2;
    public static final int EUCLIDIAN = -2;
    public static final int NOT_APPLICABLE = -3;
    private int neighborhood = -3;

    public Geometry(int dimensionCount, boolean periodic, boolean fixedSize, boolean discrete, int neighborhood) {
        this.dimensionCount = dimensionCount;
        this.periodic = periodic;
        this.fixedSize = fixedSize;
        this.discrete = discrete;
        this.neighborhood = neighborhood;
    }

    public Geometry(int dimensionCount, boolean periodic, int neighborhood) {
        this(dimensionCount, periodic, true, true, neighborhood);
    }

    public Geometry(int dimensionCount, boolean periodic) {
        this(dimensionCount, periodic, true, true, -3);
    }

    public Geometry(int dimensionCount) {
        this(dimensionCount, true, true, true, -3);
    }

    public Geometry() {
        this(0, true, true, true, -3);
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public void setDimensionCount(int dimensionCount) {
        this.dimensionCount = dimensionCount;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public void setPeriodic(boolean periodic) {
        this.periodic = periodic;
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public void setDiscrete(boolean discrete) {
        this.discrete = discrete;
    }

    public int getNeighborhood() {
        return this.neighborhood;
    }

    public void setNeighborhood(int symbol) {
        this.neighborhood = symbol;
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    public void setFixedSize(boolean fixedSize) {
        this.fixedSize = fixedSize;
    }

    public String toString() {
        String desc = "";
        desc = this.periodic ? String.valueOf(desc) + "A periodic" : String.valueOf(desc) + "An aperiodic";
        if (this.discrete) {
            desc = String.valueOf(desc) + ", discrete";
        }
        if (this.fixedSize) {
            desc = String.valueOf(desc) + ", fixed-size";
        }
        desc = String.valueOf(desc) + Integer.toString(this.dimensionCount) + "-dimensional ";
        desc = this.neighborhood == -1 ? String.valueOf(desc) + " structure using the Moore neighborhood." : (this.neighborhood == -2 ? String.valueOf(desc) + " structure using the von Neumnann neighborhood." : String.valueOf(desc) + " structure.");
        return desc;
    }

    public Object clone() {
        try {
            Geometry clone = (Geometry)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

