/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.util.Arrays;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClassifier;
import org.eclipse.draw3d.graphics.optimizer.primitive.GradientRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.ImageRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.LinePrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.OutlineRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.PolygonPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.PolylinePrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.QuadPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.RenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.SolidRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextRenderRule;

public class LwjglPrimitiveClassifier
implements PrimitiveClassifier {
    public PrimitiveClass classify(Primitive i_primitive) {
        Class<?> clazz = i_primitive.getClass();
        RenderRule renderRule = i_primitive.getRenderRule();
        return new LwjglPrimitiveClass(clazz, renderRule);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LwjglPrimitiveClass
    implements PrimitiveClass {
        private Class<? extends Primitive> m_primitiveType;
        private RenderRule m_renderRule;

        public LwjglPrimitiveClass(Class<? extends Primitive> i_primitiveType, RenderRule i_renderRule) {
            this.m_primitiveType = i_primitiveType;
            this.m_renderRule = i_renderRule;
        }

        public boolean contains(Primitive i_primitive) {
            if (!this.m_primitiveType.isAssignableFrom(i_primitive.getClass())) {
                return false;
            }
            return this.equals(this.m_renderRule, i_primitive.getRenderRule());
        }

        private boolean equals(RenderRule i_rule1, RenderRule i_rule2) {
            if (i_rule1 instanceof OutlineRenderRule) {
                if (!(i_rule2 instanceof OutlineRenderRule)) {
                    return false;
                }
                OutlineRenderRule outline1 = (OutlineRenderRule)i_rule1;
                OutlineRenderRule outline2 = (OutlineRenderRule)i_rule2;
                if (outline1.getAlpha() != outline2.getAlpha()) {
                    return false;
                }
                if (!outline1.getColor().equals((Object)outline2.getColor())) {
                    return false;
                }
                if (!Arrays.equals(outline1.getLineDash(), outline1.getLineDash())) {
                    return false;
                }
                if (outline1.getLineStyle() != outline2.getLineStyle()) {
                    return false;
                }
                if (outline1.getLineWidth() != outline2.getLineWidth()) {
                    return false;
                }
            } else if (i_rule1 instanceof SolidRenderRule) {
                if (!(i_rule2 instanceof SolidRenderRule)) {
                    return false;
                }
                SolidRenderRule solid1 = (SolidRenderRule)i_rule1;
                SolidRenderRule solid2 = (SolidRenderRule)i_rule2;
                if (solid1.getAlpha() != solid2.getAlpha()) {
                    return false;
                }
                if (!solid1.getColor().equals((Object)solid2.getColor())) {
                    return false;
                }
                if (solid1.getFillRule() != solid2.getFillRule()) {
                    return false;
                }
                if (solid1.isXorMode() != solid2.isXorMode()) {
                    return false;
                }
            } else if (i_rule1 instanceof GradientRenderRule) {
                if (!(i_rule2 instanceof GradientRenderRule)) {
                    return false;
                }
                GradientRenderRule gradient1 = (GradientRenderRule)i_rule1;
                GradientRenderRule gradient2 = (GradientRenderRule)i_rule2;
                if (gradient1.getAlpha() != gradient2.getAlpha()) {
                    return false;
                }
                if (gradient1.getFillRule() != gradient2.getFillRule()) {
                    return false;
                }
                if (!gradient1.getFromColor().equals((Object)gradient2.getFromColor())) {
                    return false;
                }
                if (!gradient1.getToColor().equals((Object)gradient2.getToColor())) {
                    return false;
                }
                if (gradient1.isXorMode() != gradient2.isXorMode()) {
                    return false;
                }
            } else if (i_rule1 instanceof ImageRenderRule) {
                if (!(i_rule2 instanceof ImageRenderRule)) {
                    return false;
                }
                ImageRenderRule image1 = (ImageRenderRule)i_rule1;
                ImageRenderRule image2 = (ImageRenderRule)i_rule2;
                if (image1.getAlpha() != image2.getAlpha()) {
                    return false;
                }
            } else if (i_rule1 instanceof TextRenderRule) {
                if (!(i_rule2 instanceof TextRenderRule)) {
                    return false;
                }
                TextRenderRule text1 = (TextRenderRule)i_rule1;
                TextRenderRule text2 = (TextRenderRule)i_rule2;
                if (text1.getAlpha() != text1.getAlpha()) {
                    return false;
                }
                if (!text1.getFont().equals((Object)text2.getFont())) {
                    return false;
                }
                if (!text1.getTextColor().equals((Object)text2.getTextColor())) {
                    return false;
                }
            }
            return true;
        }

        public RenderRule getRenderRule() {
            return this.m_renderRule;
        }

        public boolean isGradient() {
            return this.m_renderRule.isGradient();
        }

        public boolean isImage() {
            return this.m_renderRule.isImage();
        }

        public boolean isLine() {
            return LinePrimitive.class.isAssignableFrom(this.m_primitiveType);
        }

        public boolean isOutline() {
            return this.m_renderRule.isOutline();
        }

        public boolean isPolygon() {
            return PolygonPrimitive.class.isAssignableFrom(this.m_primitiveType);
        }

        public boolean isPolyline() {
            return PolylinePrimitive.class.isAssignableFrom(this.m_primitiveType);
        }

        public boolean isQuad() {
            return QuadPrimitive.class.isAssignableFrom(this.m_primitiveType);
        }

        public boolean isSolid() {
            return this.m_renderRule.isSolid();
        }

        public boolean isText() {
            return this.m_renderRule.isText();
        }

        public String toString() {
            return "PrimitiveClassImpl [m_primitiveClass=" + this.m_primitiveType + ", m_renderRule=" + this.m_renderRule + "]";
        }
    }
}

