/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.data;

import java.util.ArrayList;
import java.util.List;
import org.ascape.util.data.StatCollectorCSAMM;

public class StatCollectorCSAMMVar
extends StatCollectorCSAMM {
    private static final long serialVersionUID = 1L;
    private List<Double> data;

    public StatCollectorCSAMMVar() {
    }

    public StatCollectorCSAMMVar(String name, boolean autoCollect) {
        this.name = name;
        this.autoCollect = autoCollect;
    }

    public StatCollectorCSAMMVar(String name) {
        this(name, true);
    }

    @Override
    public void clear() {
        super.clear();
        this.data = new ArrayList<Double>();
    }

    @Override
    public void addValue(double value) {
        super.addValue(value);
        this.data.add(new Double(value));
    }

    public double getVar() {
        double avg = this.getAvg();
        double variance = 0.0;
        for (Double value : this.data) {
            double deviation = avg - value;
            variance += deviation * deviation;
        }
        return variance /= (double)this.getCount() - 1.0;
    }

    public double getStDev() {
        return Math.sqrt(this.getVar());
    }
}

