/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ascape.model.HostCell;
import org.ascape.model.space.BFSWithinIterator;
import org.ascape.model.space.CollectionSpace;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.util.Conditional;
import org.ascape.util.Conditionals;

public abstract class Discrete
extends CollectionSpace {
    private static final long serialVersionUID = 1L;
    public static boolean performanceWarning = true;

    public Discrete() {
    }

    public Discrete(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    public List calculateNeighbors(Node cell) {
        return this.findWithin(cell.getCoordinate(), null, false, 1.0);
    }

    @Override
    public int getSize() {
        return ((CoordinateDiscrete)this.extent).getProduct();
    }

    public List findOccupants() {
        return Discrete.findOccupants(this);
    }

    public Location findRandomNeighbor(Node location) {
        List neighbors = this.findNeighbors(location);
        if (neighbors.size() > 0) {
            return (Location)neighbors.get(this.randomToLimit(neighbors.size()));
        }
        return null;
    }

    public Location findRandomNeighbor(Node location, Conditional condition) {
        List neighbors = this.findNeighbors(location);
        if ((neighbors = Discrete.filter(neighbors, condition)).size() > 0) {
            return (Location)neighbors.get(this.randomToLimit(neighbors.size()));
        }
        return null;
    }

    public List findNeighbors(Node location) {
        return location.findNeighbors();
    }

    public Location findRandomAvailableNeighbor(Node location) {
        return location.findRandomAvailableNeighbor();
    }

    public Location findRandomAvailable(Node origin, Conditional condition, boolean includeSelf, double distance) {
        List available = this.findWithin(origin.getCoordinate(), Conditionals.and(condition, HostCell.IS_AVAILABLE), includeSelf, distance);
        if (available.size() > 0) {
            return (Location)available.get(this.randomToLimit(available.size()));
        }
        return null;
    }

    public static List findOccupants(Collection candidates) {
        ArrayList<Node> occupants = new ArrayList<Node>();
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            Node occupant = ((Node)iterator.next()).getOccupant();
            if (occupant == null) continue;
            occupants.add(occupant);
        }
        return occupants;
    }

    public List findAvailable() {
        return this.findAvailable(this);
    }

    public List findAvailable(Collection candidates) {
        ArrayList<Node> available = new ArrayList<Node>();
        for (Node candidate : candidates) {
            if (!candidate.isAvailable()) continue;
            available.add(candidate);
        }
        return available;
    }

    public Node[] getCells() {
        this.deleteSweep();
        Node[] agents = new Node[this.collection.size()];
        agents = this.collection.toArray(agents);
        return agents;
    }

    public Node findRandomUnoccupiedCell() {
        return this.findRandomAvailable();
    }

    public Node findRandomAvailable() {
        int i = 0;
        while (i < 10) {
            Node cell = (Node)this.findRandom();
            if (cell.isAvailable()) {
                return cell;
            }
            ++i;
        }
        List available = this.findAvailable();
        if (available.size() > 0) {
            return (Node)available.get(this.randomToLimit(available.size()));
        }
        return null;
    }

    public Node findRandomAvailable(Conditional condition) {
        return (Node)this.findRandom(Conditionals.and(condition, HostCell.IS_AVAILABLE));
    }

    public Location findNearestAvailable(Location origin, Conditional condition, boolean includeOrigin, double distance) {
        return this.findNearest(origin, Conditionals.and(condition, HostCell.IS_AVAILABLE), includeOrigin, distance);
    }

    public Node findRandomUnoccupiedCell(Node excludeCell) {
        Node randomCell;
        while (excludeCell == (randomCell = this.findRandomUnoccupiedCell())) {
        }
        return randomCell;
    }

    public final Node[] getCellsNearDefault(Node origin, boolean includeSelf, int distance) {
        List list = this.findWithinDefault(origin.getCoordinate(), includeSelf, distance);
        Node[] cells = new Node[list.size()];
        return list.toArray(cells);
    }

    public List findWithinDefault(Coordinate origin, boolean includeSelf, double dist) {
        int distance = (int)dist;
        Node[] candidates = this.getCells();
        int foundIndex = 0;
        Node[] foundCells = new Node[candidates.length];
        if (includeSelf) {
            int i = 0;
            while (i < candidates.length) {
                if (this.calculateDistance(origin, candidates[i].getCoordinate()) <= (double)distance) {
                    foundCells[foundIndex] = candidates[i];
                    ++foundIndex;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < candidates.length) {
                int targetDistance = (int)this.calculateDistance(origin, candidates[i].getCoordinate());
                if (targetDistance <= distance && targetDistance != 0) {
                    foundCells[foundIndex] = candidates[i];
                    ++foundIndex;
                }
                ++i;
            }
        }
        Node[] returnCells = new Node[foundIndex];
        System.arraycopy(foundCells, 0, returnCells, 0, returnCells.length);
        ArrayList<Node> found = new ArrayList<Node>();
        int i = 0;
        while (i < returnCells.length) {
            found.add(returnCells[i]);
            ++i;
        }
        return found;
    }

    public abstract Node findCellToward(Node var1, Node var2);

    public abstract Node findCellAway(Node var1, Node var2);

    public int getMaximumRank() {
        return Integer.MAX_VALUE;
    }

    public int getDistance(Node origin, Node target) {
        return (int)this.calculateDistance(origin.getCoordinate(), target.getCoordinate());
    }

    public Location findNearestBFS(Coordinate origin, Conditional condition, boolean includeOrigin, double distance) {
        BFSWithinIterator within = (BFSWithinIterator)this.withinIterator(origin, condition, includeOrigin, distance);
        Location result = (Location)within.next();
        int searchDistance = within.getDepth();
        ArrayList<Location> candidates = null;
        while (within.hasNext() && searchDistance == within.getDepth()) {
            Location nextResult = (Location)within.next();
            if (candidates == null) {
                candidates = new ArrayList<Location>();
                candidates.add(result);
            }
            candidates.add(nextResult);
        }
        if (candidates != null) {
            result = (Location)candidates.get(this.randomToLimit(candidates.size()));
        }
        return result;
    }

    protected Iterator bfsWithinIterator(Location origin, Conditional condition, boolean includeSelf, double distance) {
        return new BFSWithinIterator(this, origin, condition, includeSelf, distance);
    }

    @Override
    public double calculateDistance(Coordinate origin, Coordinate target) {
        BFSWithinIterator within = (BFSWithinIterator)this.withinIterator(origin, new FindCoordinateCondition(target), true, Double.MAX_VALUE);
        if (within.hasNext()) {
            return within.getDepth();
        }
        return Double.NaN;
    }

    protected Node findCellTowardBFS(Node origin, Node target) {
        ArrayList<Node> closest = new ArrayList<Node>();
        double min = Double.MAX_VALUE;
        for (Node originNeighbor : origin.findNeighbors()) {
            double distance = this.calculateDistance(originNeighbor.getCoordinate(), target.getCoordinate());
            if (distance < min) {
                min = distance;
                closest = new ArrayList();
                closest.add(originNeighbor);
                continue;
            }
            if (distance != min) continue;
            closest.add(originNeighbor);
        }
        if (closest.size() > 0) {
            return (Node)closest.get(this.randomToLimit(closest.size()));
        }
        return origin;
    }

    protected Node findCellAwayBFS(Node origin, Node target) {
        double distance = 0.0;
        LinkedList<Node> furthest = new LinkedList<Node>();
        for (Node currentNeighbor : origin.findNeighbors()) {
            double currentDistance = (int)this.calculateDistance(currentNeighbor, target);
            if (currentDistance > distance) {
                distance = currentDistance;
                furthest.clear();
            }
            if (currentDistance != distance) continue;
            furthest.add(currentNeighbor);
        }
        if (furthest.size() > 0) {
            return (Node)furthest.get(this.randomToLimit(furthest.size()));
        }
        return origin;
    }

    public static int calculateDistance(int o, int t, int bound) {
        if (o > t) {
            if (o - t < t + bound - o) {
                return o - t;
            }
            return t + bound - o;
        }
        if (t - o < o + bound - t) {
            return t - o;
        }
        return o + bound - t;
    }

    class FindCoordinateCondition
    implements Conditional {
        private static final long serialVersionUID = 1L;
        Coordinate agent;

        public FindCoordinateCondition(Coordinate agent) {
            this.agent = agent;
        }

        @Override
        public boolean meetsCondition(Object object) {
            return ((Location)object).getCoordinate().equals(this.agent);
        }
    }

    class InCollectionConditional
    implements Conditional {
        private static final long serialVersionUID = 1L;
        Collection collection;

        public InCollectionConditional(Collection collection) {
            this.collection = collection;
        }

        @Override
        public boolean meetsCondition(Object object) {
            return this.collection.contains(object);
        }
    }

    class InList
    implements Conditional {
        private static final long serialVersionUID = 1L;
        List list;

        public InList(List list) {
            this.list = list;
        }

        @Override
        public boolean meetsCondition(Object object) {
            return this.list.contains(object);
        }
    }
}

