/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.io.IOException;
import java.net.URL;
import org.ascape.model.Scape;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.ide.view.ActiveModelViewPart;
import org.eclipse.amp.escape.ascape.wrap.ScapeWrapperModel;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;

public class InfoView
extends ActiveModelViewPart {
    private Browser browser;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        super.createPartControl(parent);
    }

    protected void modelChanged(IModel model) {
        if (model instanceof ScapeWrapperModel) {
            Scape scape = ((ScapeWrapperModel)model).getScape();
            String aboutFileName = "About" + scape.getClass().getSimpleName() + ".html";
            final URL aboutURL = scape.getClass().getResource(aboutFileName);
            this.browser.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (aboutURL != null) {
                        try {
                            URL url = FileLocator.resolve((URL)aboutURL);
                            InfoView.this.browser.setUrl(url.toString());
                            InfoView.this.browser.setBackground(InfoView.this.browser.getDisplay().getSystemColor(1));
                        }
                        catch (IOException e) {
                            InfoView.this.browser.setText("<b>[Bad URL:" + e + "]");
                            InfoView.this.browser.setBackground(InfoView.this.browser.getDisplay().getSystemColor(15));
                        }
                    } else {
                        InfoView.this.browser.setBackground(InfoView.this.browser.getDisplay().getSystemColor(15));
                        InfoView.this.browser.setText("<b>[Empty]");
                    }
                }
            });
        }
    }

    public void dispose() {
        this.browser.dispose();
        super.dispose();
    }
}

