/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.handles;

import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.LocatorHelper;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.gef.handles.MoveHandleLocator;

public class MoveHandleLocator3D
extends MoveHandleLocator {
    protected LocatorHelper m_helper;
    private static final Logger log = Logger.getLogger(MoveHandleLocator3D.class.getName());

    public MoveHandleLocator3D(IFigure i_ref) {
        super(i_ref);
        this.m_helper = new LocatorHelper(i_ref);
    }

    public void relocate(IFigure i_target) {
        IFigure ref = this.getReference();
        if (!(ref instanceof IFigure3D) && !(i_target instanceof IFigure3D)) {
            super.relocate(i_target);
        } else if (i_target instanceof IFigure3D) {
            Position3D targetPosition = Draw3DCache.getPosition3D();
            try {
                IFigure3D target3D = (IFigure3D)i_target;
                Position3D refPosition = this.m_helper.getReferencePosition3D();
                target3D.getPosition3D().setPosition((IPosition3D)refPosition);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{targetPosition});
                throw throwable;
            }
            Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{targetPosition});
        } else {
            log.warning("Cannot position 2D Figure based on 3D reference, reference: " + ref + ", target: " + i_target);
        }
    }
}

