/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.SWTBotTests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractDotnetTest {
    protected static SWTWorkbenchBot bot;
    protected IProject project;
    protected IFile csharpSourceFile;
    protected IFile csprojFile;
    protected static final String dotnetVersion;

    static {
        dotnetVersion = AbstractDotnetTest.getDotNetVersion();
    }

    @BeforeClass
    public static void beforeClass() {
        bot = new SWTWorkbenchBot();
        try {
            bot.viewByTitle("Welcome").close();
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            // empty catch block
        }
        bot.perspectiveByLabel("Debug").activate();
    }

    @Before
    public void setup() throws CoreException {
        this.buildDotnetProject();
    }

    @After
    public void tearDown() throws CoreException {
        if (this.project.exists()) {
            this.project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void buildEmptyProject() {
        try {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
            this.project.create((IProgressMonitor)new NullProgressMonitor());
            this.project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Assert.fail((String)("Unable to build empty project: " + (Object)((Object)e)));
        }
    }

    public void buildDotnetProject() {
        this.buildEmptyProject();
        try {
            this.csharpSourceFile = this.project.getFile("Project.cs");
            this.csharpSourceFile.create(this.getClass().getResourceAsStream("../" + this.csharpSourceFile.getName()), true, (IProgressMonitor)new NullProgressMonitor());
            String projectFileName = dotnetVersion.matches("2\\..*") ? "project2.0.csproj" : (dotnetVersion.matches("1\\.0\\.1.*") ? "project1.0.csproj" : "project.json");
            this.csprojFile = this.project.getFile(projectFileName);
            this.csprojFile.create(this.getClass().getResourceAsStream("../" + this.csprojFile.getName()), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Assert.fail((String)("Unable to build dotnet project file: " + (Object)((Object)e)));
        }
    }

    private static String getDotNetVersion() {
        BufferedReader in;
        block13: {
            String string;
            block14: {
                String listCommand = "dotnet --version";
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(listCommand);
                Throwable throwable = null;
                Object var4_6 = null;
                in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    String version = in.readLine();
                    if (version.isEmpty() || !version.matches("^\\d\\.\\d\\.\\d.*")) break block13;
                    string = version;
                    if (in == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e1) {
                        return "";
                    }
                }
                in.close();
            }
            return string;
        }
        if (in != null) {
            in.close();
        }
        return "";
    }
}

