/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.doc.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Other;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.emf.ecore.EClass;

public final class AQLHelpContentUtils {
    public static final Function<Method, StringBuffer> METHOD_SIGNATURE_GENERATOR_2016 = new MethodSignatureGenerator2016();
    public static final String LS = System.getProperty("line.separator");

    private AQLHelpContentUtils() {
    }

    public static List<StringBuffer> computeServiceSections(Class<?> serviceProviderClass, Function<Method, StringBuffer> signatureGenerator) {
        ArrayList<StringBuffer> buffers = new ArrayList<StringBuffer>();
        ServiceProvider serviceProvider = serviceProviderClass.getAnnotation(ServiceProvider.class);
        if (serviceProvider == null) {
            return buffers;
        }
        StringBuffer servicesSection = new StringBuffer();
        servicesSection.append("=== ").append(serviceProvider.value()).append(LS).append(LS);
        Method[] methods = serviceProviderClass.getMethods();
        Method[] sortedMethods = Arrays.copyOf(methods, methods.length);
        Comparator<Method> comparator = new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return AQLHelpContentUtils.getSortSignature(o1).compareTo(AQLHelpContentUtils.getSortSignature(o2));
            }
        };
        Arrays.sort(sortedMethods, 0, sortedMethods.length, comparator);
        Method[] methodArray = sortedMethods;
        int n = sortedMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Documentation.class)) {
                Documentation serviceDocumentation = method.getAnnotation(Documentation.class);
                servicesSection.append(LS);
                servicesSection.append("==== ").append(signatureGenerator.apply(method)).append(LS).append(LS);
                servicesSection.append(serviceDocumentation.value()).append(LS).append(LS);
                servicesSection.append("Parameters:").append(LS).append(LS);
                if (serviceDocumentation.params().length > 0) {
                    Param[] paramArray = serviceDocumentation.params();
                    int n3 = paramArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Param param = paramArray[n4];
                        servicesSection.append("* *").append(param.name()).append("*: ").append(param.value()).append(LS);
                        ++n4;
                    }
                    servicesSection.append(LS);
                }
                if (serviceDocumentation.examples().length > 0) {
                    Example[] examples;
                    servicesSection.append("|===").append(LS);
                    servicesSection.append("| *Expression* | *Result*").append(LS);
                    ArrayList<Other> others = new ArrayList<Other>();
                    Example[] exampleArray = examples = serviceDocumentation.examples();
                    int n5 = examples.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Other[] otherExamples;
                        Example example = exampleArray[n6];
                        servicesSection.append("| `").append(example.expression().replace("|", "\\|")).append("` | `").append(example.result().replace("|", "\\|")).append("`").append(LS);
                        Other[] otherArray = otherExamples = example.others();
                        int n7 = otherExamples.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            Other otherExample = otherArray[n8];
                            others.add(otherExample);
                            ++n8;
                        }
                        ++n6;
                    }
                    servicesSection.append("|===").append(LS).append(LS);
                    if (others.size() > 0) {
                        servicesSection.append("*In other languages*").append(LS).append(LS);
                        servicesSection.append("|===").append(LS);
                        servicesSection.append("| *Language* | *Expression* | *Result* |").append(LS);
                        for (Other alternate : others) {
                            servicesSection.append("| `").append(alternate.language().replace("|", "\\|")).append("` | `").append(alternate.expression().replace("|", "\\|")).append("` | `").append(alternate.result().replace("|", "\\|")).append("`").append(LS);
                        }
                        servicesSection.append("|===").append(LS).append(LS);
                    }
                }
            }
            ++n2;
        }
        buffers.add(servicesSection);
        return buffers;
    }

    private static String getSortSignature(Method method) {
        StringBuilder res = new StringBuilder();
        res.append(method.getName());
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            res.append(parameter.getName() + parameter.getType().getSimpleName());
            ++n2;
        }
        return res.toString();
    }

    private static boolean isCollection(Class<?> argType) {
        String typeName = argType.getCanonicalName();
        boolean res = "java.util.Set".equals(typeName) ? true : "java.util.List".equals(typeName) || "java.util.Collection".equals(typeName);
        return res;
    }

    public static String prettySimpleName(Class<?> argType) {
        String typeName = argType.getCanonicalName();
        if ("org.eclipse.acceleo.query.runtime.impl.LambdaValue".equals(typeName)) {
            typeName = " x | ... ";
        }
        if (typeName.startsWith("java.lang") || typeName.startsWith("java.util")) {
            typeName = argType.getSimpleName();
        }
        if (typeName.startsWith("org.eclipse.emf")) {
            typeName = argType.getSimpleName();
        }
        if ("List".equals(typeName)) {
            typeName = "Sequence";
        }
        if ("Set".equals(typeName)) {
            typeName = "OrderedSet";
        }
        return typeName;
    }

    public static String getPrettyGenericTypename(Type type, Class<?> argType) {
        Object typename = AQLHelpContentUtils.prettySimpleName(argType);
        if (type instanceof Class) {
            typename = AQLHelpContentUtils.prettySimpleName((Class)type);
        } else if (type instanceof ParameterizedType) {
            String canonical = argType.getCanonicalName();
            Type t = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (t instanceof Class) {
                typename = "java.util.Set".equals(canonical) ? "OrderedSet{" + AQLHelpContentUtils.prettySimpleName((Class)t) + "}" : ("java.util.List".equals(canonical) || "java.util.Collection".equals(canonical) ? "Sequence{" + AQLHelpContentUtils.prettySimpleName((Class)t) + "}" : "{" + AQLHelpContentUtils.prettySimpleName((Class)t) + "}");
            }
        }
        return typename;
    }

    private static final class MethodSignatureGenerator2016
    implements Function<Method, StringBuffer> {
        private MethodSignatureGenerator2016() {
        }

        @Override
        public StringBuffer apply(Method method) {
            Type returnType;
            LinkedHashMap<String, String> methodnamesToOperator = new LinkedHashMap<String, String>();
            methodnamesToOperator.put("add", " + ");
            methodnamesToOperator.put("sub", " - ");
            methodnamesToOperator.put("equals", " = ");
            methodnamesToOperator.put("differs", " <> ");
            methodnamesToOperator.put("greaterThan", " > ");
            methodnamesToOperator.put("greaterThanEqual", " >= ");
            methodnamesToOperator.put("lessThan", " < ");
            methodnamesToOperator.put("lessThanEqual", " <= ");
            StringBuffer result = new StringBuffer();
            boolean isOperator = false;
            boolean first = true;
            ArrayList<String> parameterNames = new ArrayList<String>();
            Documentation documentation = method.getAnnotation(Documentation.class);
            Param[] params = documentation.params();
            if (params != null) {
                Param[] paramArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Param param = paramArray[n2];
                    parameterNames.add(param.name());
                    ++n2;
                }
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            int i = 0;
            while (i < parameterTypes.length) {
                Class<?> argType = parameterTypes[i];
                Object typeName = "";
                typeName = argType instanceof Class ? AQLHelpContentUtils.getPrettyGenericTypename(genericParameterTypes[i], argType) : (argType instanceof EClass ? "EClass=" + ((EClass)argType).getName() : "Object=" + ((Object)argType).toString());
                if (first) {
                    String methodName = method.getName();
                    if (methodnamesToOperator.get(methodName) != null) {
                        isOperator = true;
                        methodName = (String)methodnamesToOperator.get(methodName);
                    }
                    result.append((String)typeName);
                    if (!isOperator) {
                        if (AQLHelpContentUtils.isCollection(argType)) {
                            result.append("->");
                        } else {
                            result.append(".");
                        }
                    }
                    result.append(methodName);
                    if (!isOperator) {
                        result.append('(');
                    }
                }
                if (!first) {
                    if (i > 1) {
                        result.append(", ");
                    }
                    result.append((String)typeName);
                } else {
                    first = false;
                }
                ++i;
            }
            if (!isOperator) {
                result.append(')');
            }
            if (Void.class.equals((Object)(returnType = method.getGenericReturnType()))) {
                result.append(" : void");
            } else {
                result.append(" : ");
                result.append(AQLHelpContentUtils.getPrettyGenericTypename(returnType, method.getReturnType()));
            }
            return result;
        }
    }
}

