/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentIndexLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupExpandCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupExpandCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupsCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupColumnReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupColumnReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupMultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.GroupMultiColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.performance.command.UpdateColumnGroupCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.config.DefaultColumnGroupHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.group.performance.event.ColumnGroupCollapseEvent;
import org.eclipse.nebula.widgets.nattable.group.performance.painter.ColumnGroupHeaderGridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TransformedLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.reorder.event.ColumnReorderEvent;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnGroupHeaderLayer
extends AbstractLayerTransform {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnGroupHeaderLayer.class);
    private static final String PERSISTENCE_KEY_COLUMN_GROUPS = ".columnGroups";
    private final List<GroupModel> model;
    private final SizeConfig rowHeightConfig = new SizeConfig(20);
    private boolean calculateHeight = false;
    private boolean showAlwaysGroupNames = false;
    private IUniqueIndexLayer positionLayer;
    private GroupModel.IndexPositionConverter indexPositionConverter;
    private List<ILayer> layerPath;
    private int reorderFromColumnPosition;
    private Map<Integer, Boolean> reorderSupportedOnLevel = new HashMap<Integer, Boolean>();
    private CompositeFreezeLayer compositeFreezeLayer;

    public ColumnGroupHeaderLayer(ILayer underlyingHeaderLayer, SelectionLayer selectionLayer) {
        this(underlyingHeaderLayer, selectionLayer, selectionLayer, 1, true);
    }

    public ColumnGroupHeaderLayer(ILayer underlyingHeaderLayer, SelectionLayer selectionLayer, int numberOfGroupLevels) {
        this(underlyingHeaderLayer, selectionLayer, selectionLayer, numberOfGroupLevels, true);
    }

    public ColumnGroupHeaderLayer(ILayer underlyingHeaderLayer, IUniqueIndexLayer positionLayer, SelectionLayer selectionLayer) {
        this(underlyingHeaderLayer, positionLayer, selectionLayer, 1, true);
    }

    public ColumnGroupHeaderLayer(ILayer underlyingHeaderLayer, IUniqueIndexLayer positionLayer, SelectionLayer selectionLayer, int numberOfGroupLevels) {
        this(underlyingHeaderLayer, positionLayer, selectionLayer, numberOfGroupLevels, true);
    }

    public ColumnGroupHeaderLayer(ILayer underlyingHeaderLayer, SelectionLayer selectionLayer, int numberOfGroupLevels, boolean useDefaultConfiguration) {
        this(underlyingHeaderLayer, selectionLayer, selectionLayer, numberOfGroupLevels, useDefaultConfiguration);
    }

    public ColumnGroupHeaderLayer(ILayer underlyingHeaderLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        this(underlyingHeaderLayer, selectionLayer, selectionLayer, 1, useDefaultConfiguration);
    }

    public ColumnGroupHeaderLayer(ILayer underlyingHeaderLayer, IUniqueIndexLayer positionLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        this(underlyingHeaderLayer, positionLayer, selectionLayer, 1, useDefaultConfiguration);
    }

    public ColumnGroupHeaderLayer(ILayer underlyingHeaderLayer, final IUniqueIndexLayer positionLayer, SelectionLayer selectionLayer, int numberOfGroupLevels, boolean useDefaultConfiguration) {
        super(underlyingHeaderLayer);
        this.positionLayer = positionLayer;
        this.indexPositionConverter = new GroupModel.IndexPositionConverter(){

            @Override
            public int convertPositionToIndex(int position) {
                return positionLayer.getColumnIndexByPosition(position);
            }

            @Override
            public int convertIndexToPosition(int index) {
                return positionLayer.getColumnPositionByIndex(index);
            }
        };
        this.model = new ArrayList<GroupModel>(numberOfGroupLevels);
        int i = 0;
        while (i < numberOfGroupLevels) {
            GroupModel groupModel = new GroupModel();
            groupModel.setIndexPositionConverter(this.indexPositionConverter);
            this.model.add(groupModel);
            this.reorderSupportedOnLevel.put(i, Boolean.TRUE);
            ++i;
        }
        this.layerPath = this.findLayerPath(this, 0);
        this.layerPainter = new ColumnGroupHeaderGridLineCellLayerPainter(this);
        positionLayer.addLayerListener(new StructuralChangeLayerListener());
        this.registerCommandHandlers(selectionLayer);
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnGroupHeaderLayerConfiguration(false));
        }
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    @Override
    public void setLayerPainter(ILayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    protected void registerCommandHandlers(SelectionLayer selectionLayer) {
        this.registerCommandHandler(new ColumnGroupsCommandHandler(this, selectionLayer));
        this.registerCommandHandler(new ConfigureScalingCommandHandler(null, this.rowHeightConfig));
        this.registerCommandHandler(new ColumnGroupReorderCommandHandler(this));
        this.registerCommandHandler(new ColumnGroupReorderStartCommandHandler(this));
        this.registerCommandHandler(new ColumnGroupReorderEndCommandHandler(this));
        this.getPositionLayer().registerCommandHandler(new GroupColumnReorderCommandHandler(this));
        this.getPositionLayer().registerCommandHandler(new GroupColumnReorderStartCommandHandler(this));
        this.getPositionLayer().registerCommandHandler(new GroupColumnReorderEndCommandHandler(this));
        this.getPositionLayer().registerCommandHandler(new GroupMultiColumnReorderCommandHandler(this));
    }

    public GroupModel getGroupModel() {
        return this.getGroupModel(0);
    }

    public GroupModel getGroupModel(int level) {
        if (level >= this.model.size()) {
            LOG.warn("tried to add a group on a non-existent level");
            return null;
        }
        return this.model.get(level);
    }

    public void addGroupingLevel() {
        GroupModel groupModel = new GroupModel();
        groupModel.setIndexPositionConverter(this.indexPositionConverter);
        this.model.add(groupModel);
        this.reorderSupportedOnLevel.put(this.model.size() - 1, Boolean.TRUE);
    }

    public int getLevelCount() {
        return this.model.size();
    }

    public IUniqueIndexLayer getPositionLayer() {
        return this.positionLayer;
    }

    List<ILayer> findLayerPath(ILayer layer, int columnPosition) {
        if (layer == this.getPositionLayer()) {
            ArrayList<ILayer> result = new ArrayList<ILayer>();
            result.add(layer);
            return result;
        }
        if (this.compositeFreezeLayer == null && layer instanceof CompositeFreezeLayer) {
            this.compositeFreezeLayer = (CompositeFreezeLayer)layer;
        }
        List<ILayer> result = null;
        Collection<ILayer> underlyingLayers = layer.getUnderlyingLayersByColumnPosition(columnPosition);
        if (underlyingLayers != null) {
            for (ILayer underlyingLayer : underlyingLayers) {
                if (underlyingLayer == null) continue;
                result = this.findLayerPath(underlyingLayer, columnPosition);
            }
        }
        if (result == null && layer instanceof DimensionallyDependentLayer) {
            result = this.findLayerPath(((DimensionallyDependentLayer)layer).getHorizontalLayerDependency(), columnPosition);
        }
        if (result == null && this.underlyingLayer instanceof DimensionallyDependentIndexLayer) {
            result = this.findLayerPath(((DimensionallyDependentIndexLayer)layer).getHorizontalLayerDependency(), columnPosition);
        }
        if (result == null && layer instanceof CompositeFreezeLayer) {
            result = this.findLayerPath(((CompositeFreezeLayer)layer).getChildLayerByLayoutCoordinate(1, 1), columnPosition);
        }
        if (result != null) {
            result.add(layer);
        }
        return result;
    }

    protected int convertColumnPositionUpwards(int columnPosition) {
        int converted = columnPosition;
        List<ILayer> path = this.layerPath;
        if (path == null) {
            path = this.findLayerPath(this, columnPosition);
        }
        if (path != null) {
            int i = 0;
            while (i < path.size() - 1) {
                ILayer underlying = path.get(i);
                ILayer upper = path.get(i + 1);
                converted = upper.underlyingToLocalColumnPosition(underlying, converted);
                ++i;
            }
        }
        return converted;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ColumnGroupExpandCollapseCommand && command.convertToTargetLayer(this.getPositionLayer())) {
            ColumnGroupExpandCollapseCommand cmd = (ColumnGroupExpandCollapseCommand)command;
            int rowPosition = cmd.getLocalRowPosition(this);
            int columnPosition = cmd.getColumnPosition();
            Object[] found = this.findGroupForCoordinates(columnPosition, rowPosition);
            if (found != null) {
                GroupModel groupModel = (GroupModel)found[0];
                GroupModel.Group group = (GroupModel.Group)found[1];
                if (group.isCollapsed()) {
                    this.expandGroup(groupModel, group);
                } else {
                    this.collapseGroup(groupModel, group);
                }
            }
            return true;
        }
        if (command instanceof RowResizeCommand && command.convertToTargetLayer(this) && ((RowResizeCommand)command).getRowPosition() < this.getRowCount() - 1) {
            RowResizeCommand rowResizeCommand = (RowResizeCommand)command;
            int newRowHeight = rowResizeCommand.downScaleValue() ? this.rowHeightConfig.downScale(rowResizeCommand.getNewHeight()) : rowResizeCommand.getNewHeight();
            this.setRowHeight(rowResizeCommand.getRowPosition(), newRowHeight);
            this.fireLayerEvent(new RowResizeEvent((ILayer)this, rowResizeCommand.getRowPosition()));
            return true;
        }
        if (command instanceof MultiRowResizeCommand && command.convertToTargetLayer(this)) {
            MultiRowResizeCommand rowResizeCommand = (MultiRowResizeCommand)command;
            int[] nArray = rowResizeCommand.getRowPositionsArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                int newRowHeight = rowResizeCommand.downScaleValue() ? this.rowHeightConfig.downScale(rowResizeCommand.getRowHeight(row)) : rowResizeCommand.getRowHeight(row);
                this.setRowHeight(row, newRowHeight);
                this.fireLayerEvent(new RowResizeEvent((ILayer)this, row));
                ++n2;
            }
        }
        return super.doCommand(command);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        int level = 0;
        for (GroupModel groupModel : this.model) {
            groupModel.saveState(prefix + ".columnGroups_" + level, properties);
            ++level;
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.expandAllGroups();
        int level = 0;
        for (GroupModel groupModel : this.model) {
            groupModel.loadState(prefix + ".columnGroups_" + level, properties);
            ArrayList<GroupModel.Group> collapsedGroups = new ArrayList<GroupModel.Group>();
            for (GroupModel.Group group : groupModel.getGroups()) {
                if (!group.isCollapsed()) continue;
                collapsedGroups.add(group);
            }
            if (!collapsedGroups.isEmpty()) {
                this.doCommand(new ColumnGroupCollapseCommand(groupModel, collapsedGroups));
            }
            ++level;
        }
        this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
    }

    private int internalGetRowCount() {
        if (!this.calculateHeight) {
            return this.model.size();
        }
        return (int)this.model.stream().filter(gm -> gm.isVisible()).count();
    }

    @Override
    public int getRowCount() {
        return this.underlyingLayer.getRowCount() + this.internalGetRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.underlyingLayer.getPreferredRowCount() + this.internalGetRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        int rowCount = this.internalGetRowCount();
        if (rowPosition < rowCount) {
            return rowPosition;
        }
        return this.underlyingLayer.getRowIndexByPosition(rowPosition - rowCount);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int rowCount = this.internalGetRowCount();
        if (localRowPosition < rowCount) {
            return localRowPosition;
        }
        return localRowPosition - rowCount;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        int rowCount = this.internalGetRowCount();
        return underlyingRowPosition + rowCount;
    }

    private int getGroupingHeight() {
        if (!this.calculateHeight) {
            return this.rowHeightConfig.getAggregateSize(this.model.size());
        }
        int height = 0;
        int i = 0;
        while (i < this.model.size()) {
            GroupModel groupModel = this.model.get(i);
            if (groupModel.isVisible()) {
                height += this.rowHeightConfig.getSize(this.getRowPositionForLevel(i));
            }
            ++i;
        }
        return height;
    }

    @Override
    public int getHeight() {
        return this.getGroupingHeight() + this.underlyingLayer.getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.getGroupingHeight() + this.underlyingLayer.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        int rowCount = this.internalGetRowCount();
        if (rowPosition < rowCount) {
            if (!this.calculateHeight) {
                return this.rowHeightConfig.getSize(rowPosition);
            }
            int level = this.getLevelForRowPosition(rowPosition);
            return !this.getGroupModel(level).isVisible() ? 0 : this.rowHeightConfig.getSize(rowPosition);
        }
        return this.underlyingLayer.getRowHeightByPosition(rowPosition - rowCount);
    }

    public void setRowHeight(int rowHeight) {
        this.setRowHeight(this.getRowPositionForLevel(0), rowHeight);
    }

    public void setRowHeight(int row, int rowHeight) {
        this.rowHeightConfig.setSize(row, rowHeight);
    }

    public int getRowPositionForLevel(int level) {
        return this.model.size() - level - 1;
    }

    public int getLevelForRowPosition(int rowPosition) {
        return this.internalGetRowCount() - rowPosition - 1;
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        int rowCount = this.model.size();
        if (rowPosition < rowCount) {
            return this.rowHeightConfig.isPositionResizable(rowPosition);
        }
        return this.underlyingLayer.isRowPositionResizable(rowPosition - rowCount);
    }

    public void setRowPositionResizable(int rowPosition, boolean resizable) {
        this.rowHeightConfig.setPositionResizable(rowPosition, resizable);
    }

    @Override
    public int getRowPositionByY(int y) {
        int groupHeight = this.getGroupingHeight();
        if (y == 0) {
            return 0;
        }
        if (y <= groupHeight) {
            return LayerUtil.getRowPositionByY(this, y);
        }
        return this.internalGetRowCount() + this.underlyingLayer.getRowPositionByY(y - groupHeight);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        int rowCount = this.internalGetRowCount();
        if (rowPosition < rowCount) {
            if (!this.calculateHeight) {
                return this.rowHeightConfig.getAggregateSize(rowPosition);
            }
            int startY = 0;
            int i = 0;
            while (i < rowPosition) {
                GroupModel groupModel = this.model.get(i);
                if (groupModel.isVisible()) {
                    startY += this.rowHeightConfig.getSize(this.getRowPositionForLevel(i));
                }
                ++i;
            }
            return startY;
        }
        return this.getGroupingHeight() + this.underlyingLayer.getStartYOfRowPosition(rowPosition - this.internalGetRowCount());
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, final int rowPosition) {
        if (rowPosition < this.internalGetRowCount()) {
            int level = this.getLevelForRowPosition(rowPosition);
            GroupModel.Group group = this.getGroupByPosition(level, columnPosition);
            if (group != null) {
                int start = this.compositeFreezeLayer == null ? this.convertColumnPositionUpwards(this.getPositionLayer().getColumnPositionByIndex(group.getVisibleStartIndex())) : this.compositeFreezeLayer.getColumnPositionByIndex(group.getVisibleStartIndex());
                int row = rowPosition;
                int rowSpan = 1;
                while (level < this.internalGetRowCount() - 1) {
                    GroupModel.Group upperGroup;
                    if ((upperGroup = this.getGroupByPosition(++level, columnPosition)) != null) break;
                    --row;
                    ++rowSpan;
                }
                int columnSpan = this.getColumnSpan(group);
                if (this.showAlwaysGroupNames) {
                    if (start < 0) {
                        columnSpan += start;
                        start = 0;
                    }
                    if (start + columnSpan > this.getColumnCount()) {
                        columnSpan = this.getColumnCount() - start;
                    }
                }
                ILayerCell cell = new LayerCell(this, start, row, columnPosition, rowPosition, columnSpan, rowSpan);
                if (this.compositeFreezeLayer != null) {
                    cell = this.compositeFreezeLayer.modifyColumnSpanLayerCell(cell);
                }
                return cell;
            }
            int rowSpan = 2;
            GroupModel.Group subGroup = null;
            while (level > 0) {
                if ((group = this.getGroupByPosition(--level, columnPosition)) == null) {
                    ++rowSpan;
                    continue;
                }
                subGroup = group;
            }
            if (subGroup != null) {
                int start = this.compositeFreezeLayer == null ? this.convertColumnPositionUpwards(this.getPositionLayer().getColumnPositionByIndex(subGroup.getVisibleStartIndex())) : this.compositeFreezeLayer.getColumnPositionByIndex(subGroup.getVisibleStartIndex());
                int columnSpan = this.getColumnSpan(subGroup);
                if (this.showAlwaysGroupNames) {
                    if (start < 0) {
                        columnSpan += start;
                        start = 0;
                    }
                    if (start + columnSpan > this.getColumnCount()) {
                        columnSpan = this.getColumnCount() - start;
                    }
                }
                return new LayerCell(this, start, rowPosition, columnPosition, rowPosition, columnSpan, rowSpan);
            }
            final int span = rowSpan;
            ILayerCell cell = this.underlyingLayer.getCellByPosition(columnPosition, 0);
            if (cell != null) {
                cell = new TransformedLayerCell(cell){

                    @Override
                    public ILayer getLayer() {
                        return ColumnGroupHeaderLayer.this;
                    }

                    @Override
                    public int getRowSpan() {
                        return span;
                    }

                    @Override
                    public int getRowPosition() {
                        return rowPosition;
                    }

                    @Override
                    public int getOriginRowPosition() {
                        return rowPosition;
                    }
                };
            }
            return cell;
        }
        int rowSpan = 1;
        if (rowPosition - 1 < this.internalGetRowCount()) {
            int level = this.getLevelForRowPosition(rowPosition - 1);
            GroupModel.Group group = null;
            while (level < this.internalGetRowCount()) {
                group = this.getGroupByPosition(level, columnPosition);
                if (group != null) break;
                ++rowSpan;
                ++level;
            }
        }
        final int span = rowSpan;
        ILayerCell cell = this.underlyingLayer.getCellByPosition(columnPosition, 0);
        if (cell != null) {
            cell = new TransformedLayerCell(cell){

                @Override
                public ILayer getLayer() {
                    return ColumnGroupHeaderLayer.this;
                }

                @Override
                public int getRowSpan() {
                    return span;
                }

                @Override
                public int getRowPosition() {
                    return rowPosition;
                }

                @Override
                public int getOriginRowPosition() {
                    return rowPosition - (span - 1);
                }
            };
        }
        return cell;
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        Rectangle bounds = super.getBoundsByPosition(columnPosition, rowPosition);
        if (this.compositeFreezeLayer != null && this.compositeFreezeLayer.isFrozen()) {
            ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
            int[] columnBounds = this.compositeFreezeLayer.getColumnBounds(columnPosition, cell.getOriginColumnPosition(), cell.getOriginColumnPosition() + cell.getColumnSpan() - 1);
            bounds.x = columnBounds[0];
            bounds.width = columnBounds[1];
        }
        return bounds;
    }

    public GroupModel.Group getGroupByPosition(int columnPosition) {
        return this.getGroupByPosition(0, columnPosition);
    }

    public GroupModel.Group getGroupByPosition(int level, int columnPosition) {
        GroupModel groupModel;
        int posColumn = LayerUtil.convertColumnPosition(this, columnPosition, this.getPositionLayer());
        if (posColumn > -1 && (groupModel = this.getGroupModel(level)) != null) {
            return groupModel.getGroupByPosition(posColumn);
        }
        return null;
    }

    protected Object[] findGroupForCoordinates(int columnPosition, int rowPosition) {
        int level = this.getLevelForRowPosition(rowPosition);
        GroupModel groupModel = null;
        GroupModel.Group group = null;
        while (level >= 0) {
            groupModel = this.getGroupModel(level);
            if (groupModel != null && (group = groupModel.getGroupByPosition(columnPosition)) != null) {
                return new Object[]{groupModel, group};
            }
            --level;
        }
        return null;
    }

    public boolean isPartOfAGroup(int columnPosition) {
        int level = 0;
        while (level < this.model.size()) {
            if (this.isPartOfAGroup(level, columnPosition)) {
                return true;
            }
            ++level;
        }
        return false;
    }

    public boolean isPartOfAGroup(int level, int columnPosition) {
        GroupModel.Group group = this.getGroupByPosition(level, columnPosition);
        return group != null;
    }

    public boolean isPartOfAnUnbreakableGroup(int columnPosition) {
        return this.isPartOfAnUnbreakableGroup(0, columnPosition);
    }

    public boolean isPartOfAnUnbreakableGroup(int level, int columnPosition) {
        GroupModel.Group group = this.getGroupByPosition(level, columnPosition);
        if (group != null) {
            return group.isUnbreakable();
        }
        return false;
    }

    public int getColumnSpan(GroupModel.Group group) {
        int sizeOfGroup = group.getVisibleSpan();
        if (group.isCollapsed()) {
            int sizeOfStaticColumns = group.getStaticIndexes().length;
            if (sizeOfStaticColumns == 0) {
                return 1;
            }
            int staticSize = 0;
            int[] nArray = group.getStaticIndexes();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                if (this.getPositionLayer().getColumnPositionByIndex(index) >= 0) {
                    ++staticSize;
                }
                ++n2;
            }
            sizeOfGroup = staticSize;
        }
        return sizeOfGroup;
    }

    @Override
    public DisplayMode getDisplayModeByPosition(int columnPosition, int rowPosition) {
        if (rowPosition < this.internalGetRowCount() && this.isPartOfAGroup(this.getLevelForRowPosition(rowPosition), columnPosition)) {
            return DisplayMode.NORMAL;
        }
        int rowPos = rowPosition < this.internalGetRowCount() ? rowPosition : rowPosition - this.internalGetRowCount();
        return this.underlyingLayer.getDisplayModeByPosition(columnPosition, rowPos);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        GroupModel.Group group;
        int posColumn = LayerUtil.convertColumnPosition(this, columnPosition, this.getPositionLayer());
        Object[] found = this.findGroupForCoordinates(posColumn, rowPosition);
        GroupModel.Group group2 = group = found != null ? (GroupModel.Group)found[1] : null;
        if (rowPosition < this.internalGetRowCount() && group != null) {
            LabelStack stack = new LabelStack(new String[0]);
            if (this.getConfigLabelAccumulator() != null) {
                this.getConfigLabelAccumulator().accumulateConfigLabels(stack, columnPosition, rowPosition);
            }
            stack.addLabel("COLUMN_GROUP_HEADER");
            if (group != null && group.isCollapseable()) {
                if (group.isCollapsed()) {
                    stack.addLabelOnTop("GROUP_COLLAPSED");
                } else {
                    stack.addLabelOnTop("GROUP_EXPANDED");
                }
            }
            return stack;
        }
        int rowPos = rowPosition < this.internalGetRowCount() ? rowPosition : rowPosition - this.internalGetRowCount();
        return this.underlyingLayer.getConfigLabelsByPosition(columnPosition, rowPos);
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        if (rowPosition < this.internalGetRowCount()) {
            int level = this.getLevelForRowPosition(rowPosition);
            GroupModel.Group group = this.getGroupByPosition(level, columnPosition);
            while (group == null && level > 0) {
                group = this.getGroupByPosition(--level, columnPosition);
            }
            if (group != null) {
                return group.getName();
            }
        }
        return this.underlyingLayer.getDataValueByPosition(columnPosition, 0);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        if (y < this.getGroupingHeight()) {
            int i = 0;
            while (i < this.internalGetRowCount()) {
                if (this.isPartOfAGroup(i, this.getColumnPositionByX(x))) {
                    return new LabelStack("COLUMN_GROUP_HEADER");
                }
                ++i;
            }
        }
        return this.underlyingLayer.getRegionLabelsByXY(x, y - this.getGroupingHeight());
    }

    public GroupModel.Group getGroupByName(String name) {
        return this.getGroupByName(0, name);
    }

    public GroupModel.Group getGroupByName(int level, String name) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            return groupModel.getGroupByName(name);
        }
        return null;
    }

    public void addPositionsToGroup(String groupName, int ... positions) {
        this.addPositionsToGroup(0, groupName, positions);
    }

    public void addPositionsToGroup(int level, String groupName, int ... positions) {
        GroupModel.Group group;
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && (group = groupModel.getGroupByName(groupName)) != null) {
            this.addPositionsToGroup(group, positions);
        }
    }

    public void addPositionsToGroup(int level, int columnPosition, int ... positions) {
        GroupModel.Group group = this.getGroupByPosition(level, columnPosition);
        if (group != null) {
            this.addPositionsToGroup(group, positions);
        }
    }

    protected void addPositionsToGroup(GroupModel.Group group, int ... positions) {
        this.addPositionsToGroup(0, group, positions);
    }

    protected void addPositionsToGroup(int level, GroupModel.Group group, int ... positions) {
        GroupModel groupModel;
        int[] converted = new int[positions.length];
        int pos = 0;
        while (pos < positions.length) {
            converted[pos] = LayerUtil.convertColumnPosition(this, positions[pos], this.getPositionLayer());
            ++pos;
        }
        if (group.isCollapsed()) {
            this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(this.getGroupModel(level), group));
        }
        if ((groupModel = this.getGroupModel(level)) != null) {
            groupModel.addPositionsToGroup(group, converted);
        }
        this.fireLayerEvent(new RowStructuralRefreshEvent(this.underlyingLayer));
    }

    public void removePositionsFromGroup(int level, int ... positions) {
        int[] converted = new int[positions.length];
        int pos = 0;
        while (pos < positions.length) {
            converted[pos] = LayerUtil.convertColumnPosition(this, positions[pos], this.getPositionLayer());
            ++pos;
        }
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            int i = converted.length - 1;
            while (i >= 0) {
                int pos2 = converted[i];
                GroupModel.Group group = groupModel.getGroupByPosition(pos2);
                if (group.isCollapsed()) {
                    this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(groupModel, group));
                }
                groupModel.removePositionsFromGroup(group, pos2);
                --i;
            }
        }
        if (this.calculateHeight) {
            this.fireLayerEvent(new RowStructuralRefreshEvent(this.underlyingLayer));
        }
    }

    public void addGroup(String groupName, int startIndex, int span) {
        this.addGroup(0, groupName, startIndex, span);
    }

    public void addGroup(int level, String groupName, int startIndex, int span) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.addGroup(groupName, startIndex, span);
        }
    }

    public void removeGroup(String groupName) {
        this.removeGroup(0, groupName);
    }

    public void removeGroup(int level, String groupName) {
        GroupModel.Group group;
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && (group = groupModel.removeGroup(groupName)) != null && group.isCollapsed()) {
            this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(this.getGroupModel(level), group));
        }
    }

    public void removeGroup(int columnPosition) {
        this.removeGroup(0, columnPosition);
    }

    public void removeGroup(int level, int columnPosition) {
        GroupModel.Group group;
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && (group = groupModel.removeGroup(columnPosition)) != null && group.isCollapsed()) {
            this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(this.getGroupModel(level), group));
        }
    }

    public void removeGroup(GroupModel.Group group) {
        this.removeGroup(0, group);
    }

    public void removeGroup(int level, GroupModel.Group group) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.removeGroup(group);
            if (group != null && group.isCollapsed()) {
                this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(this.getGroupModel(level), group));
            }
        }
    }

    public void clearAllGroups() {
        for (GroupModel groupModel : this.model) {
            if (!groupModel.isEmpty()) {
                this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(groupModel, groupModel.getGroups()));
            }
            groupModel.clear();
        }
    }

    public void clearAllGroups(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && !groupModel.isEmpty()) {
            this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(groupModel, groupModel.getGroups()));
            groupModel.clear();
        }
    }

    public void addStaticColumnIndexesToGroup(String groupName, int ... staticIndexes) {
        this.addStaticColumnIndexesToGroup(0, groupName, staticIndexes);
    }

    public void addStaticColumnIndexesToGroup(int level, String groupName, int ... staticIndexes) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.addStaticIndexesToGroup(groupName, staticIndexes);
        }
    }

    public void addStaticColumnIndexesToGroup(int level, int columnPosition, int ... staticIndexes) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.addStaticIndexesToGroup(columnPosition, staticIndexes);
        }
    }

    public void collapseGroup(String groupName) {
        this.collapseGroup(0, groupName);
    }

    public void collapseGroup(int level, String groupName) {
        this.collapseGroup(this.getGroupModel(level), this.getGroupByName(groupName));
    }

    public void collapseGroup(int position) {
        this.collapseGroup(0, position);
    }

    public void collapseGroup(int level, int position) {
        this.collapseGroup(this.getGroupModel(level), this.getGroupByPosition(level, position));
    }

    public void collapseGroup(GroupModel groupModel, GroupModel.Group group) {
        if (groupModel != null && group != null) {
            this.getPositionLayer().doCommand(new ColumnGroupCollapseCommand(groupModel, group));
        }
    }

    public void collapseAllGroups() {
        for (GroupModel groupModel : this.model) {
            if (groupModel.isEmpty()) continue;
            this.getPositionLayer().doCommand(new ColumnGroupCollapseCommand(groupModel, groupModel.getGroups()));
        }
    }

    public void collapseAllGroups(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && !groupModel.isEmpty()) {
            this.getPositionLayer().doCommand(new ColumnGroupCollapseCommand(groupModel, groupModel.getGroups()));
        }
    }

    public void expandGroup(String groupName) {
        this.expandGroup(0, groupName);
    }

    public void expandGroup(int level, String groupName) {
        this.expandGroup(this.getGroupModel(level), this.getGroupByName(groupName));
    }

    public void expandGroup(int position) {
        this.expandGroup(0, position);
    }

    public void expandGroup(int level, int position) {
        this.expandGroup(this.getGroupModel(level), this.getGroupByPosition(level, position));
    }

    public void expandGroup(GroupModel groupModel, GroupModel.Group group) {
        if (groupModel != null && group != null) {
            this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(groupModel, group));
        }
    }

    public void expandAllGroups() {
        for (GroupModel groupModel : this.model) {
            if (groupModel.isEmpty()) continue;
            this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(groupModel, groupModel.getGroups()));
        }
    }

    public void expandAllGroups(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && !groupModel.isEmpty()) {
            this.getPositionLayer().doCommand(new ColumnGroupExpandCommand(groupModel, groupModel.getGroups()));
        }
    }

    public void setDefaultCollapseable(boolean defaultCollapseable) {
        for (GroupModel groupModel : this.model) {
            groupModel.setDefaultCollapseable(defaultCollapseable);
        }
    }

    public boolean isDefaultCollapseable(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            return groupModel.isDefaultCollapseable();
        }
        return false;
    }

    public void setDefaultCollapseable(int level, boolean defaultCollapseable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setDefaultCollapseable(defaultCollapseable);
        }
    }

    public void setGroupCollapseable(String groupName, boolean collabseable) {
        this.setGroupCollapseable(0, groupName, collabseable);
    }

    public void setGroupCollapseable(int level, String groupName, boolean collabseable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setGroupCollapseable(groupName, collabseable);
        }
    }

    public void setGroupCollapseable(int position, boolean collabseable) {
        this.setGroupCollapseable(0, position, collabseable);
    }

    public void setGroupCollapseable(int level, int position, boolean collabseable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setGroupCollapseable(position, collabseable);
        }
    }

    public void setDefaultUnbreakable(boolean defaultUnbreakable) {
        for (GroupModel groupModel : this.model) {
            groupModel.setDefaultUnbreakable(defaultUnbreakable);
        }
    }

    public boolean isDefaultUnbreakable(int level) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            return groupModel.isDefaultUnbreakable();
        }
        return false;
    }

    public void setDefaultUnbreakable(int level, boolean defaultUnbreakable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setDefaultUnbreakable(defaultUnbreakable);
        }
    }

    public void setGroupUnbreakable(String groupName, boolean unbreakable) {
        this.setGroupUnbreakable(0, groupName, unbreakable);
    }

    public void setGroupUnbreakable(int level, String groupName, boolean unbreakable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setGroupUnbreakable(groupName, unbreakable);
        }
    }

    public void setGroupUnbreakable(int position, boolean unbreakable) {
        this.setGroupUnbreakable(0, position, unbreakable);
    }

    public void setGroupUnbreakable(int level, int position, boolean unbreakable) {
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null) {
            groupModel.setGroupUnbreakable(position, unbreakable);
        }
    }

    public boolean isCalculateHeight() {
        return this.calculateHeight;
    }

    public void setCalculateHeight(boolean calculateHeight) {
        boolean changed = calculateHeight ^ this.calculateHeight;
        this.calculateHeight = calculateHeight;
        if (changed) {
            this.fireLayerEvent(new RowStructuralRefreshEvent(this));
        }
    }

    public boolean isShowAlwaysGroupNames() {
        return this.showAlwaysGroupNames;
    }

    public void setShowAlwaysGroupNames(boolean showAlwaysGroupNames) {
        this.showAlwaysGroupNames = showAlwaysGroupNames;
    }

    public int getReorderFromColumnPosition() {
        return this.reorderFromColumnPosition;
    }

    public void setReorderFromColumnPosition(int fromColumnPosition) {
        this.reorderFromColumnPosition = fromColumnPosition;
    }

    public boolean isReorderSupportedOnLevel(int level) {
        Boolean supported = this.reorderSupportedOnLevel.get(level);
        if (supported != null) {
            return supported;
        }
        return true;
    }

    public void setReorderSupportedOnLevel(int level, boolean supported) {
        if (level < this.model.size()) {
            this.reorderSupportedOnLevel.put(level, supported);
        }
    }

    public boolean reorderColumnGroup(int level, int fromColumnPosition, int toColumnPosition) {
        GroupModel.Group group;
        if (!this.isReorderSupportedOnLevel(level) || !ColumnGroupUtils.isBetweenTwoGroups(this, level, toColumnPosition, toColumnPosition < this.getPositionLayer().getColumnCount(), PositionUtil.getHorizontalMoveDirection(fromColumnPosition, toColumnPosition))) {
            return true;
        }
        if (level < this.getLevelCount() - 1 && !ColumnGroupUtils.isReorderValid(this, level + 1, fromColumnPosition, toColumnPosition, toColumnPosition < this.getPositionLayer().getColumnCount())) {
            return true;
        }
        GroupModel groupModel = this.getGroupModel(level);
        if (groupModel != null && (group = groupModel.getGroupByPosition(fromColumnPosition)) != null) {
            if (group.isCollapsed()) {
                int groupStart = group.getVisibleStartPosition();
                int groupEnd = group.getVisibleStartPosition() + group.getVisibleSpan();
                if (fromColumnPosition >= groupStart && fromColumnPosition <= groupEnd && toColumnPosition == groupStart || toColumnPosition == groupEnd) {
                    return true;
                }
            }
            int toPosition = toColumnPosition;
            int underlyingTo = this.getPositionLayer().localToUnderlyingColumnPosition(toPosition);
            GroupMultiColumnReorderCommand command = new GroupMultiColumnReorderCommand((ILayer)this.getPositionLayer(), group.getMembers(), underlyingTo);
            GroupModel.Group toRight = groupModel.getGroupByPosition(toPosition);
            if (toRight != null) {
                command.setGroupToRight(toRight);
            } else {
                GroupModel.Group toLeft = groupModel.getGroupByPosition(toPosition - 1);
                if (toLeft != null) {
                    command.setGroupToLeft(toLeft);
                }
            }
            command.setReorderByIndex(true);
            return this.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(command);
        }
        return false;
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> labels = super.getProvidedLabels();
        labels.add("COLUMN_GROUP_HEADER");
        labels.add("GROUP_COLLAPSED");
        labels.add("GROUP_EXPANDED");
        if (this.getConfigLabelAccumulator() instanceof IConfigLabelProvider) {
            labels.addAll(((IConfigLabelProvider)this.getConfigLabelAccumulator()).getProvidedLabels());
        }
        return labels;
    }

    private final class StructuralChangeLayerListener
    implements ILayerListener {
        private StructuralChangeLayerListener() {
        }

        @Override
        public void handleLayerEvent(ILayerEvent event) {
            block22: {
                Collection<StructuralDiff> columnDiffs;
                block23: {
                    block21: {
                        if (!(event instanceof ColumnReorderEvent)) break block21;
                        this.updateColumnGroupModel((ColumnReorderEvent)event);
                        break block22;
                    }
                    if (!(event instanceof IStructuralChangeEvent) || !((IStructuralChangeEvent)event).isHorizontalStructureChanged()) break block22;
                    IStructuralChangeEvent changeEvent = (IStructuralChangeEvent)event;
                    columnDiffs = changeEvent.getColumnDiffs();
                    boolean performUpdate = false;
                    if (columnDiffs == null || columnDiffs.isEmpty()) break block23;
                    int[] deletedPositions = this.getDeletedPositions(columnDiffs);
                    if (deletedPositions != null) {
                        if (event instanceof ColumnGroupCollapseEvent || event instanceof ColumnStructuralChangeEvent && ((ColumnStructuralChangeEvent)event).getColumnIndexes().length > deletedPositions.length) {
                            this.handleDeleteDiffs(new int[0]);
                        } else {
                            this.handleDeleteDiffs(deletedPositions);
                        }
                        performUpdate = true;
                    }
                    for (StructuralDiff diff : columnDiffs) {
                        if (diff.getDiffType() != StructuralDiff.DiffTypeEnum.ADD) continue;
                        this.updateVisibleStartPositions();
                        for (GroupModel groupModel : ColumnGroupHeaderLayer.this.model) {
                            HashMap<GroupModel.Group, UpdateColumnGroupCollapseCommand> collapseUpdates = new HashMap<GroupModel.Group, UpdateColumnGroupCollapseCommand>();
                            int i = diff.getAfterPositionRange().start;
                            while (i < diff.getAfterPositionRange().end) {
                                block26: {
                                    int newStartIndex;
                                    block24: {
                                        GroupModel.Group group;
                                        block25: {
                                            group = groupModel.getGroupByPosition(i);
                                            newStartIndex = ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(i);
                                            if (group == null || group.getVisibleStartPosition() > i) break block24;
                                            if (group.isCollapsed()) break block25;
                                            group.setVisibleSpan(group.getVisibleSpan() + 1);
                                            break block26;
                                        }
                                        UpdateColumnGroupCollapseCommand cmd = (UpdateColumnGroupCollapseCommand)collapseUpdates.get(group);
                                        if (cmd == null) {
                                            cmd = new UpdateColumnGroupCollapseCommand(groupModel, group);
                                            collapseUpdates.put(group, cmd);
                                        }
                                        if (!group.containsStaticIndex(newStartIndex)) {
                                            cmd.addIndexesToShow(newStartIndex);
                                            cmd.addIndexesToHide(ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(i) + 1);
                                        }
                                        if (group.getVisibleSpan() != 0) break block26;
                                        group.setVisibleSpan(1);
                                        break block26;
                                    }
                                    GroupModel.Group leftGroup = groupModel.getGroupByPosition(i - 1);
                                    if (leftGroup != null && leftGroup.getVisibleSpan() < leftGroup.getOriginalSpan() && leftGroup.hasMember(newStartIndex)) {
                                        if (!leftGroup.isCollapsed()) {
                                            leftGroup.setVisibleSpan(leftGroup.getVisibleSpan() + 1);
                                        } else if (!leftGroup.containsStaticIndex(newStartIndex)) {
                                            UpdateColumnGroupCollapseCommand cmd = (UpdateColumnGroupCollapseCommand)collapseUpdates.get(leftGroup);
                                            if (cmd == null) {
                                                cmd = new UpdateColumnGroupCollapseCommand(groupModel, leftGroup);
                                                collapseUpdates.put(leftGroup, cmd);
                                            }
                                            cmd.addIndexesToHide(ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(i));
                                        } else {
                                            leftGroup.setVisibleSpan(leftGroup.getVisibleSpan() + 1);
                                        }
                                    } else {
                                        GroupModel.Group g = groupModel.getGroupByStaticIndex(newStartIndex);
                                        if (g != null) {
                                            g.setVisibleStartIndex(newStartIndex);
                                            g.setVisibleSpan(g.getVisibleSpan() + 1);
                                            g.updateVisibleStartPosition();
                                        } else {
                                            int e = diff.getAfterPositionRange().end;
                                            while (e > diff.getAfterPositionRange().start) {
                                                g = groupModel.getGroupByPosition(e);
                                                if (g != null && g.hasMember(newStartIndex)) {
                                                    g.setStartIndex(newStartIndex);
                                                    g.setVisibleStartIndex(newStartIndex);
                                                    g.setVisibleSpan(g.getVisibleSpan() + 1);
                                                    g.updateVisibleStartPosition();
                                                    break;
                                                }
                                                --e;
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                            for (UpdateColumnGroupCollapseCommand cmd : collapseUpdates.values()) {
                                ColumnGroupHeaderLayer.this.doCommand(cmd);
                            }
                        }
                        performUpdate = true;
                    }
                    if (performUpdate) {
                        this.updateVisibleStartPositions();
                    }
                    break block22;
                }
                this.performConsistencyCheck(columnDiffs == null);
            }
        }

        private int[] getDeletedPositions(Collection<StructuralDiff> columnDiffs) {
            MutableIntList result = IntLists.mutable.empty();
            boolean deleteDiffFound = false;
            for (StructuralDiff diff : columnDiffs) {
                if (diff.getDiffType() != StructuralDiff.DiffTypeEnum.DELETE) continue;
                deleteDiffFound = true;
                int[] positions = PositionUtil.getPositions(diff.getBeforePositionRange());
                result.addAll(positions);
            }
            if (deleteDiffFound) {
                return result.sortThis().reverseThis().toArray();
            }
            return null;
        }

        private void handleDeleteDiffs(int[] positionList) {
            if (positionList.length > 0) {
                for (GroupModel groupModel : ColumnGroupHeaderLayer.this.model) {
                    MutableIntList groupPositionList = IntLists.mutable.of(Arrays.copyOf(positionList, positionList.length));
                    int previousSize = Integer.MAX_VALUE;
                    while (!groupPositionList.isEmpty() && groupPositionList.size() < previousSize) {
                        previousSize = groupPositionList.size();
                        Integer pos = groupPositionList.get(0);
                        GroupModel.Group group = groupModel.getGroupByPosition(pos);
                        if (group != null) {
                            MutableIntList groupPositions = IntLists.mutable.of(group.getVisiblePositions());
                            MutableIntList hiddenGroupPositions = groupPositions.select(arg_0 -> ((MutableIntList)groupPositionList).contains(arg_0));
                            groupPositionList.removeAll((IntIterable)hiddenGroupPositions);
                            groupPositions.removeAll((IntIterable)hiddenGroupPositions);
                            if (groupPositions.size() > 0) {
                                group.setVisibleSpan(groupPositions.size());
                                hiddenGroupPositions.forEach((IntProcedure & Serializable)i -> {
                                    if (group.getVisibleStartPosition() == i) {
                                        group.setVisibleStartIndex(ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(i - groupPositionList.size()));
                                    }
                                });
                                continue;
                            }
                            group.setVisibleStartIndex(-1);
                            group.setVisibleSpan(0);
                            continue;
                        }
                        groupPositionList.remove(pos.intValue());
                    }
                }
            } else {
                this.performConsistencyCheck(false);
            }
        }

        private void updateVisibleStartPositions() {
            for (GroupModel groupModel : ColumnGroupHeaderLayer.this.model) {
                groupModel.updateVisibleStartPositions();
            }
        }

        private void performConsistencyCheck(boolean updateStartIndex) {
            for (GroupModel groupModel : ColumnGroupHeaderLayer.this.model) {
                groupModel.performConsistencyCheck(updateStartIndex);
            }
        }

        private void updateColumnGroupModel(ColumnReorderEvent reorderEvent) {
            int[] fromColumnPositions = PositionUtil.getPositions(reorderEvent.getBeforeFromColumnPositionRanges());
            int toColumnPosition = reorderEvent.getBeforeToColumnPosition();
            boolean reorderToLeftEdge = reorderEvent.isReorderToLeftEdge();
            int fromColumnPosition = toColumnPosition;
            if (toColumnPosition > fromColumnPositions[fromColumnPositions.length - 1]) {
                fromColumnPosition = fromColumnPositions[fromColumnPositions.length - 1];
            } else if (toColumnPosition < fromColumnPositions[fromColumnPositions.length - 1]) {
                fromColumnPosition = fromColumnPositions[0];
            }
            SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getHorizontalMoveDirection(fromColumnPosition, toColumnPosition);
            if (reorderToLeftEdge && toColumnPosition > 0 && SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
                --toColumnPosition;
            }
            if (fromColumnPosition == -1 || toColumnPosition == -1) {
                LOG.error("Invalid reorder positions, fromPosition: {}, toPosition: {}", (Object)fromColumnPosition, (Object)toColumnPosition);
                return;
            }
            for (GroupModel groupModel : ColumnGroupHeaderLayer.this.model) {
                GroupModel.Group toColumnGroup = groupModel.getGroupByPosition(toColumnPosition);
                GroupModel.Group fromColumnGroup = groupModel.getGroupByPosition(fromColumnPosition);
                if (fromColumnGroup != null && toColumnGroup != null && fromColumnGroup.equals(toColumnGroup)) {
                    if (fromColumnPosition == toColumnPosition && (!ColumnGroupUtils.isGroupReordered(fromColumnGroup, fromColumnPositions) || fromColumnGroup.isCollapsed() && fromColumnGroup.getMembers().length > 1) && (fromColumnGroup.isGroupStart(fromColumnPosition) || fromColumnGroup.isGroupEnd(fromColumnPosition))) {
                        if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
                            int[] pos = new int[fromColumnPositions.length];
                            int index = 0;
                            int from = fromColumnPositions.length - 1;
                            while (from >= 0) {
                                pos[index] = fromColumnPositions[from];
                                ++index;
                                --from;
                            }
                            this.removePositionsFromGroup(groupModel, fromColumnGroup, pos, reorderEvent.getBeforeFromColumnIndexesArray(), fromColumnPosition, moveDirection);
                            break;
                        }
                        this.removePositionsFromGroup(groupModel, fromColumnGroup, fromColumnPositions, reorderEvent.getBeforeFromColumnIndexesArray(), fromColumnPosition, moveDirection);
                        break;
                    }
                    if (fromColumnPosition != toColumnPosition && (fromColumnGroup.getVisibleStartPosition() == fromColumnPositions[0] || toColumnGroup.getVisibleStartPosition() == toColumnPosition)) {
                        int newStartIndex = ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(fromColumnGroup.getVisibleStartPosition());
                        fromColumnGroup.setVisibleStartIndex(newStartIndex);
                        if (!fromColumnGroup.isCollapsed() || fromColumnGroup.containsStaticIndex(fromColumnGroup.getStartIndex())) {
                            fromColumnGroup.setStartIndex(newStartIndex);
                        }
                    }
                } else if (fromColumnGroup == null && toColumnGroup != null) {
                    this.addPositionsToGroup(groupModel, toColumnGroup, fromColumnPositions, reorderEvent.getBeforeFromColumnIndexesArray(), toColumnPosition, moveDirection);
                } else if (fromColumnGroup != null && toColumnGroup == null && !ColumnGroupUtils.isGroupReordered(fromColumnGroup, fromColumnPositions)) {
                    this.removePositionsFromGroup(groupModel, fromColumnGroup, fromColumnPositions, reorderEvent.getBeforeFromColumnIndexesArray(), fromColumnPosition, moveDirection);
                } else if (fromColumnGroup == null && toColumnGroup == null && fromColumnPosition == toColumnPosition && fromColumnPositions.length == 1) {
                    int adjacentPos = moveDirection == SelectionLayer.MoveDirectionEnum.RIGHT ? fromColumnPosition + 1 : fromColumnPosition - 1;
                    GroupModel.Group adjacentColumnGroup = groupModel.getGroupByPosition(adjacentPos);
                    if (adjacentColumnGroup != null && !adjacentColumnGroup.isUnbreakable()) {
                        this.addPositionsToGroup(groupModel, adjacentColumnGroup, fromColumnPositions, reorderEvent.getBeforeFromColumnIndexesArray(), adjacentColumnGroup.isCollapsed() && moveDirection != SelectionLayer.MoveDirectionEnum.RIGHT ? toColumnPosition : adjacentPos, moveDirection);
                    }
                } else if (!(fromColumnGroup == null || toColumnGroup == null || fromColumnGroup.equals(toColumnGroup) || ColumnGroupUtils.isGroupReordered(fromColumnGroup, fromColumnPositions) && (fromColumnGroup.isCollapsed() || fromColumnGroup.getVisiblePositions().length != 1))) {
                    this.removePositionsFromGroup(groupModel, fromColumnGroup, fromColumnPositions, reorderEvent.getBeforeFromColumnIndexesArray(), fromColumnPositions[0], moveDirection);
                    this.addPositionsToGroup(groupModel, toColumnGroup, fromColumnPositions, reorderEvent.getBeforeFromColumnIndexesArray(), toColumnPosition, moveDirection);
                }
                groupModel.updateVisibleStartPositions();
            }
        }

        private void addPositionsToGroup(GroupModel groupModel, GroupModel.Group group, int[] fromColumnPositions, int[] fromColumnIndexes, int toPosition, SelectionLayer.MoveDirectionEnum moveDirection) {
            if (!group.isUnbreakable()) {
                group.setOriginalSpan(group.getOriginalSpan() + fromColumnPositions.length);
                if (group.isGroupStart(toPosition)) {
                    int newStartIndex;
                    int n = newStartIndex = moveDirection == SelectionLayer.MoveDirectionEnum.RIGHT ? ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(group.getVisibleStartPosition() - fromColumnPositions.length) : ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(group.getVisibleStartPosition());
                    if (group.getVisibleStartIndex() == group.getStartIndex()) {
                        group.setStartIndex(newStartIndex);
                    }
                    group.setVisibleStartIndex(newStartIndex);
                }
                group.addMembers(fromColumnIndexes);
                if (group.isCollapsed()) {
                    UpdateColumnGroupCollapseCommand cmd = new UpdateColumnGroupCollapseCommand(groupModel, group);
                    if (group.isGroupStart(toPosition)) {
                        cmd.addIndexesToHide(group.getMembers());
                        if (group.getStaticIndexes().length > 0) {
                            group.setVisibleSpan(group.getVisibleSpan() + fromColumnPositions.length);
                        }
                        group.updateVisibleStartPosition();
                    } else {
                        cmd.addIndexesToHide(fromColumnIndexes);
                        group.setVisibleSpan(group.getVisibleSpan() + fromColumnPositions.length);
                    }
                    ColumnGroupHeaderLayer.this.getPositionLayer().doCommand(cmd);
                } else {
                    group.setVisibleSpan(group.getVisibleSpan() + fromColumnPositions.length);
                }
            }
        }

        private void removePositionsFromGroup(GroupModel groupModel, GroupModel.Group group, int[] fromColumnPositions, int[] fromColumnIndexes, int fromColumnPosition, SelectionLayer.MoveDirectionEnum moveDirection) {
            if (!group.isUnbreakable()) {
                boolean collapsed = group.isCollapsed();
                if (collapsed) {
                    int fromColumnIndex = ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(fromColumnPosition);
                    ColumnGroupHeaderLayer.this.expandGroup(groupModel, group);
                    fromColumnPosition = ColumnGroupHeaderLayer.this.getPositionLayer().getColumnPositionByIndex(fromColumnIndex);
                }
                group.setOriginalSpan(group.getOriginalSpan() - fromColumnPositions.length);
                group.setVisibleSpan(group.getVisibleSpan() - fromColumnPositions.length);
                if (group.isGroupStart(fromColumnPosition)) {
                    int newStartIndex = moveDirection == SelectionLayer.MoveDirectionEnum.RIGHT ? ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(group.getVisibleStartPosition()) : ColumnGroupHeaderLayer.this.getPositionLayer().getColumnIndexByPosition(group.getVisibleStartPosition() + fromColumnPositions.length);
                    group.setStartIndex(newStartIndex);
                    group.setVisibleStartIndex(newStartIndex);
                }
                group.removeMembers(fromColumnIndexes);
                group.removeStaticIndexes(ArrayUtil.asIntArray(fromColumnIndexes));
                if (group.getOriginalSpan() > 0) {
                    group.updateVisibleStartPosition();
                    if (collapsed) {
                        ColumnGroupHeaderLayer.this.collapseGroup(groupModel, group);
                    }
                } else {
                    groupModel.removeGroup(group);
                }
            }
        }
    }
}

