/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.hyperlinking;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.AbstractHyperlink;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class STAlgorithmHyperlinkHelper
extends HyperlinkHelper {
    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        EObject target;
        INode node = this.getEObjectAtOffsetHelper().getCrossReferenceNode(resource, (ITextRegion)new TextRegion(offset, 0));
        if (node != null && (target = this.getEObjectAtOffsetHelper().getCrossReferencedElement(node)) != null && !target.eIsProxy()) {
            EObject eObject;
            EObject eObject2 = target;
            Objects.requireNonNull(eObject2);
            EObject eObject3 = eObject = eObject2;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FB.class, Event.class, AdapterDeclaration.class}, (Object)eObject3, n)) {
                    case 0: {
                        FB fb = (FB)eObject;
                        this.createHyperlinksToType(resource, node, fb.getType(), acceptor);
                        break block5;
                    }
                    case 1: {
                        Event event = (Event)eObject;
                        if (event.getFBType() == null) {
                            eObject3 = eObject;
                            n = 2;
                            continue block5;
                        }
                        this.createHyperlinksToType(resource, node, event.getFBType(), acceptor);
                        break block5;
                    }
                    case 2: {
                        AdapterDeclaration adapterDeclaration = (AdapterDeclaration)eObject;
                        this.createHyperlinksToType(resource, node, adapterDeclaration.getAdapterFB().getType(), acceptor);
                        break block5;
                    }
                    default: {
                        this.createHyperlinksTo(resource, node, target, acceptor);
                    }
                }
                break;
            }
        }
    }

    protected void createHyperlinksToType(XtextResource from, INode node, FBType target, IHyperlinkAcceptor acceptor) {
        super.createHyperlinksTo(from, node, (EObject)target, (IHyperlinkAcceptor)new RenamingHyperlinkAcceptor(new TrimmingHyperlinkAcceptor(acceptor), "Open Type - " + target.getName()));
    }

    protected static class RenamingHyperlinkAcceptor
    implements IHyperlinkAcceptor {
        private final IHyperlinkAcceptor delegate;
        private final String text;

        protected RenamingHyperlinkAcceptor(IHyperlinkAcceptor acceptor, String text) {
            this.delegate = acceptor;
            this.text = text;
        }

        public void accept(IHyperlink hyperlink) {
            if (hyperlink instanceof AbstractHyperlink) {
                ((AbstractHyperlink)hyperlink).setHyperlinkText(this.text);
            }
            this.delegate.accept(hyperlink);
        }
    }

    protected static class TrimmingHyperlinkAcceptor
    implements IHyperlinkAcceptor {
        private final IHyperlinkAcceptor delegate;

        protected TrimmingHyperlinkAcceptor(IHyperlinkAcceptor acceptor) {
            this.delegate = acceptor;
        }

        public void accept(IHyperlink hyperlink) {
            if (hyperlink instanceof XtextHyperlink) {
                XtextHyperlink xtextHyperlink = (XtextHyperlink)hyperlink;
                xtextHyperlink.setURI(xtextHyperlink.getURI().trimFragment());
            }
            this.delegate.accept(hyperlink);
        }
    }
}

