/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyDateValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class LDateAndTimeValue
implements AnyDateValue {
    public static final LDateAndTimeValue DEFAULT = new LDateAndTimeValue(0L);
    private final long value;

    private LDateAndTimeValue(long value) {
        this.value = value;
    }

    public static LDateAndTimeValue toLDateAndTimeValue(long value) {
        return new LDateAndTimeValue(value);
    }

    public static LDateAndTimeValue toLDateAndTimeValue(Number value) {
        return new LDateAndTimeValue(value.longValue());
    }

    public static LDateAndTimeValue toLDateAndTimeValue(LocalDateTime value) {
        return new LDateAndTimeValue(LocalDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC).until(value, ChronoUnit.NANOS));
    }

    public static LDateAndTimeValue toLDateAndTimeValue(String value) {
        return LDateAndTimeValue.toLDateAndTimeValue((LocalDateTime)TypedValueConverter.INSTANCE_LDATE_AND_TIME.toValue(value));
    }

    public static LDateAndTimeValue toLDateAndTimeValue(AnyDateValue value) {
        return LDateAndTimeValue.toLDateAndTimeValue(value.toNanos());
    }

    public LdtType getType() {
        return IecTypes.ElementaryTypes.LDATE_AND_TIME;
    }

    @Override
    public long toNanos() {
        return this.value;
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.ofEpochSecond(this.value / 1000000000L, (int)(this.value % 1000000000L), ZoneOffset.UTC);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LDateAndTimeValue other = (LDateAndTimeValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return TypedValueConverter.INSTANCE_LDATE_AND_TIME.toString((Object)this.toLocalDateTime());
    }
}

