/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fmu.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fordiac.ide.fmu.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class FMUPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Group librariesGroup;
    private BooleanFieldEditor win32Field;
    private BooleanFieldEditor win64Field;
    private BooleanFieldEditor linux32Field;
    private BooleanFieldEditor linux64Field;

    public FMUPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.fmu"));
        this.setDescription(Messages.FMUPreferencePage_FMUPreferencesPage);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new DirectoryFieldEditor("pathPreference", Messages.FMUPreferencePage_BinariesLocation, this.getFieldEditorParent()));
        this.librariesGroup = new Group(this.getFieldEditorParent(), 0);
        this.librariesGroup.setText(Messages.FMUPreferencePage_IncludeTheFollowingLibrariesInExportedFMU);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.win32Field = new BooleanFieldEditor("win32", "win32", (Composite)this.librariesGroup);
        this.win32Field.setEnabled(false, (Composite)this.librariesGroup);
        this.addField((FieldEditor)this.win32Field);
        this.win64Field = new BooleanFieldEditor("win64", "win64", (Composite)this.librariesGroup);
        this.win64Field.setEnabled(false, (Composite)this.librariesGroup);
        this.addField((FieldEditor)this.win64Field);
        this.linux32Field = new BooleanFieldEditor("linux32", "linux32", (Composite)this.librariesGroup);
        this.linux32Field.setEnabled(false, (Composite)this.librariesGroup);
        this.addField((FieldEditor)this.linux32Field);
        this.linux64Field = new BooleanFieldEditor("linux64", "linux64", (Composite)this.librariesGroup);
        this.linux64Field.setEnabled(false, (Composite)this.librariesGroup);
        this.addField((FieldEditor)this.linux64Field);
        this.librariesGroup.setLayoutData((Object)gridData);
        this.librariesGroup.setLayout((Layout)gridLayout);
        this.updateEnabledLibraries(true, this.getPreferenceStore().getString("pathPreference"));
    }

    public void propertyChange(PropertyChangeEvent event) {
        DirectoryFieldEditor fieldEditor;
        Object object = event.getSource();
        if (object instanceof DirectoryFieldEditor && (fieldEditor = (DirectoryFieldEditor)object).getPreferenceName().equals("pathPreference")) {
            Object object2 = event.getNewValue();
            if (object2 instanceof String) {
                String newValue = (String)object2;
                this.updateEnabledLibraries(true, newValue);
            } else if (event.getNewValue() instanceof Boolean) {
                this.updateEnabledLibraries(false, null);
            }
        }
        super.propertyChange(event);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.FMUPreferencePage_InsideTheSelectedPathTheFilesSearchedFor);
    }

    private void updateEnabledLibraries(boolean validPath, String pathString) {
        if (validPath) {
            this.win32Field.setEnabled(new File(pathString + File.separatorChar + "win32Forte.dll").exists(), (Composite)this.librariesGroup);
            this.win64Field.setEnabled(new File(pathString + File.separatorChar + "win64Forte.dll").exists(), (Composite)this.librariesGroup);
            this.linux32Field.setEnabled(new File(pathString + File.separatorChar + "linux32Forte.so").exists(), (Composite)this.librariesGroup);
            this.linux64Field.setEnabled(new File(pathString + File.separatorChar + "linux64Forte.so").exists(), (Composite)this.librariesGroup);
        } else {
            this.win32Field.setEnabled(false, (Composite)this.librariesGroup);
            this.win64Field.setEnabled(false, (Composite)this.librariesGroup);
            this.linux32Field.setEnabled(false, (Composite)this.librariesGroup);
            this.linux64Field.setEnabled(false, (Composite)this.librariesGroup);
        }
    }

    public static List<String> getFoundLibraries() {
        ArrayList<String> found = new ArrayList<String>();
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.fmu");
        String pathString = store.getString("pathPreference");
        if (new File(pathString + File.separatorChar + "win32Forte.dll").exists()) {
            found.add("win32");
        }
        if (new File(pathString + File.separatorChar + "win64Forte.dll").exists()) {
            found.add("win64");
        }
        if (new File(pathString + File.separatorChar + "linux32Forte.so").exists()) {
            found.add("linux32");
        }
        if (new File(pathString + File.separatorChar + "linux64Forte.so").exists()) {
            found.add("linux64");
        }
        return found;
    }
}

