/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.breakpoint;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class DeploymentWatchpoint
extends Breakpoint {
    public static final String DEBUG_MODEL = "org.eclipse.fordiac.ide.deployment.debug.model";
    public static final String BREAKPOINT_MARKER = "org.eclipse.fordiac.ide.deployment.debug.watchpointMarker";
    public static final String INSTALLED = "org.eclipse.fordiac.ide.deployment.debug.watchpointMarker.installed";
    public static final String FORCE_VALUE = "org.eclipse.fordiac.ide.deployment.debug.watchpointMarker.forceValue";
    public static final String FORCE_ENABLED = "org.eclipse.fordiac.ide.deployment.debug.watchpointMarker.forceEnabled";
    public static final String PINNED = "org.eclipse.fordiac.ide.deployment.debug.watchpointMarker.pinned";

    public DeploymentWatchpoint() {
    }

    public DeploymentWatchpoint(IResource resource, INamedElement element) throws CoreException {
        this.run(this.getMarkerRule(resource), monitor -> {
            IMarker iMarker = this.createMarker(resource, element);
        });
    }

    protected IMarker createMarker(IResource resource, INamedElement element) throws CoreException {
        IMarker marker = ErrorMarkerBuilder.createErrorMarkerBuilder((String)("Deployment Watchpoint: " + resource.getName() + " [qualifiedName: " + element.getQualifiedName() + "]")).setType(this.getMarkerId()).setSeverity(0).setPriority(1).setSource(DEBUG_MODEL).setTarget((EObject)element).addAdditionalAttributes(Map.of("org.eclipse.debug.core.enabled", Boolean.TRUE, "org.eclipse.debug.core.persisted", Boolean.TRUE, "org.eclipse.debug.core.id", this.getModelIdentifier())).createMarker(resource);
        this.setMarker(marker);
        return marker;
    }

    public Optional<INamedElement> getTarget() {
        SystemEntry systemEntry;
        AutomationSystem system;
        IFile file;
        TypeEntry typeEntry;
        IResource iResource;
        IMarker marker = this.getMarker();
        if (marker != null && (iResource = marker.getResource()) instanceof IFile && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file = (IFile)iResource)) instanceof SystemEntry && (system = (systemEntry = (SystemEntry)typeEntry).getType()) != null) {
            return this.getTarget(system);
        }
        return Optional.empty();
    }

    public Optional<INamedElement> getTarget(AutomationSystem system) {
        return this.getTargets(system).findFirst();
    }

    public Optional<INamedElement> getTarget(Device device) {
        return this.getTargets(device.getAutomationSystem()).filter(target -> device.equals(DeploymentDebugWatchUtils.getDevice(target))).findFirst();
    }

    public Stream<INamedElement> getTargets(AutomationSystem system) {
        String location = this.getLocation();
        Optional<EClass> targetType = this.getTargetType();
        if (location.isEmpty() || targetType.isEmpty()) {
            return Stream.empty();
        }
        return system.findByQualifiedName(location).filter(element -> ((EClass)targetType.get()).equals(element.eClass()));
    }

    public Optional<EClass> getTargetType() {
        IMarker marker = this.getMarker();
        if (marker != null) {
            return Optional.ofNullable(FordiacErrorMarker.getTargetType((IMarker)marker));
        }
        return Optional.empty();
    }

    public boolean isRelevant(AutomationSystem system) {
        IMarker marker = this.getMarker();
        if (marker != null) {
            TypeEntry typeEntry = system.getTypeEntry();
            return typeEntry != null && marker.getResource().equals((Object)typeEntry.getFile());
        }
        return false;
    }

    public String getLocation() {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("location", "");
        }
        return "";
    }

    public boolean isInstalled() {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(INSTALLED, false);
        }
        return false;
    }

    public void setInstalled(boolean installed) throws CoreException {
        this.setAttribute(INSTALLED, installed);
    }

    public boolean isForceEnabled() {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(FORCE_ENABLED, false);
        }
        return false;
    }

    public void setForceEnabled(boolean enabled) throws CoreException {
        this.setAttribute(FORCE_ENABLED, enabled);
    }

    public String getForceValue() {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(FORCE_VALUE, "");
        }
        return "";
    }

    public void setForceValue(String value) throws CoreException {
        this.setAttribute(FORCE_VALUE, value);
    }

    public boolean isForceSupported() {
        IMarker m = this.getMarker();
        if (m != null) {
            if (FordiacErrorMarker.getTargetType((IMarker)m) == LibraryElementPackage.Literals.VAR_DECLARATION) {
                if (this.getTarget().filter(VarDeclaration.class::isInstance).map(VarDeclaration.class::cast).filter(Predicate.not(VarDeclaration::isInOutVar)).isPresent()) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isForceChanged(IMarkerDelta delta) {
        return delta.getKind() == 4 && (this.isForceEnabled() != delta.getAttribute(FORCE_ENABLED, false) || !this.getForceValue().equals(delta.getAttribute(FORCE_VALUE, "")));
    }

    public boolean isPinned() {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(PINNED, false);
        }
        return false;
    }

    public void setPinned(boolean pinned) throws CoreException {
        this.setAttribute(PINNED, pinned);
    }

    public boolean isPinnedChanged(IMarkerDelta delta) {
        return delta.getKind() == 4 && this.isPinned() != delta.getAttribute(PINNED, false);
    }

    public boolean isEnabled() {
        try {
            return super.isEnabled();
        }
        catch (CoreException e) {
            return false;
        }
    }

    public boolean isEnabledChanged(IMarkerDelta delta) {
        return delta.getKind() == 4 && this.isEnabled() != delta.getAttribute("org.eclipse.debug.core.enabled", false);
    }

    public String getMarkerId() {
        return BREAKPOINT_MARKER;
    }

    public String getModelIdentifier() {
        return DEBUG_MODEL;
    }
}

