/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class FBNetworkEditDomain
extends DefaultEditDomain {
    public FBNetworkEditDomain(IEditorPart editorPart) {
        super(editorPart);
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        EditPartViewer actualViewer = FBNetworkEditDomain.findViewer(new Point(me.x, me.y), viewer);
        MouseEvent convertedEvent = FBNetworkEditDomain.convertMouseEventCoordinates(me, viewer, actualViewer);
        super.mouseUp(convertedEvent, actualViewer);
    }

    public void mouseMove(MouseEvent me, EditPartViewer viewer) {
        EditPartViewer actualViewer = FBNetworkEditDomain.findViewer(new Point(me.x, me.y), viewer);
        MouseEvent convertedEvent = FBNetworkEditDomain.convertMouseEventCoordinates(me, viewer, actualViewer);
        super.mouseMove(convertedEvent, actualViewer);
    }

    public void mouseHover(MouseEvent me, EditPartViewer viewer) {
        EditPartViewer actualViewer = FBNetworkEditDomain.findViewer(new Point(me.x, me.y), viewer);
        MouseEvent convertedEvent = FBNetworkEditDomain.convertMouseEventCoordinates(me, viewer, actualViewer);
        super.mouseHover(convertedEvent, actualViewer);
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        EditPartViewer actualViewer = FBNetworkEditDomain.findViewer(new Point(me.x, me.y), viewer);
        MouseEvent convertedEvent = FBNetworkEditDomain.convertMouseEventCoordinates(me, viewer, actualViewer);
        super.mouseDrag(convertedEvent, actualViewer);
    }

    private static EditPartViewer findViewer(Point point, EditPartViewer viewer) {
        if (viewer.getControl().getBounds().contains(point)) {
            return viewer;
        }
        Point absolute = viewer.getControl().toDisplay(point);
        return Stream.of(PlatformUI.getWorkbench().getWorkbenchWindows()).flatMap(window -> Stream.of(window.getPages())).flatMap(page -> Stream.of(page.getEditorReferences())).map(ref -> ref.getEditor(false)).filter(Objects::nonNull).map(editor -> (EditPartViewer)editor.getAdapter(GraphicalViewer.class)).filter(Objects::nonNull).filter(candidate -> FBNetworkEditDomain.containsAbsolutePoint(candidate, absolute)).findAny().orElse(viewer);
    }

    private static boolean containsAbsolutePoint(EditPartViewer viewer, Point point) {
        Control control = viewer.getControl();
        if (control.getParent() != null) {
            return control.getBounds().contains(control.getParent().toControl(point));
        }
        return control.getBounds().contains(point);
    }

    private static MouseEvent convertMouseEventCoordinates(MouseEvent event, EditPartViewer from, EditPartViewer to) {
        if (from == to) {
            return event;
        }
        Point converted = to.getControl().toControl(from.getControl().toDisplay(event.x, event.y));
        Event swtEvent = new Event();
        swtEvent.display = event.display;
        swtEvent.widget = event.widget;
        swtEvent.time = event.time;
        swtEvent.data = event.data;
        swtEvent.x = converted.x;
        swtEvent.y = converted.y;
        swtEvent.button = event.button;
        swtEvent.stateMask = event.stateMask;
        swtEvent.count = event.count;
        return new MouseEvent(swtEvent);
    }
}

