/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.SplineRoutingMode;
import org.eclipse.elk.alg.layered.p5edges.PolylineEdgeRouter;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineSegment;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public final class SplineEdgeRouter
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final double MAX_VERTICAL_DIFF_FOR_STRAIGHT = 0.2;
    public static final int SPLINE_DIMENSION = 3;
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.FINAL_SPLINE_BENDPOINTS_CALCULATOR).addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.INVERTED_PORT_PROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> SELF_LOOP_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.SELF_LOOP_PREPROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.SELF_LOOP_POSTPROCESSOR).before((Enum)LayeredPhases.P4_NODE_PLACEMENT).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.SELF_LOOP_PORT_RESTORER).add((ILayoutProcessorFactory)IntermediateProcessorStrategy.SELF_LOOP_ROUTER);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> CENTER_EDGE_LABEL_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P2_LAYERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_DUMMY_INSERTER).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_DUMMY_SWITCHER).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_DUMMY_REMOVER);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.NORTH_SOUTH_PORT_PREPROCESSOR).addBefore((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.NORTH_SOUTH_PORT_POSTPROCESSOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> END_EDGE_LABEL_PROCESSING_ADDITIONS = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.END_LABEL_PREPROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.END_LABEL_POSTPROCESSOR);
    private final List<LEdge> edgesRemainingLayer = Lists.newArrayList();
    private final List<SplineSegment> splineSegmentsLayer = Lists.newArrayList();
    private final Set<LPort> leftPortsLayer = Sets.newLinkedHashSet();
    private final Set<LPort> rightPortsLayer = Sets.newLinkedHashSet();
    private final Set<LEdge> selfLoopsLayer = Sets.newLinkedHashSet();
    private LGraph lGraph;
    private final List<LEdge> startEdges = Lists.newArrayList();
    private final List<SplineSegment> allSplineSegments = Lists.newArrayList();
    private final Map<LEdge, SplineSegment> edgeToSegmentMap = Maps.newHashMap();
    private final Map<LEdge, LEdge> successingEdge = Maps.newHashMap();

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        LayoutProcessorConfiguration configuration = LayoutProcessorConfiguration.create();
        configuration.addAll(BASELINE_PROCESSING_ADDITIONS);
        Set graphProperties = (Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        if (graphProperties.contains((Object)GraphProperties.SELF_LOOPS)) {
            configuration.addAll(SELF_LOOP_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.CENTER_LABELS)) {
            configuration.addAll(CENTER_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
            configuration.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.END_LABELS)) {
            configuration.addAll(END_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        return configuration;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        Layer rightLayer;
        monitor.begin("Spline edge routing", 1.0f);
        if (layeredGraph.getLayers().isEmpty()) {
            layeredGraph.getSize().x = 0.0;
            monitor.done();
            return;
        }
        double nodeNodeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double edgeNodeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        double edgeEdgeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        SplineRoutingMode mode = (SplineRoutingMode)((Object)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING_SPLINES_MODE));
        boolean sloppyRouting = mode == SplineRoutingMode.SLOPPY;
        double sloppyLayerSpacingFactor = (Double)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING_SPLINES_SLOPPY_LAYER_SPACING_FACTOR);
        this.lGraph = layeredGraph;
        this.startEdges.clear();
        this.allSplineSegments.clear();
        this.successingEdge.clear();
        Layer firstLayer = layeredGraph.getLayers().get(0);
        boolean isLeftLayerExternal = Iterables.all(firstLayer.getNodes(), PolylineEdgeRouter.PRED_EXTERNAL_WEST_OR_EAST_PORT);
        Layer lastLayer = layeredGraph.getLayers().get(layeredGraph.getLayers().size() - 1);
        boolean isRightLayerExternal = Iterables.all(lastLayer.getNodes(), PolylineEdgeRouter.PRED_EXTERNAL_WEST_OR_EAST_PORT);
        Iterator<Layer> layerIterator = layeredGraph.iterator();
        Layer leftLayer = null;
        double xpos = 0.0;
        do {
            boolean isSpecialRightLayer;
            rightLayer = layerIterator.hasNext() ? layerIterator.next() : null;
            this.clearThenFillMappings(leftLayer, rightLayer);
            this.createSegmentsAndComputeRanking();
            int slotCount = this.splineSegmentsLayer.stream().filter(e -> !e.isStraight).mapToInt(e -> e.rank + 1).max().orElse(0);
            double xSegmentDelta = 0.0;
            double rightLayerPosition = xpos;
            boolean isSpecialLeftLayer = leftLayer == null || isLeftLayerExternal && leftLayer == firstLayer;
            boolean bl = isSpecialRightLayer = rightLayer == null || isRightLayerExternal && rightLayer == lastLayer;
            if (slotCount > 0) {
                double increment = 0.0;
                if (leftLayer != null) {
                    increment += edgeNodeSpacing;
                }
                increment += (double)(slotCount - 1) * edgeEdgeSpacing;
                if (rightLayer != null) {
                    increment += edgeNodeSpacing;
                }
                if (sloppyRouting && rightLayer != null) {
                    increment = Math.max(increment, this.computeSloppySpacing(rightLayer, edgeEdgeSpacing, nodeNodeSpacing, sloppyLayerSpacingFactor));
                }
                if (increment < nodeNodeSpacing && !isSpecialLeftLayer && !isSpecialRightLayer) {
                    xSegmentDelta = (nodeNodeSpacing - increment) / 2.0;
                    increment = nodeNodeSpacing;
                }
                rightLayerPosition += increment;
            } else if (!isSpecialLeftLayer && !isSpecialRightLayer) {
                rightLayerPosition += nodeNodeSpacing;
            }
            if (rightLayer != null) {
                LGraphUtil.placeNodesHorizontally(rightLayer, rightLayerPosition);
            }
            for (SplineSegment segment : this.splineSegmentsLayer) {
                segment.boundingBox.x = xpos;
                segment.boundingBox.width = rightLayerPosition - xpos;
                segment.xDelta = xSegmentDelta;
                boolean bl2 = segment.isWestOfInitialLayer = leftLayer == null;
            }
            this.allSplineSegments.addAll(this.splineSegmentsLayer);
            xpos = rightLayerPosition;
            if (rightLayer != null) {
                xpos += rightLayer.getSize().x;
            }
            leftLayer = rightLayer;
            isSpecialLeftLayer = isSpecialRightLayer;
        } while (rightLayer != null);
        for (LEdge edge : this.startEdges) {
            List<LEdge> edgeChain = this.getEdgeChain(edge);
            edge.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, edgeChain);
            List<SplineSegment> spline = this.getSplinePath(edge);
            edge.setProperty(InternalProperties.SPLINE_ROUTE_START, spline);
        }
        layeredGraph.getSize().x = xpos;
        this.lGraph = null;
        monitor.done();
    }

    private void createSegmentsAndComputeRanking() {
        this.createSplineSegmentsForHyperEdges(this.leftPortsLayer, this.rightPortsLayer, SideToProcess.LEFT, true, this.edgesRemainingLayer, this.splineSegmentsLayer);
        this.createSplineSegmentsForHyperEdges(this.leftPortsLayer, this.rightPortsLayer, SideToProcess.LEFT, false, this.edgesRemainingLayer, this.splineSegmentsLayer);
        this.createSplineSegmentsForHyperEdges(this.leftPortsLayer, this.rightPortsLayer, SideToProcess.RIGHT, true, this.edgesRemainingLayer, this.splineSegmentsLayer);
        this.createSplineSegmentsForHyperEdges(this.leftPortsLayer, this.rightPortsLayer, SideToProcess.RIGHT, false, this.edgesRemainingLayer, this.splineSegmentsLayer);
        this.createSplineSegments(this.edgesRemainingLayer, this.leftPortsLayer, this.rightPortsLayer, this.splineSegmentsLayer);
        ListIterator<SplineSegment> sourceIter = this.splineSegmentsLayer.listIterator();
        while (sourceIter.hasNext()) {
            SplineSegment hyperEdge1 = sourceIter.next();
            ListIterator<SplineSegment> targetIter = this.splineSegmentsLayer.listIterator(sourceIter.nextIndex());
            while (targetIter.hasNext()) {
                SplineSegment hyperEdge2 = targetIter.next();
                this.createDependency(hyperEdge1, hyperEdge2);
            }
        }
        SplineEdgeRouter.breakCycles(this.splineSegmentsLayer, (Random)this.lGraph.getProperty(InternalProperties.RANDOM));
        SplineEdgeRouter.topologicalNumbering(this.splineSegmentsLayer);
    }

    private void clearThenFillMappings(Layer leftLayer, Layer rightLayer) {
        LPort targetPort;
        Layer targetLayer;
        this.leftPortsLayer.clear();
        this.rightPortsLayer.clear();
        this.edgesRemainingLayer.clear();
        this.splineSegmentsLayer.clear();
        this.selfLoopsLayer.clear();
        if (leftLayer != null) {
            for (LNode node : leftLayer.getNodes()) {
                for (LPort sourcePort : node.getPorts(PortSide.EAST)) {
                    this.leftPortsLayer.add(sourcePort);
                    for (LEdge edge : sourcePort.getOutgoingEdges()) {
                        if (edge.isSelfLoop()) continue;
                        this.edgesRemainingLayer.add(edge);
                        this.findAndAddSuccessor(edge);
                        if (SplineEdgeRouter.isQualifiedAsStartingNode(edge.getSource().getNode())) {
                            this.startEdges.add(edge);
                        }
                        if ((targetLayer = (targetPort = edge.getTarget()).getNode().getLayer()).equals(rightLayer)) {
                            this.rightPortsLayer.add(targetPort);
                            continue;
                        }
                        if (targetLayer.equals(leftLayer)) {
                            this.leftPortsLayer.add(targetPort);
                            continue;
                        }
                        this.edgesRemainingLayer.remove((Object)edge);
                    }
                }
            }
        }
        if (rightLayer != null) {
            for (LNode node : rightLayer.getNodes()) {
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        if (!edge.isSelfLoop()) continue;
                        this.selfLoopsLayer.add(edge);
                    }
                }
                for (LPort sourcePort : node.getPorts(PortSide.WEST)) {
                    this.rightPortsLayer.add(sourcePort);
                    for (LEdge edge : sourcePort.getOutgoingEdges()) {
                        if (edge.isSelfLoop()) continue;
                        this.edgesRemainingLayer.add(edge);
                        this.findAndAddSuccessor(edge);
                        if (SplineEdgeRouter.isQualifiedAsStartingNode(edge.getSource().getNode())) {
                            this.startEdges.add(edge);
                        }
                        if ((targetLayer = (targetPort = edge.getTarget()).getNode().getLayer()).equals(rightLayer)) {
                            this.rightPortsLayer.add(targetPort);
                            continue;
                        }
                        if (targetLayer.equals(leftLayer)) {
                            this.leftPortsLayer.add(targetPort);
                            continue;
                        }
                        this.edgesRemainingLayer.remove((Object)edge);
                    }
                }
            }
        }
    }

    private double computeSloppySpacing(Layer rightLayer, double edgeEdgeSpacing, double nodeNodeSpacing, double sloppyLayerSpacingFactor) {
        double maxVertDiff = 0.0;
        for (LNode node : rightLayer) {
            double maxCurrInputYDiff = 0.0;
            for (LEdge incomingEdge : node.getIncomingEdges()) {
                double sourcePos = incomingEdge.getSource().getAbsoluteAnchor().y;
                double targetPos = incomingEdge.getTarget().getAbsoluteAnchor().y;
                maxCurrInputYDiff = Math.max(maxCurrInputYDiff, Math.abs(targetPos - sourcePos));
            }
            maxVertDiff = Math.max(maxVertDiff, maxCurrInputYDiff);
        }
        double layerSpacing = sloppyLayerSpacingFactor * Math.min(1.0, edgeEdgeSpacing / nodeNodeSpacing) * maxVertDiff;
        return layerSpacing;
    }

    private void findAndAddSuccessor(LEdge edge) {
        LNode targetNode = edge.getTarget().getNode();
        if (SplineEdgeRouter.isNormalNode(targetNode)) {
            return;
        }
        Iterator<LEdge> iter = targetNode.getOutgoingEdges().iterator();
        if (iter.hasNext()) {
            this.successingEdge.put(edge, iter.next());
        }
    }

    private void createSplineSegments(List<LEdge> edges, Set<LPort> leftPorts, Set<LPort> rightPorts, List<SplineSegment> hyperEdges) {
        for (LEdge edge : edges) {
            SideToProcess targetSide;
            SideToProcess sourceSide;
            LPort sourcePort = edge.getSource();
            if (leftPorts.contains((Object)sourcePort)) {
                sourceSide = SideToProcess.LEFT;
            } else if (rightPorts.contains((Object)sourcePort)) {
                sourceSide = SideToProcess.RIGHT;
            } else {
                throw new IllegalArgumentException("Source port must be in one of the port sets.");
            }
            LPort targetPort = edge.getTarget();
            if (leftPorts.contains((Object)targetPort)) {
                targetSide = SideToProcess.LEFT;
            } else if (rightPorts.contains((Object)targetPort)) {
                targetSide = SideToProcess.RIGHT;
            } else {
                throw new IllegalArgumentException("Target port must be in one of the port sets.");
            }
            SplineSegment seg = new SplineSegment(edge, sourceSide, targetSide);
            this.edgeToSegmentMap.put(edge, seg);
            hyperEdges.add(seg);
        }
    }

    private void createSplineSegmentsForHyperEdges(Set<LPort> leftPorts, Set<LPort> rightPorts, SideToProcess sideToProcess, boolean reversed, List<LEdge> edgesRemaining, List<SplineSegment> hyperEdges) {
        Set<LPort> portsToProcess = null;
        if (sideToProcess == SideToProcess.LEFT) {
            portsToProcess = leftPorts;
        } else if (sideToProcess == SideToProcess.RIGHT) {
            portsToProcess = rightPorts;
        } else assert (false) : "sideToProcess must be either LEFT or RIGHT.";
        for (LPort singlePort : portsToProcess) {
            SplineSegment seg;
            double singlePortPosition = singlePort.getAbsoluteAnchor().y;
            HashSet upEdges = Sets.newHashSet();
            HashSet downEdges = Sets.newHashSet();
            for (LEdge edge : singlePort.getConnectedEdges()) {
                if ((Boolean)edge.getProperty(InternalProperties.REVERSED) != reversed || !edgesRemaining.contains((Object)edge)) continue;
                LPort targetPort = edge.getTarget() == singlePort ? edge.getSource() : edge.getTarget();
                double targetPortPosition = targetPort.getAbsoluteAnchor().y;
                if (SplineEdgeRouter.isStraight(targetPortPosition, singlePortPosition)) continue;
                if (targetPortPosition < singlePortPosition) {
                    if (leftPorts.contains((Object)targetPort)) {
                        upEdges.add(Pair.of((Object)((Object)SideToProcess.LEFT), (Object)((Object)edge)));
                        continue;
                    }
                    upEdges.add(Pair.of((Object)((Object)SideToProcess.RIGHT), (Object)((Object)edge)));
                    continue;
                }
                if (leftPorts.contains((Object)targetPort)) {
                    downEdges.add(Pair.of((Object)((Object)SideToProcess.LEFT), (Object)((Object)edge)));
                    continue;
                }
                downEdges.add(Pair.of((Object)((Object)SideToProcess.RIGHT), (Object)((Object)edge)));
            }
            if (upEdges.size() > 1) {
                seg = new SplineSegment(singlePort, upEdges, sideToProcess);
                upEdges.forEach(e -> {
                    SplineSegment splineSegment2 = this.edgeToSegmentMap.put((LEdge)((Object)((Object)e.getSecond())), seg);
                });
                hyperEdges.add(seg);
                for (Pair pair : upEdges) {
                    edgesRemaining.remove(pair.getSecond());
                }
            }
            if (downEdges.size() <= 1) continue;
            seg = new SplineSegment(singlePort, downEdges, sideToProcess);
            downEdges.forEach(e -> {
                SplineSegment splineSegment2 = this.edgeToSegmentMap.put((LEdge)((Object)((Object)e.getSecond())), seg);
            });
            hyperEdges.add(seg);
            for (Pair pair : downEdges) {
                edgesRemaining.remove(pair.getSecond());
            }
        }
    }

    private void createDependency(SplineSegment edge0, SplineSegment edge1) {
        if (edge0.hyperEdgeTopYPos > edge1.hyperEdgeBottomYPos || edge1.hyperEdgeTopYPos > edge0.hyperEdgeBottomYPos) {
            return;
        }
        int edge0Counter = 0;
        int edge1Counter = 0;
        for (LPort port : edge0.rightPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge1.hyperEdgeTopYPos, edge1.hyperEdgeBottomYPos)) continue;
            ++edge0Counter;
        }
        for (LPort port : edge0.leftPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge1.hyperEdgeTopYPos, edge1.hyperEdgeBottomYPos)) continue;
            --edge0Counter;
        }
        for (LPort port : edge1.rightPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge0.hyperEdgeTopYPos, edge0.hyperEdgeBottomYPos)) continue;
            ++edge1Counter;
        }
        for (LPort port : edge1.leftPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge0.hyperEdgeTopYPos, edge0.hyperEdgeBottomYPos)) continue;
            --edge1Counter;
        }
        if (edge0Counter < edge1Counter) {
            new Dependency(edge0, edge1, edge1Counter - edge0Counter);
        } else if (edge1Counter < edge0Counter) {
            new Dependency(edge1, edge0, edge0Counter - edge1Counter);
        } else {
            new Dependency(edge1, edge0, 0);
            new Dependency(edge0, edge1, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void breakCycles(List<SplineSegment> edges, Random random) {
        sources = Lists.newLinkedList();
        sinks = Lists.newLinkedList();
        nextMark = -1;
        for (SplineSegment edge : edges) {
            edge.mark = nextMark--;
            inweight = 0;
            outweight = 0;
            for (Dependency dependency : edge.outgoing) {
                outweight += dependency.weight;
            }
            for (Dependency dependency : edge.incoming) {
                inweight += dependency.weight;
            }
            edge.inweight = inweight;
            edge.outweight = outweight;
            if (outweight == 0) {
                sinks.add(edge);
                continue;
            }
            if (inweight != 0) continue;
            sources.add(edge);
        }
        unprocessed = Sets.newLinkedHashSet(edges);
        markBase = edges.size();
        nextLeft = markBase + 1;
        nextRight = markBase - 1;
        maxEdges = Lists.newArrayList();
        ** GOTO lbl61
        {
            sink = (SplineSegment)sinks.removeFirst();
            unprocessed.remove(sink);
            sink.mark = nextRight--;
            SplineEdgeRouter.updateNeighbors(sink, sources, sinks);
            do {
                if (!sinks.isEmpty()) continue block3;
                while (!sources.isEmpty()) {
                    source = (SplineSegment)sources.removeFirst();
                    unprocessed.remove(source);
                    source.mark = nextLeft++;
                    SplineEdgeRouter.updateNeighbors(source, sources, sinks);
                }
                maxOutflow = -2147483648;
                for (SplineSegment edge : unprocessed) {
                    outflow = edge.outweight - edge.inweight;
                    if (outflow < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxEdges.clear();
                        maxOutflow = outflow;
                    }
                    maxEdges.add(edge);
                }
                if (maxEdges.isEmpty()) continue;
                maxEdge = (SplineSegment)maxEdges.get(random.nextInt(maxEdges.size()));
                unprocessed.remove(maxEdge);
                maxEdge.mark = nextLeft++;
                SplineEdgeRouter.updateNeighbors(maxEdge, sources, sinks);
                maxEdges.clear();
lbl61:
                // 3 sources

            } while (!unprocessed.isEmpty());
        }
        shiftBase = edges.size() + 1;
        for (SplineSegment edge : edges) {
            if (edge.mark >= markBase) continue;
            edge.mark += shiftBase;
        }
        for (SplineSegment source : edges) {
            depIter = source.outgoing.listIterator();
            while (depIter.hasNext()) {
                dependency = depIter.next();
                target = dependency.target;
                if (source.mark <= target.mark) continue;
                depIter.remove();
                target.incoming.remove(dependency);
                if (dependency.weight <= 0) continue;
                dependency.source = target;
                target.outgoing.add(dependency);
                dependency.target = source;
                source.incoming.add(dependency);
            }
        }
    }

    private static void updateNeighbors(SplineSegment edge, List<SplineSegment> sources, List<SplineSegment> sinks) {
        for (Dependency dep : edge.outgoing) {
            if (dep.target.mark >= 0 || dep.weight <= 0) continue;
            dep.target.inweight -= dep.weight;
            if (dep.target.inweight > 0 || dep.target.outweight <= 0) continue;
            sources.add(dep.target);
        }
        for (Dependency dep : edge.incoming) {
            if (dep.source.mark >= 0 || dep.weight <= 0) continue;
            dep.source.outweight -= dep.weight;
            if (dep.source.outweight > 0 || dep.source.inweight <= 0) continue;
            sinks.add(dep.source);
        }
    }

    private static void topologicalNumbering(List<SplineSegment> edges) {
        LinkedList sources = Lists.newLinkedList();
        LinkedList rightwardTargets = Lists.newLinkedList();
        for (SplineSegment edge2 : edges) {
            edge2.rank = 0;
            edge2.inweight = edge2.incoming.size();
            edge2.outweight = edge2.outgoing.size();
            if (edge2.inweight == 0) {
                sources.add(edge2);
            }
            if (edge2.outweight != 0 || !edge2.leftPorts.isEmpty()) continue;
            rightwardTargets.add(edge2);
        }
        int maxRank = -1;
        while (!sources.isEmpty()) {
            SplineSegment edge3 = (SplineSegment)sources.remove(0);
            for (Dependency dependency : edge3.outgoing) {
                SplineSegment target = dependency.target;
                target.rank = Math.max(target.rank, edge3.rank + 1);
                maxRank = Math.max(maxRank, target.rank);
                --target.inweight;
                if (target.inweight != 0) continue;
                sources.add(target);
            }
        }
        if (maxRank > -1) {
            for (SplineSegment edge : rightwardTargets) {
                edge.rank = maxRank;
            }
            while (!rightwardTargets.isEmpty()) {
                SplineSegment edge;
                edge = (SplineSegment)rightwardTargets.remove(0);
                for (Dependency dependency : edge.incoming) {
                    SplineSegment source = dependency.source;
                    if (!source.leftPorts.isEmpty()) continue;
                    source.rank = Math.min(source.rank, edge.rank - 1);
                    --source.outweight;
                    if (source.outweight != 0) continue;
                    rightwardTargets.add(source);
                }
            }
        }
    }

    static boolean isStraight(double firstY, double secondY) {
        return Math.abs(firstY - secondY) < 0.2;
    }

    private List<LEdge> getEdgeChain(LEdge start) {
        ArrayList edgeChain = Lists.newArrayList();
        LEdge current = start;
        do {
            edgeChain.add(current);
        } while ((current = this.successingEdge.get((Object)current)) != null);
        return edgeChain;
    }

    private List<SplineSegment> getSplinePath(LEdge start) {
        ArrayList segmentChain = Lists.newArrayList();
        LEdge current = start;
        do {
            SplineSegment segment = this.edgeToSegmentMap.get((Object)current);
            segment.sourcePort = current.getSource();
            segment.targetPort = current.getTarget();
            segmentChain.add(segment);
        } while ((current = this.successingEdge.get((Object)current)) != null);
        SplineSegment initialSegment = (SplineSegment)segmentChain.get(0);
        initialSegment.initialSegment = true;
        initialSegment.sourceNode = initialSegment.edges.iterator().next().getSource().getNode();
        SplineSegment lastSegment = (SplineSegment)segmentChain.get(segmentChain.size() - 1);
        lastSegment.lastSegment = true;
        lastSegment.targetNode = lastSegment.edges.iterator().next().getTarget().getNode();
        return segmentChain;
    }

    public static boolean isNormalNode(LNode node) {
        LNode.NodeType nt = node.getType();
        return nt == LNode.NodeType.NORMAL || nt == LNode.NodeType.BREAKING_POINT;
    }

    public static boolean isQualifiedAsStartingNode(LNode node) {
        LNode.NodeType nt = node.getType();
        return nt == LNode.NodeType.NORMAL || nt == LNode.NodeType.NORTH_SOUTH_PORT || nt == LNode.NodeType.EXTERNAL_PORT || nt == LNode.NodeType.BREAKING_POINT;
    }

    final class Dependency {
        private SplineSegment source;
        private SplineSegment target;
        private final int weight;

        Dependency(SplineSegment source, SplineSegment target, int weight) {
            this.source = source;
            this.target = target;
            this.weight = weight;
            source.outgoing.add(this);
            target.incoming.add(this);
        }

        public String toString() {
            return String.valueOf(this.source) + " ->(" + this.weight + ") " + String.valueOf(this.target);
        }
    }

    static enum SideToProcess {
        LEFT,
        RIGHT;

    }
}

