/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators;

import java.text.MessageFormat;
import org.eclipse.fordiac.ide.comgeneration.implementation.ChannelEnd;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.MediaSpecificGenerator;
import org.eclipse.fordiac.ide.comgeneration.plugin.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public abstract class AbstractMediaSpecificGenerator
implements MediaSpecificGenerator {
    private static final String PALETTE_ENTRY_SOURCE_LOCAL = "iec61499::net::PUBL_";
    private static final String PALETTE_ENTRY_DESTINATION_LOCAL = "iec61499::net::SUBL_";
    private static final String PALETTE_ENTRY_SOURCE = "iec61499::net::PUBLISH_";
    private static final String PALETTE_ENTRY_DESTINATION = "iec61499::net::SUBSCRIBE_";
    private final TypeLibrary typeLib;

    protected AbstractMediaSpecificGenerator(TypeLibrary typeLib) {
        this.typeLib = typeLib;
    }

    public TypeLibrary getTypeLibrary() {
        return this.typeLib;
    }

    @Override
    public FBTypeEntry getPaletteType(ChannelEnd end, int numDataPorts, boolean local) {
        Object commTypeName = local ? (end == ChannelEnd.SOURCE ? PALETTE_ENTRY_SOURCE_LOCAL : PALETTE_ENTRY_DESTINATION_LOCAL) : (end == ChannelEnd.SOURCE ? PALETTE_ENTRY_SOURCE : PALETTE_ENTRY_DESTINATION);
        commTypeName = (String)commTypeName + Integer.toString(numDataPorts);
        FBTypeEntry entry = this.getTypeLibrary().getFBTypeEntry((String)commTypeName);
        if (entry == null) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.CommGenerator_FBTypeEntryNotFound, commTypeName));
        }
        return entry;
    }

    @Override
    public VarDeclaration getTargetInputData(int index, FB fb) {
        String dataName = "SD_" + (index + 1);
        for (VarDeclaration inputVar : fb.getInterface().getInputVars()) {
            if (!inputVar.getName().equals(dataName)) continue;
            return inputVar;
        }
        return null;
    }

    @Override
    public VarDeclaration getTargetOutputData(int index, FB fb) {
        String dataName = "RD_" + (index + 1);
        for (VarDeclaration outputVar : fb.getInterface().getOutputVars()) {
            if (!outputVar.getName().equals(dataName)) continue;
            return outputVar;
        }
        return null;
    }
}

