/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.ui.providers.CommandProvider;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;
import org.eclipse.fordiac.ide.ui.providers.CreationCommandProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddDeleteWidget {
    private static final int EDIT_COLUMN = 0;
    private Button createButton;
    private Button deleteButton;
    private boolean enabled = true;
    protected Composite container;

    public void createControls(Composite parent, FormToolkit widgetFactory) {
        this.createControls(parent, widgetFactory, false);
    }

    public void createControls(Composite parent, FormToolkit widgetFactory, boolean horizontal) {
        this.container = AddDeleteWidget.createContainer(widgetFactory, parent, horizontal ? 2 : 1);
        this.createAddButton(widgetFactory, this.container);
        this.createDeleteButton(widgetFactory, this.container);
        this.setButtonEnablement(false);
    }

    public void setVisible(boolean visible) {
        AddDeleteWidget.setVisible(visible, (Control)this.container);
    }

    private static void setVisible(boolean visible, Control widget) {
        widget.setVisible(visible);
        if (widget.getLayoutData() != null) {
            ((GridData)widget.getLayoutData()).exclude = !visible;
        } else {
            widget.setLayoutData((Object)GridDataFactory.fillDefaults().exclude(!visible).create());
        }
        widget.getParent().pack();
    }

    public void setVisibleCreateButton(boolean visible) {
        AddDeleteWidget.setVisible(visible, (Control)this.createButton);
    }

    public void setVisibleDeleteButton(boolean visible) {
        AddDeleteWidget.setVisible(visible, (Control)this.deleteButton);
    }

    protected void createDeleteButton(FormToolkit widgetFactory, Composite container) {
        this.deleteButton = widgetFactory.createButton(container, "", 8);
        this.deleteButton.setToolTipText("Delete selected interface element");
        this.deleteButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.deleteButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    protected void createAddButton(FormToolkit widgetFactory, Composite container) {
        this.createButton = widgetFactory.createButton(container, "", 8);
        this.createButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.createButton.setToolTipText("Create element");
        this.createButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    protected static Composite createContainer(FormToolkit widgetFactory, Composite parent, int columns) {
        Composite container = widgetFactory.createComposite(parent, 0);
        container.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        GridLayoutFactory.fillDefaults().numColumns(columns).equalWidth(true).margins(1, 0).spacing(1, 0).applyTo(container);
        return container;
    }

    protected void setButtonEnablement(boolean enable) {
        this.deleteButton.setEnabled(enable);
        this.deleteButton.setImage(enable ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE_DISABLED"));
    }

    protected void setCreateButtonEnablement(boolean enable) {
        this.createButton.setEnabled(enable);
    }

    public void addCreateListener(Listener createListener) {
        this.createButton.addListener(13, createListener);
    }

    public void addDeleteListener(Listener deleteListener) {
        this.deleteButton.addListener(13, deleteListener);
    }

    public void bindToTableViewer(TableViewer viewer, CommandExecutor executor, CreationCommandProvider addCommand, CommandProvider deleteCommand) {
        Listener createListener = AddDeleteWidget.getAddListener(viewer, executor, addCommand);
        Listener deleteListener = AddDeleteWidget.getDeleteListener(viewer, executor, deleteCommand);
        this.bindToTableViewer(viewer, createListener, deleteListener);
    }

    public void bindToTableViewer(NatTable table, CommandExecutor executor, CommandProvider addCommand, CommandProvider deleteCommand) {
        Listener createListener = AddDeleteWidget.getAddListener(table, executor, addCommand);
        Listener deleteListener = AddDeleteWidget.getDeleteListener(table, executor, deleteCommand);
        this.bindToTableViewer(table, createListener, deleteListener);
    }

    public void bindToTableViewer(TableViewer viewer, final Listener createListener, final Listener deleteListener) {
        this.addCreateListener(createListener);
        this.addDeleteListener(deleteListener);
        viewer.addSelectionChangedListener(ev -> this.setButtonEnablement(!viewer.getSelection().isEmpty() && this.enabled));
        viewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000009 && e.stateMask == 0) {
                    createListener.handleEvent(null);
                } else if (e.character == '\u007f' && e.stateMask == 0) {
                    deleteListener.handleEvent(null);
                }
            }
        });
    }

    public void bindToTableViewer(NatTable table, final Listener createListener, final Listener deleteListener) {
        this.addCreateListener(createListener);
        this.addDeleteListener(deleteListener);
        table.addListener(13, event -> {
            SelectionLayer selectionLayer = NatTableWidgetFactory.getSelectionLayer(table);
            int[] rows = selectionLayer.getFullySelectedRowPositions();
            this.setButtonEnablement(rows.length > 0 && this.enabled);
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000009 && e.stateMask == 0) {
                    createListener.handleEvent(null);
                } else if (e.character == '\u007f' && e.stateMask == 0) {
                    deleteListener.handleEvent(null);
                }
            }
        });
    }

    public static Listener getSelectionListener(TableViewer viewer, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            if (!viewer.getStructuredSelection().isEmpty()) {
                AddDeleteWidget.executeCompoundCommandForList(viewer, viewer.getStructuredSelection().toList(), executor, commandProvider);
            }
        };
    }

    public static Listener getSelectionListener(NatTable table, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            int row;
            SelectionLayer selectionLayer = NatTableWidgetFactory.getSelectionLayer(table);
            ListDataProvider dataProvider = (ListDataProvider)NatTableWidgetFactory.getDataLayer(table).getDataProvider();
            if (!selectionLayer.hasRowSelection() || selectionLayer.isRowPositionSelected(0)) {
                return;
            }
            int[] rows = selectionLayer.getFullySelectedRowPositions();
            ArrayList<Object> rowObjects = new ArrayList<Object>();
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                row = nArray[n2];
                if (row >= 0) {
                    rowObjects.add(dataProvider.getRowObject(row));
                }
                ++n2;
            }
            if (!rowObjects.isEmpty()) {
                AddDeleteWidget.executeCompoundCommandForList(table, rowObjects, executor, commandProvider);
                nArray = rows;
                n = rows.length;
                n2 = 0;
                while (n2 < n) {
                    row = nArray[n2];
                    if (row == 0) {
                        selectionLayer.selectRow(0, row, true, true);
                    } else {
                        selectionLayer.selectRow(0, row - 1, true, true);
                    }
                    ++n2;
                }
            }
        };
    }

    protected static void executeCompoundCommandForList(TableViewer viewer, List<?> selection, CommandExecutor executor, CommandProvider commandProvider) {
        CompoundCommand cmd = new CompoundCommand();
        selection.stream().forEach(elem -> cmd.add(commandProvider.getCommand(elem)));
        executor.executeCommand((Command)cmd);
        viewer.refresh();
    }

    protected static void executeCompoundCommandForList(NatTable table, List<Object> selection, CommandExecutor executor, CommandProvider commandProvider) {
        CompoundCommand cmd = new CompoundCommand();
        selection.forEach(elem -> cmd.add(commandProvider.getCommand(elem)));
        executor.executeCommand((Command)cmd);
        table.refresh();
    }

    public static Listener getDeleteListener(TableViewer viewer, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            if (!viewer.getStructuredSelection().isEmpty()) {
                int pos = viewer.getTable().getSelectionIndices()[0];
                AddDeleteWidget.executeCompoundCommandForList(viewer, viewer.getStructuredSelection().toList(), executor, commandProvider);
                int itemCnt = viewer.getTable().getItemCount();
                if (pos <= itemCnt) {
                    if (pos == itemCnt) {
                        --pos;
                    }
                    viewer.getTable().forceFocus();
                    viewer.getTable().setSelection(pos);
                }
            }
        };
    }

    public static Listener getDeleteListener(NatTable table, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            int[] rows = NatTableWidgetFactory.getSelectionLayer(table).getFullySelectedRowPositions();
            ListDataProvider dataProvider = (ListDataProvider)NatTableWidgetFactory.getDataLayer(table).getDataProvider();
            ArrayList<Object> rowObjects = new ArrayList<Object>();
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                if (row >= 0) {
                    rowObjects.add(dataProvider.getRowObject(row));
                }
                ++n2;
            }
            if (!rowObjects.isEmpty()) {
                AddDeleteWidget.executeCompoundCommandForList(table, rowObjects, executor, commandProvider);
            }
        };
    }

    private static Listener getAddListener(TableViewer viewer, CommandExecutor executor, CreationCommandProvider commandProvider) {
        return ev -> {
            CreationCommand cmd = commandProvider.getCommand(AddDeleteWidget.getReferencedElement(viewer));
            if (cmd.canExecute()) {
                executor.executeCommand(cmd);
                viewer.refresh();
                StructuredSelection selection = new StructuredSelection(cmd.getCreatedElement());
                viewer.setSelection((ISelection)selection);
                viewer.getTable().forceFocus();
                viewer.editElement(cmd.getCreatedElement(), 0);
            }
        };
    }

    private static Listener getAddListener(NatTable table, CommandExecutor executor, CommandProvider commandProvider) {
        return ev -> {
            Object refObject = null;
            int[] rows = null;
            SelectionLayer selectionLayer = NatTableWidgetFactory.getSelectionLayer(table);
            if (selectionLayer != null && (rows = selectionLayer.getFullySelectedRowPositions()).length > 0 && rows[rows.length - 1] >= 0) {
                ListDataProvider dataProvider = (ListDataProvider)NatTableWidgetFactory.getDataLayer(table).getDataProvider();
                refObject = dataProvider.getRowObject(rows[rows.length - 1]);
            }
            Command cmd = commandProvider.getCommand(refObject);
            executor.executeCommand(cmd);
            table.refresh();
            if (selectionLayer != null && rows != null && rows.length > 0) {
                selectionLayer.selectRow(0, rows[rows.length - 1] + 1, false, false);
            }
        };
    }

    protected static Object getReferencedElement(TableViewer viewer) {
        if (!viewer.getStructuredSelection().isEmpty()) {
            return viewer.getStructuredSelection().toList().get(viewer.getStructuredSelection().size() - 1);
        }
        return null;
    }

    public Composite getControl() {
        return this.container;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setButtonEnablement(false);
        this.createButton.setEnabled(enabled);
    }
}

