/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.nat.AbstractCommandColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.AttributeDeclarationTableColumn;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeValueCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.eval.value.StructValue;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;

public class AttributeDeclarationColumnAccessor
extends AbstractCommandColumnAccessor<Attribute, AttributeDeclarationTableColumn> {
    public AttributeDeclarationColumnAccessor(CommandExecutor commandExecutor, List<AttributeDeclarationTableColumn> columns) {
        super(commandExecutor, columns);
    }

    public Object getDataValue(Attribute rowObject, AttributeDeclarationTableColumn column) {
        if (column == AttributeDeclarationTableColumn.TYPE) {
            return PackageNameHelper.getFullTypeName((LibraryElement)rowObject.getAttributeDeclaration());
        }
        if (column == AttributeDeclarationTableColumn.COMMENT) {
            return CommentHelper.getInstanceComment((INamedElement)rowObject);
        }
        if (column == AttributeDeclarationTableColumn.FILE_PATH) {
            return EcoreUtil.getURI((EObject)rowObject).toPlatformString(true);
        }
        if (column == AttributeDeclarationTableColumn.LOCATION) {
            return FordiacMarkerHelper.getLocation((EObject)rowObject);
        }
        if (column == AttributeDeclarationTableColumn.VALUE) {
            return InitialValueHelper.getInitialOrDefaultValue((Object)rowObject);
        }
        AnyDerivedType anyDerivedType = rowObject.getAttributeDeclaration().getType();
        if (anyDerivedType instanceof StructuredType) {
            StructuredType st = (StructuredType)anyDerivedType;
            String columnName = column.getDisplayName();
            StructValue value = (StructValue)ValueOperations.parseValue((String)rowObject.getValue(), (LibraryElement)st, null);
            Variable columnVariable = value.get(columnName);
            return columnVariable != null ? columnVariable.toString(true) : null;
        }
        return null;
    }

    @Override
    public Command createCommand(Attribute rowObject, AttributeDeclarationTableColumn column, Object newValue) {
        if (column == AttributeDeclarationTableColumn.COMMENT) {
            return new ChangeCommentCommand((INamedElement)rowObject, Objects.toString(newValue, ""));
        }
        if (column == AttributeDeclarationTableColumn.VALUE) {
            return new ChangeAttributeValueCommand(rowObject, Objects.toString(newValue, ""));
        }
        AnyDerivedType anyDerivedType = rowObject.getAttributeDeclaration().getType();
        if (anyDerivedType instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)anyDerivedType;
            String columnName = column.getDisplayName();
            StructValue value = new StructValue((StructValue)ValueOperations.parseValue((String)rowObject.getValue(), (LibraryElement)structuredType, null));
            value.get(columnName).setValue((String)newValue);
            return new ChangeAttributeValueCommand(rowObject, value.toString(true));
        }
        return null;
    }
}

