/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.model.commands.create.CreateApplicationCommand;
import org.eclipse.fordiac.ide.model.dataimport.SystemImporter;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;

public class SystemCreator {
    private final IFile systemFile;
    private final String packageName;
    private final String applicationName;
    private SystemEntry entry;

    public SystemCreator(IContainer location, String name, String applicationName) {
        this(location.getFile((IPath)new Path(name + ".sys")), applicationName);
    }

    public SystemCreator(IFile systemFile, String applicationName) {
        this(systemFile, PackageNameHelper.getPackageNameFromFile((IFile)systemFile), applicationName);
    }

    public SystemCreator(IFile systemFile, String packageName, String applicationName) {
        this.systemFile = systemFile;
        this.packageName = packageName;
        this.applicationName = applicationName;
    }

    public void createSystem(IProgressMonitor monitor) throws CoreException {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(this.systemFile.getProject());
        this.entry = (SystemEntry)typeLibrary.createTypeEntry(this.systemFile);
        AutomationSystem system = SystemImporter.createAutomationSystem();
        system.setName(TypeEntry.getTypeNameFromFile((IFile)this.systemFile));
        PackageNameHelper.setPackageName((LibraryElement)system, (String)this.packageName);
        TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)system, this.systemFile.getProject());
        this.createApplication(system);
        this.entry.save((LibraryElement)system, monitor);
    }

    private void createApplication(AutomationSystem system) {
        CreateApplicationCommand command;
        if (this.applicationName != null && (command = new CreateApplicationCommand(system, this.applicationName)).canExecute()) {
            command.execute();
        }
    }

    public SystemEntry getEntry() {
        return this.entry;
    }

    public AutomationSystem getSystem() {
        return this.entry.getType();
    }

    public Application getApplication() {
        return this.getSystem().getApplicationNamed(this.applicationName);
    }

    public IFile getSystemFile() {
        return this.systemFile;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

