/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.ConfigurableMoveFBEditPart;
import org.eclipse.fordiac.ide.application.properties.memberaccess.MemberAccessContentProvider;
import org.eclipse.fordiac.ide.application.properties.memberaccess.MemberAccessLabelProvider;
import org.eclipse.fordiac.ide.application.properties.memberaccess.MemberAccessTree;
import org.eclipse.fordiac.ide.application.properties.memberaccess.MemberAccessTreeNode;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.widgets.TypeSelectionWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangePinVisibilityCommand;
import org.eclipse.fordiac.ide.model.commands.change.ConfigureFBCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableMoveFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.DataTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConfigurableMoveFBSection
extends AbstractSection
implements CommandStackEventListener {
    private TypeSelectionWidget typeSelectionWidget;
    private CLabel configurableFbLabel;
    private TreeViewer inputDataMemberAccessViewer;
    private TreeViewer outputDataMemberAccessViewer;
    private final Adapter interfaceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (!notification.isTouch()) {
                ConfigurableMoveFBSection.this.updateVisibility();
            }
        }
    };

    protected FBNetworkElement getInputType(Object input) {
        if (input instanceof ConfigurableMoveFBEditPart) {
            ConfigurableMoveFBEditPart ep = (ConfigurableMoveFBEditPart)((Object)input);
            return ep.getModel();
        }
        if (input instanceof ConfigurableMoveFB) {
            ConfigurableMoveFB fb = (ConfigurableMoveFB)input;
            return fb;
        }
        return null;
    }

    protected ConfigurableMoveFB getType() {
        Object object = this.type;
        if (object instanceof ConfigurableMoveFB) {
            ConfigurableMoveFB fb = (ConfigurableMoveFB)object;
            return fb;
        }
        return null;
    }

    private void createDataTypeSelector(Composite composite) {
        Composite structComp = this.getWidgetFactory().createComposite(composite);
        structComp.setLayout((Layout)new GridLayout(2, false));
        structComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.configurableFbLabel = this.getWidgetFactory().createCLabel(structComp, Messages.ConfigurableMoveFBSection_DataType);
        this.typeSelectionWidget = new TypeSelectionWidget(this.getWidgetFactory(), this::handleSelectionChanged);
        this.typeSelectionWidget.createControls(structComp);
        this.typeSelectionWidget.setEditable(true);
    }

    protected ICheckStateListener getCheckStateListener() {
        return event -> {
            MemberAccessTreeNode node = (MemberAccessTreeNode)event.getElement();
            ChangePinVisibilityCommand cmd = new ChangePinVisibilityCommand((BlockFBNetworkElement)this.getType(), node.getNamePath(), event.getChecked());
            if (cmd.canExecute()) {
                this.executeCommand((Command)cmd);
            } else {
                ((TreeViewer)event.getSource()).update((Object)node, null);
            }
        };
    }

    protected void handleSelectionChanged(String newTypeName) {
        if (this.getType() != null && this.newDataTypeSelected(newTypeName)) {
            DataType newDtp = this.getDataTypeLib().getTypeIfExists(newTypeName);
            ConfigureFBCommand cmd = new ConfigureFBCommand((ConfigurableFB)this.getType(), newDtp);
            this.executeCommand((Command)cmd);
            ConfigurableMoveFBSection.updateFB((FB)cmd.getNewElement());
        }
    }

    public boolean newDataTypeSelected(String newDtpName) {
        return !newDtpName.equalsIgnoreCase(PackageNameHelper.getFullTypeName((LibraryElement)this.getType().getDataType())) && this.getDataTypeLib().getTypeIfExists(newDtpName) != null;
    }

    protected static void updateFB(FB newFb) {
        EditorPart activeEditor = (EditorPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        GraphicalViewer viewer = (GraphicalViewer)activeEditor.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            viewer.flush();
            EditorUtils.refreshPropertySheetWithSelection((IEditorPart)activeEditor, (EditPartViewer)viewer, (Object)viewer.getEditPartForModel((Object)newFb));
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createDataTypeSelector(parent);
        this.createMemberAccessTables(parent);
    }

    private void createMemberAccessTables(Composite parent) {
        Composite memberAccessComp = this.getWidgetFactory().createComposite(parent);
        memberAccessComp.setLayout((Layout)new GridLayout(2, true));
        GridDataFactory fillGrabData = GridDataFactory.fillDefaults().align(4, 4).grab(true, true);
        fillGrabData.applyTo((Control)memberAccessComp);
        Group inputsGroup = this.getWidgetFactory().createGroup(memberAccessComp, Messages.ConfigurableMoveFBSection_Inputs);
        fillGrabData.applyTo((Control)inputsGroup);
        this.inputDataMemberAccessViewer = this.createMemberAccessViewer((Composite)inputsGroup);
        Group outputsGroup = this.getWidgetFactory().createGroup(memberAccessComp, Messages.ConfigurableMoveFBSection_Outputs);
        fillGrabData.applyTo((Control)outputsGroup);
        this.outputDataMemberAccessViewer = this.createMemberAccessViewer((Composite)outputsGroup);
    }

    private TreeViewer createMemberAccessViewer(Composite parent) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent);
        viewer.setUseHashlookup(true);
        viewer.setAutoExpandLevel(2);
        ConfigurableMoveFBSection.configureTreeLayout(parent, (TreeViewer)viewer);
        viewer.setContentProvider((IContentProvider)new MemberAccessContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MemberAccessLabelProvider());
        viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof MemberAccessTreeNode) {
                    MemberAccessTreeNode memAccessTreeNode = (MemberAccessTreeNode)element;
                    return memAccessTreeNode.isVisible();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        viewer.addCheckStateListener(this.getCheckStateListener());
        return viewer;
    }

    private static void configureTreeLayout(Composite parent, TreeViewer viewer) {
        TreeColumnLayout layout = new TreeColumnLayout();
        parent.setLayout((Layout)layout);
        TreeViewerColumn variableName = new TreeViewerColumn(viewer, 16384);
        TreeViewerColumn variableType = new TreeViewerColumn(viewer, 16384);
        TreeViewerColumn comment = new TreeViewerColumn(viewer, 16384);
        viewer.getTree().setHeaderVisible(true);
        variableName.getColumn().setResizable(true);
        variableType.getColumn().setResizable(true);
        variableName.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_NAME);
        variableType.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_TYPE);
        comment.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_COMMENT);
        layout.setColumnData((Widget)variableName.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, true));
        layout.setColumnData((Widget)variableType.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, true));
        layout.setColumnData((Widget)comment.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, true));
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.setCurrentCommandStack(part, input);
        if (this.getCurrentCommandStack() == null) {
            this.configurableFbLabel.setEnabled(false);
        }
        this.setType(input);
        this.typeSelectionWidget.initialize((ConfigurableObject)this.getType(), (ITypeSelectionContentProvider)DataTypeSelectionContentProvider.INSTANCE, (ITreeContentProvider)DataTypeSelectionTreeContentProvider.INSTANCE);
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    protected void setType(Object input) {
        this.removeInterfaceAdapter();
        super.setType(input);
        this.addInterfaceAdapter();
    }

    private void addInterfaceAdapter() {
        ConfigurableMoveFB typeCache = this.getType();
        if (typeCache != null && !typeCache.getInterface().eAdapters().contains((Object)this.interfaceAdapter)) {
            typeCache.getInterface().eAdapters().add((Object)this.interfaceAdapter);
        }
    }

    private void removeInterfaceAdapter() {
        ConfigurableMoveFB typeCache = this.getType();
        if (typeCache != null && typeCache.getInterface().eAdapters().contains((Object)this.interfaceAdapter)) {
            typeCache.getInterface().eAdapters().remove((Object)this.interfaceAdapter);
        }
    }

    public void dispose() {
        this.removeInterfaceAdapter();
        super.dispose();
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public void stackChanged(CommandStackEvent event) {
        Display.getDefault().asyncExec(() -> {
            ConfigureFBCommand cmd;
            Command command;
            if (!(event.getDetail() != 32 && event.getDetail() != 16 || !((command = event.getCommand()) instanceof ConfigureFBCommand) || (cmd = (ConfigureFBCommand)command).getOldElement() != this.getType() && cmd.getNewElement() != this.getType())) {
                if (event.getDetail() == 32) {
                    ConfigurableMoveFBSection.updateFB((FB)cmd.getOldElement());
                } else if (event.getDetail() == 16) {
                    ConfigurableMoveFBSection.updateFB((FB)cmd.getNewElement());
                }
            }
        });
    }

    protected void performRefresh() {
        MemberAccessTree memAccessTree;
        Object object;
        MemberAccessTree memAccessTree2;
        Object object2;
        this.typeSelectionWidget.refresh();
        if (this.getType() == null) {
            this.inputDataMemberAccessViewer.setInput(null);
            this.outputDataMemberAccessViewer.setInput(null);
        }
        if (!((object2 = this.inputDataMemberAccessViewer.getInput()) instanceof MemberAccessTree) || (memAccessTree2 = (MemberAccessTree)object2).getBlockFBNetworkElement() != this.getType()) {
            this.inputDataMemberAccessViewer.setInput((Object)new MemberAccessTree((BlockFBNetworkElement)this.getType(), (List<VarDeclaration>)this.getType().getInterface().getInputVars()));
        }
        if (!((object = this.outputDataMemberAccessViewer.getInput()) instanceof MemberAccessTree) || (memAccessTree = (MemberAccessTree)object).getBlockFBNetworkElement() != this.getType()) {
            this.outputDataMemberAccessViewer.setInput((Object)new MemberAccessTree((BlockFBNetworkElement)this.getType(), (List<VarDeclaration>)this.getType().getInterface().getOutputVars()));
        }
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.updateVisibility(this.inputDataMemberAccessViewer, this.getType().getInterface().getAllInterfaceElements().filter(ie -> {
            if (!(ie instanceof VarDeclaration)) return false;
            VarDeclaration vardecl = (VarDeclaration)ie;
            if (!ie.isIsInput()) return false;
            if (vardecl.isInOutVar()) return false;
            return true;
        }));
        this.updateVisibility(this.outputDataMemberAccessViewer, this.getType().getInterface().getAllInterfaceElements().filter(ie -> {
            if (!(ie instanceof VarDeclaration)) return false;
            VarDeclaration vardecl = (VarDeclaration)ie;
            if (ie.isIsInput()) return false;
            if (vardecl.isInOutVar()) return false;
            return true;
        }));
    }

    private void updateVisibility(TreeViewer viewer, Stream<IInterfaceElement> vars) {
        MemberAccessTree memAccessTree = (MemberAccessTree)viewer.getInput();
        vars.forEach(ie -> {
            MemberAccessTreeNode node = memAccessTree.getChild(ie.getRelativeName((INamedElement)this.getType()));
            if (node != null && node.isVisible() != ie.isVisible()) {
                node.setVisible(ie.isVisible());
                viewer.update((Object)node, null);
            }
        });
    }
}

