/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.listeners;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.model.commands.QualNameChange;
import org.eclipse.fordiac.ide.model.commands.QualNameChangeListener;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.ui.UtilityMarkerHelper;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;

public class UtilityMarkerListener
extends QualNameChangeListener {
    public void onCommandExecuted(List<QualNameChange> qualNameChange) {
        UtilityMarkerListener.removeInvalidMarkers(qualNameChange);
        super.onCommandExecuted(qualNameChange);
    }

    public void onCommandUndoExecuted(List<QualNameChange> qualNameChange) {
        UtilityMarkerListener.removeInvalidMarkers(qualNameChange);
        super.onCommandUndoExecuted(qualNameChange);
    }

    public void onCommandRedoExecuted(List<QualNameChange> qualNameChange) {
        UtilityMarkerListener.removeInvalidMarkers(qualNameChange);
        super.onCommandRedoExecuted(qualNameChange);
    }

    protected List<AbstractOperation> constructExecutableOperations(QualNameChange change, Object receiver) {
        return Collections.emptyList();
    }

    protected List<AbstractOperation> constructExecutableUndoOperations(QualNameChange change, Object receiver) {
        return Collections.emptyList();
    }

    protected Object getReceiver(TypeEntry key) {
        return null;
    }

    protected void executeOperation(AbstractOperation op) {
    }

    private static void removeInvalidMarkers(List<QualNameChange> qualNameChange) {
        HashSet oldQualNames = new HashSet();
        qualNameChange.stream().map(QualNameChange::oldQualName).forEach(oldQualNames::add);
        UtilityMarkerListener.getAllUtilityMarkers().filter(m -> oldQualNames.contains(UtilityMarkerListener.getLocation(m))).forEach(m -> {
            try {
                UtilityMarkerHelper.deleteElementMarker((String)m.getType(), (IResource)m.getResource());
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        });
    }

    private static Stream<IMarker> getAllUtilityMarkers() {
        LibraryElement libElement = (LibraryElement)EditorUtils.getCurrentActiveEditor().getAdapter(LibraryElement.class);
        if (UtilityMarkerListener.utilityMarkerTargetLibraryElement(libElement)) {
            try {
                IFile file = libElement.getTypeEntry().getFile();
                return Stream.concat(Stream.of(file.findMarkers("org.eclipse.fordiac.ide.model.ui.connectionSource", false, 0)), Stream.of(file.findMarkers("org.eclipse.fordiac.ide.model.ui.predecessor", false, 0)));
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)"Cannot fetch marker", (Throwable)e);
            }
        }
        return Stream.empty();
    }

    private static boolean utilityMarkerTargetLibraryElement(LibraryElement libElement) {
        return libElement instanceof AutomationSystem || libElement instanceof SubAppType || libElement instanceof CompositeFBType;
    }

    public static String getLocation(IMarker m) {
        if (m != null) {
            try {
                String containerLocation;
                int lastDot;
                if (m.getType().equals("org.eclipse.fordiac.ide.model.ui.connectionSource") && (lastDot = (containerLocation = m.getAttribute("location", "")).lastIndexOf(46)) != -1) {
                    return containerLocation.substring(0, lastDot);
                }
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
            return m.getAttribute("location", "");
        }
        return "";
    }
}

